/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.ConfigurationUtil;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.LimitedPrivate(value={"HBase"})
@InterfaceStability.Evolving
public class MultiTableSnapshotInputFormatImpl {
    private static final Log LOG = LogFactory.getLog(MultiTableSnapshotInputFormatImpl.class);
    public static final String RESTORE_DIRS_KEY = "hbase.MultiTableSnapshotInputFormat.restore.snapshotDirMapping";
    public static final String SNAPSHOT_TO_SCANS_KEY = "hbase.MultiTableSnapshotInputFormat.snapshotsToScans";

    public void setInput(Configuration conf, Map<String, Collection<Scan>> snapshotScans, Path restoreDir) throws IOException {
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        this.setSnapshotToScans(conf, snapshotScans);
        Map<String, Path> restoreDirs = this.generateSnapshotToRestoreDirMapping(snapshotScans.keySet(), restoreDir);
        this.setSnapshotDirs(conf, restoreDirs);
        this.restoreSnapshots(conf, restoreDirs, fs);
    }

    public List<TableSnapshotInputFormatImpl.InputSplit> getSplits(Configuration conf) throws IOException {
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        ArrayList rtn = Lists.newArrayList();
        Map<String, Collection<Scan>> snapshotsToScans = this.getSnapshotsToScans(conf);
        Map<String, Path> snapshotsToRestoreDirs = this.getSnapshotDirs(conf);
        for (Map.Entry<String, Collection<Scan>> entry : snapshotsToScans.entrySet()) {
            String snapshotName = entry.getKey();
            Path restoreDir = snapshotsToRestoreDirs.get(snapshotName);
            SnapshotManifest manifest = TableSnapshotInputFormatImpl.getSnapshotManifest(conf, snapshotName, rootDir, fs);
            List<HRegionInfo> regionInfos = TableSnapshotInputFormatImpl.getRegionInfosFromManifest(manifest);
            for (Scan scan : entry.getValue()) {
                List<TableSnapshotInputFormatImpl.InputSplit> splits = TableSnapshotInputFormatImpl.getSplits(scan, manifest, regionInfos, restoreDir, conf);
                rtn.addAll(splits);
            }
        }
        return rtn;
    }

    public Map<String, Collection<Scan>> getSnapshotsToScans(Configuration conf) throws IOException {
        HashMap rtn = Maps.newHashMap();
        for (Map.Entry<String, String> entry : ConfigurationUtil.getKeyValues(conf, SNAPSHOT_TO_SCANS_KEY)) {
            String snapshotName = entry.getKey();
            String scan = entry.getValue();
            Collection snapshotScans = (Collection)rtn.get(snapshotName);
            if (snapshotScans == null) {
                snapshotScans = Lists.newArrayList();
                rtn.put(snapshotName, snapshotScans);
            }
            snapshotScans.add(TableMapReduceUtil.convertStringToScan(scan));
        }
        return rtn;
    }

    public void setSnapshotToScans(Configuration conf, Map<String, Collection<Scan>> snapshotScans) throws IOException {
        ArrayList snapshotToSerializedScans = Lists.newArrayList();
        for (Map.Entry<String, Collection<Scan>> entry : snapshotScans.entrySet()) {
            String snapshotName = entry.getKey();
            Collection<Scan> scans = entry.getValue();
            for (Scan scan : scans) {
                snapshotToSerializedScans.add(new AbstractMap.SimpleImmutableEntry<String, String>(snapshotName, TableMapReduceUtil.convertScanToString(scan)));
            }
        }
        ConfigurationUtil.setKeyValues(conf, SNAPSHOT_TO_SCANS_KEY, snapshotToSerializedScans);
    }

    public Map<String, Path> getSnapshotDirs(Configuration conf) throws IOException {
        List<Map.Entry<String, String>> kvps = ConfigurationUtil.getKeyValues(conf, RESTORE_DIRS_KEY);
        HashMap rtn = Maps.newHashMapWithExpectedSize((int)kvps.size());
        for (Map.Entry<String, String> kvp : kvps) {
            rtn.put(kvp.getKey(), new Path(kvp.getValue()));
        }
        return rtn;
    }

    public void setSnapshotDirs(Configuration conf, Map<String, Path> snapshotDirs) {
        HashMap toSet = Maps.newHashMap();
        for (Map.Entry<String, Path> entry : snapshotDirs.entrySet()) {
            toSet.put(entry.getKey(), entry.getValue().toString());
        }
        ConfigurationUtil.setKeyValues(conf, RESTORE_DIRS_KEY, toSet.entrySet());
    }

    private Map<String, Path> generateSnapshotToRestoreDirMapping(Collection<String> snapshots, Path baseRestoreDir) {
        HashMap rtn = Maps.newHashMap();
        for (String snapshotName : snapshots) {
            Path restoreSnapshotDir = new Path(baseRestoreDir, snapshotName + "__" + UUID.randomUUID().toString());
            rtn.put(snapshotName, restoreSnapshotDir);
        }
        return rtn;
    }

    public void restoreSnapshots(Configuration conf, Map<String, Path> snapshotToDir, FileSystem fs) throws IOException {
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        for (Map.Entry<String, Path> entry : snapshotToDir.entrySet()) {
            String snapshotName = entry.getKey();
            Path restoreDir = entry.getValue();
            LOG.info((Object)("Restoring snapshot " + snapshotName + " into " + restoreDir + " for MultiTableSnapshotInputFormat"));
            this.restoreSnapshot(conf, snapshotName, rootDir, restoreDir, fs);
        }
    }

    void restoreSnapshot(Configuration conf, String snapshotName, Path rootDir, Path restoreDir, FileSystem fs) throws IOException {
        RestoreSnapshotHelper.copySnapshotForScanner(conf, fs, rootDir, restoreDir, snapshotName);
    }
}

