/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.NormalUserScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.RawScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanWildcardColumnTracker;

@InterfaceAudience.Private
public abstract class UserScanQueryMatcher
extends ScanQueryMatcher {
    protected final boolean hasNullColumn;
    protected final Filter filter;
    protected final byte[] stopRow;
    protected final TimeRange tr;

    private static Cell createStartKey(Scan scan, ScanInfo scanInfo) {
        if (scan.includeStartRow()) {
            return UserScanQueryMatcher.createStartKeyFromRow(scan.getStartRow(), scanInfo);
        }
        return KeyValueUtil.createLastOnRow((byte[])scan.getStartRow());
    }

    protected UserScanQueryMatcher(Scan scan, ScanInfo scanInfo, ColumnTracker columns, boolean hasNullColumn, long oldestUnexpiredTS, long now) {
        super(UserScanQueryMatcher.createStartKey(scan, scanInfo), scanInfo, columns, oldestUnexpiredTS, now);
        this.hasNullColumn = hasNullColumn;
        this.filter = scan.getFilter();
        this.stopRow = scan.getStopRow();
        TimeRange timeRange = (TimeRange)scan.getColumnFamilyTimeRange().get(scanInfo.getFamily());
        this.tr = timeRange == null ? scan.getTimeRange() : timeRange;
    }

    @Override
    public boolean hasNullColumnInQuery() {
        return this.hasNullColumn;
    }

    @Override
    public boolean isUserScan() {
        return true;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Cell getNextKeyHint(Cell cell) throws IOException {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getNextCellHint(cell);
    }

    protected final ScanQueryMatcher.MatchCode matchColumn(Cell cell, long timestamp, byte typeByte) throws IOException {
        int tsCmp = this.tr.compare(timestamp);
        if (tsCmp > 0) {
            return ScanQueryMatcher.MatchCode.SKIP;
        }
        int qualifierOffset = cell.getQualifierOffset();
        int qualifierLength = cell.getQualifierLength();
        if (tsCmp < 0) {
            return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
        }
        ScanQueryMatcher.MatchCode colChecker = this.columns.checkColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength, typeByte);
        if (colChecker != ScanQueryMatcher.MatchCode.INCLUDE) {
            return colChecker;
        }
        Filter.ReturnCode filterResponse = Filter.ReturnCode.SKIP;
        if (this.filter != null) {
            filterResponse = this.filter.filterKeyValue(cell);
            switch (filterResponse) {
                case SKIP: {
                    return ScanQueryMatcher.MatchCode.SKIP;
                }
                case NEXT_COL: {
                    return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
                }
                case NEXT_ROW: {
                    return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
                }
                case SEEK_NEXT_USING_HINT: {
                    return ScanQueryMatcher.MatchCode.SEEK_NEXT_USING_HINT;
                }
            }
        }
        colChecker = this.columns.checkVersions(cell.getQualifierArray(), qualifierOffset, qualifierLength, timestamp, typeByte, false);
        return filterResponse == Filter.ReturnCode.INCLUDE_AND_NEXT_COL && colChecker == ScanQueryMatcher.MatchCode.INCLUDE ? ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL : colChecker;
    }

    protected abstract boolean isGet();

    protected abstract boolean moreRowsMayExistsAfter(int var1);

    @Override
    public boolean moreRowsMayExistAfter(Cell cell) {
        if (this.isGet()) {
            return false;
        }
        if (this.stopRow == null || this.stopRow.length == 0) {
            return true;
        }
        return this.moreRowsMayExistsAfter(this.rowComparator.compareRows(cell, this.stopRow, 0, this.stopRow.length));
    }

    public static UserScanQueryMatcher create(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, long oldestUnexpiredTS, long now, RegionCoprocessorHost regionCoprocessorHost) throws IOException {
        ColumnTracker columnTracker;
        boolean hasNullColumn;
        int maxVersions;
        int n = maxVersions = scan.isRaw() ? scan.getMaxVersions() : Math.min(scan.getMaxVersions(), scanInfo.getMaxVersions());
        if (columns == null || columns.size() == 0) {
            hasNullColumn = true;
            columnTracker = new ScanWildcardColumnTracker(scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        } else {
            hasNullColumn = ((byte[])columns.first()).length == 0;
            columnTracker = new ExplicitColumnTracker(columns, scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        }
        if (scan.isRaw()) {
            return RawScanQueryMatcher.create(scan, scanInfo, columnTracker, hasNullColumn, oldestUnexpiredTS, now);
        }
        return NormalUserScanQueryMatcher.create(scan, scanInfo, columnTracker, hasNullColumn, oldestUnexpiredTS, now, regionCoprocessorHost);
    }
}

