/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class MetricsWAL
extends WALActionsListener.Base {
    private static final Log LOG = LogFactory.getLog(MetricsWAL.class);
    private final MetricsWALSource source;

    public MetricsWAL() {
        this((MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class));
    }

    MetricsWAL(MetricsWALSource s) {
        this.source = s;
    }

    @Override
    public void postSync(long timeInNanos, int handlerSyncs) {
        this.source.incrementSyncTime(timeInNanos / 1000000L);
    }

    @Override
    public void postAppend(long size, long time, WALKey logkey, WALEdit logEdit) throws IOException {
        TableName tableName = logkey.getTablename();
        this.source.incrementAppendCount(tableName);
        this.source.incrementAppendTime(time);
        this.source.incrementAppendSize(tableName, size);
        this.source.incrementWrittenBytes(size);
        if (time > 1000L) {
            this.source.incrementSlowAppendCount();
            LOG.warn((Object)String.format("%s took %d ms appending an edit to wal; len~=%s", Thread.currentThread().getName(), time, StringUtils.humanReadableInt((long)size)));
        }
    }

    @Override
    public void logRollRequested(WALActionsListener.RollRequestReason reason) {
        this.source.incrementLogRollRequested();
        switch (reason) {
            case ERROR: {
                this.source.incrementErrorLogRoll();
                break;
            }
            case LOW_REPLICATION: {
                this.source.incrementLowReplicationLogRoll();
                break;
            }
            case SIZE: {
                this.source.incrementSizeLogRoll();
                break;
            }
            case SLOW_SYNC: {
                this.source.incrementSlowSyncLogRoll();
                break;
            }
        }
    }

    @Override
    public void postLogRoll(Path oldPath, Path newPath) {
        if (newPath != oldPath) {
            this.source.incrementSuccessfulLogRolls();
        }
    }
}

