/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.security.visibility.VisibilityExpEvaluator;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;

@InterfaceAudience.Private
class VisibilityLabelFilter
extends FilterBase {
    private final VisibilityExpEvaluator expEvaluator;
    private final Map<ByteRange, Integer> cfVsMaxVersions;
    private final ByteRange curFamily;
    private final ByteRange curQualifier;
    private int curFamilyMaxVersions;
    private int curQualMetVersions;

    public VisibilityLabelFilter(VisibilityExpEvaluator expEvaluator, Map<ByteRange, Integer> cfVsMaxVersions) {
        this.expEvaluator = expEvaluator;
        this.cfVsMaxVersions = cfVsMaxVersions;
        this.curFamily = new SimpleMutableByteRange();
        this.curQualifier = new SimpleMutableByteRange();
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        if (this.curFamily.getBytes() == null || Bytes.compareTo((byte[])this.curFamily.getBytes(), (int)this.curFamily.getOffset(), (int)this.curFamily.getLength(), (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()) != 0) {
            this.curFamily.set(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength());
            this.curFamilyMaxVersions = this.cfVsMaxVersions.get(this.curFamily);
            this.curQualifier.unset();
        }
        if (this.curQualifier.getBytes() == null || Bytes.compareTo((byte[])this.curQualifier.getBytes(), (int)this.curQualifier.getOffset(), (int)this.curQualifier.getLength(), (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) != 0) {
            this.curQualifier.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            this.curQualMetVersions = 0;
        }
        ++this.curQualMetVersions;
        if (this.curQualMetVersions > this.curFamilyMaxVersions) {
            return Filter.ReturnCode.SKIP;
        }
        return this.expEvaluator.evaluate(cell) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
    }

    public Cell transformCell(Cell v) {
        return v;
    }

    public void reset() throws IOException {
        this.curFamily.unset();
        this.curQualifier.unset();
        this.curFamilyMaxVersions = 0;
        this.curQualMetVersions = 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VisibilityLabelFilter)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        VisibilityLabelFilter f = (VisibilityLabelFilter)((Object)obj);
        return this.expEvaluator.equals(f.expEvaluator) && this.cfVsMaxVersions.equals(f.cfVsMaxVersions);
    }

    public int hashCode() {
        return Objects.hash(this.expEvaluator, this.cfVsMaxVersions);
    }
}

