/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.cleaner.ReplicationZKNodeCleaner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationZKNodeCleanerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationZKNodeCleanerChore.class);
    private final ReplicationZKNodeCleaner cleaner;

    public ReplicationZKNodeCleanerChore(Stoppable stopper, int period, ReplicationZKNodeCleaner cleaner) {
        super("ReplicationZKNodeCleanerChore", stopper, period);
        this.cleaner = cleaner;
    }

    protected void chore() {
        try {
            Map<String, List<String>> undeletedQueues = this.cleaner.getUnDeletedQueues();
            this.cleaner.removeQueues(undeletedQueues);
        }
        catch (IOException e) {
            LOG.warn("Failed to clean replication zk node", (Throwable)e);
        }
    }
}

