/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.procedure.ProcedureManagerHost;
import org.apache.hadoop.hbase.procedure.RegionServerProcedureManager;
import org.apache.hadoop.hbase.procedure.flush.RegionServerFlushTableProcedureManager;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.snapshot.RegionServerSnapshotManager;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionServerProcedureManagerHost
extends ProcedureManagerHost<RegionServerProcedureManager> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerProcedureManagerHost.class);

    public void initialize(RegionServerServices rss) throws KeeperException {
        for (RegionServerProcedureManager proc : this.procedures) {
            LOG.debug("Procedure " + proc.getProcedureSignature() + " is initializing");
            proc.initialize(rss);
            LOG.debug("Procedure " + proc.getProcedureSignature() + " is initialized");
        }
    }

    public void start() {
        for (RegionServerProcedureManager proc : this.procedures) {
            LOG.debug("Procedure " + proc.getProcedureSignature() + " is starting");
            proc.start();
            LOG.debug("Procedure " + proc.getProcedureSignature() + " is started");
        }
    }

    public void stop(boolean force) {
        for (RegionServerProcedureManager proc : this.procedures) {
            try {
                proc.stop(force);
            }
            catch (IOException e) {
                LOG.warn("Failed to close procedure " + proc.getProcedureSignature() + " cleanly", (Throwable)e);
            }
        }
    }

    @Override
    public void loadProcedures(Configuration conf) {
        this.loadUserProcedures(conf, "hbase.procedure.regionserver.classes");
        this.procedures.add(new RegionServerSnapshotManager());
        this.procedures.add(new RegionServerFlushTableProcedureManager());
    }
}

