/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellChunkMap;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CellChunkImmutableSegment
extends ImmutableSegment {
    public static final long DEEP_OVERHEAD_CCM = ImmutableSegment.DEEP_OVERHEAD + (long)ClassSize.CELL_CHUNK_MAP;

    protected CellChunkImmutableSegment(CellComparator comparator, MemStoreSegmentsIterator iterator, MemStoreLAB memStoreLAB, int numOfCells, MemStoreCompactionStrategy.Action action) {
        super(null, comparator, memStoreLAB);
        this.incSize(0L, DEEP_OVERHEAD_CCM);
        this.initializeCellSet(numOfCells, iterator, action);
    }

    protected CellChunkImmutableSegment(CSLMImmutableSegment segment, MemStoreSizing memstoreSizing, MemStoreCompactionStrategy.Action action) {
        super(segment);
        this.incSize(0L, -CSLMImmutableSegment.DEEP_OVERHEAD_CSLM + DEEP_OVERHEAD_CCM);
        int numOfCells = segment.getCellsCount();
        this.reinitializeCellSet(numOfCells, segment.getScanner(Long.MAX_VALUE), segment.getCellSet(), action);
        long newSegmentSizeDelta = (long)numOfCells * (this.indexEntrySize() - (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY);
        this.incSize(0L, newSegmentSizeDelta);
        memstoreSizing.incMemStoreSize(0L, newSegmentSizeDelta);
    }

    @Override
    protected long indexEntrySize() {
        return ClassSize.CELL_CHUNK_MAP_ENTRY - KeyValue.FIXED_OVERHEAD;
    }

    @Override
    protected boolean canBeFlattened() {
        return false;
    }

    private void initializeCellSet(int numOfCells, MemStoreSegmentsIterator iterator, MemStoreCompactionStrategy.Action action) {
        int chunkSize = ChunkCreator.getInstance().getChunkSize();
        int numOfCellsInChunk = CellChunkMap.NUM_OF_CELL_REPS_IN_CHUNK;
        int numberOfChunks = this.calculateNumberOfChunks(numOfCells, numOfCellsInChunk);
        int numOfCellsAfterCompaction = 0;
        int currentChunkIdx = 0;
        int offsetInCurentChunk = 4;
        int numUniqueKeys = 0;
        Cell prev = null;
        Chunk[] chunks = new Chunk[numberOfChunks];
        for (int i = 0; i < numberOfChunks; ++i) {
            chunks[i] = this.getMemStoreLAB().getNewExternalChunk();
        }
        while (iterator.hasNext()) {
            boolean alreadyCopied = false;
            Cell c = (Cell)iterator.next();
            ++numOfCellsAfterCompaction;
            assert (c instanceof ExtendedCell);
            if (((ExtendedCell)c).getChunkId() == -1) {
                c = this.copyCellIntoMSLAB(c);
                alreadyCopied = true;
            }
            if (offsetInCurentChunk + ClassSize.CELL_CHUNK_MAP_ENTRY > chunkSize) {
                ++currentChunkIdx;
                offsetInCurentChunk = 4;
            }
            if (action == MemStoreCompactionStrategy.Action.COMPACT && !alreadyCopied) {
                c = this.maybeCloneWithAllocator(c, false);
            }
            offsetInCurentChunk = this.createCellReference((ByteBufferKeyValue)c, chunks[currentChunkIdx].getData(), offsetInCurentChunk);
            this.updateMetaInfo(c, true, null);
            if (action == MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS) {
                if (prev != null) {
                    if (!CellUtil.matchingRowColumnBytes((Cell)prev, (Cell)c)) {
                        ++numUniqueKeys;
                    }
                } else {
                    ++numUniqueKeys;
                }
            }
            prev = c;
        }
        if (action == MemStoreCompactionStrategy.Action.COMPACT) {
            numUniqueKeys = numOfCells;
        } else if (action != MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS) {
            numUniqueKeys = -1;
        }
        CellChunkMap ccm = new CellChunkMap((Comparator<? super Cell>)this.getComparator(), chunks, 0, numOfCellsAfterCompaction, false);
        this.setCellSet(null, new CellSet(ccm, numUniqueKeys));
    }

    private void reinitializeCellSet(int numOfCells, KeyValueScanner segmentScanner, CellSet oldCellSet, MemStoreCompactionStrategy.Action action) {
        int chunkSize = ChunkCreator.getInstance().getChunkSize();
        int numOfCellsInChunk = CellChunkMap.NUM_OF_CELL_REPS_IN_CHUNK;
        int numberOfChunks = this.calculateNumberOfChunks(numOfCells, numOfCellsInChunk);
        Chunk[] chunks = new Chunk[numberOfChunks];
        for (int i = 0; i < numberOfChunks; ++i) {
            chunks[i] = this.getMemStoreLAB().getNewExternalChunk();
        }
        int currentChunkIdx = 0;
        int offsetInCurentChunk = 4;
        int numUniqueKeys = 0;
        Cell prev = null;
        try {
            Cell curCell;
            while ((curCell = segmentScanner.next()) != null) {
                assert (curCell instanceof ExtendedCell);
                if (((ExtendedCell)curCell).getChunkId() == -1) {
                    curCell = this.copyCellIntoMSLAB(curCell);
                }
                if (offsetInCurentChunk + ClassSize.CELL_CHUNK_MAP_ENTRY > chunkSize) {
                    ++currentChunkIdx;
                    offsetInCurentChunk = 4;
                }
                offsetInCurentChunk = this.createCellReference((ByteBufferKeyValue)curCell, chunks[currentChunkIdx].getData(), offsetInCurentChunk);
                if (action == MemStoreCompactionStrategy.Action.FLATTEN_COUNT_UNIQUE_KEYS) {
                    if (prev != null) {
                        if (!CellUtil.matchingRowColumn((Cell)prev, (Cell)curCell)) {
                            ++numUniqueKeys;
                        }
                    } else {
                        ++numUniqueKeys;
                    }
                }
                prev = curCell;
            }
            if (action != MemStoreCompactionStrategy.Action.FLATTEN_COUNT_UNIQUE_KEYS) {
                numUniqueKeys = -1;
            }
        }
        catch (IOException ie) {
            throw new IllegalStateException(ie);
        }
        finally {
            segmentScanner.close();
        }
        CellChunkMap ccm = new CellChunkMap((Comparator<? super Cell>)this.getComparator(), chunks, 0, numOfCells, false);
        this.setCellSet(oldCellSet, new CellSet(ccm, numUniqueKeys));
    }

    private int createCellReference(ByteBufferKeyValue cell, ByteBuffer idxBuffer, int idxOffset) {
        int offset = idxOffset;
        int dataChunkID = cell.getChunkId();
        offset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)offset, (int)dataChunkID);
        offset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)offset, (int)cell.getOffset());
        offset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)offset, (int)KeyValueUtil.length((Cell)cell));
        offset = ByteBufferUtils.putLong((ByteBuffer)idxBuffer, (int)offset, (long)cell.getSequenceId());
        return offset;
    }

    private int calculateNumberOfChunks(int numOfCells, int numOfCellsInChunk) {
        int numberOfChunks = numOfCells / numOfCellsInChunk;
        if (numOfCells % numOfCellsInChunk != 0) {
            ++numberOfChunks;
        }
        return numberOfChunks;
    }

    private Cell copyCellIntoMSLAB(Cell cell) {
        long oldHeapSize = this.heapSizeChange(cell, true);
        long oldCellSize = CellChunkImmutableSegment.getCellLength(cell);
        cell = this.maybeCloneWithAllocator(cell, true);
        long newHeapSize = this.heapSizeChange(cell, true);
        long newCellSize = CellChunkImmutableSegment.getCellLength(cell);
        long heapOverhead = newHeapSize - oldHeapSize;
        this.incSize(newCellSize - oldCellSize, heapOverhead);
        return cell;
    }
}

