/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MutableSegment
extends Segment {
    public static final long DEEP_OVERHEAD = Segment.DEEP_OVERHEAD + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.SYNC_TIMERANGE_TRACKER;

    protected MutableSegment(CellSet cellSet, CellComparator comparator, MemStoreLAB memStoreLAB) {
        super(cellSet, comparator, memStoreLAB, TimeRangeTracker.create(TimeRangeTracker.Type.SYNC));
        this.incSize(0L, DEEP_OVERHEAD);
    }

    public void add(Cell cell, boolean mslabUsed, MemStoreSizing memStoreSizing) {
        this.internalAdd(cell, mslabUsed, memStoreSizing);
    }

    public void upsert(Cell cell, long readpoint, MemStoreSizing memStoreSizing) {
        this.internalAdd(cell, false, memStoreSizing);
        Cell firstCell = PrivateCellUtil.createFirstOnRowColTS((Cell)cell, (long)Long.MAX_VALUE);
        SortedSet<Cell> ss = this.tailSet(firstCell);
        Iterator it = ss.iterator();
        int versionsVisible = 0;
        while (it.hasNext()) {
            Cell cur = (Cell)it.next();
            if (cell == cur) continue;
            if (!CellUtil.matchingRows((Cell)cell, (Cell)cur) || !CellUtil.matchingQualifier((Cell)cell, (Cell)cur)) break;
            if (cur.getTypeByte() != KeyValue.Type.Put.getCode() || cur.getSequenceId() > readpoint) continue;
            if (versionsVisible >= 1) {
                int cellLen = MutableSegment.getCellLength(cur);
                long heapSize = this.heapSizeChange(cur, true);
                this.incSize(-cellLen, -heapSize);
                if (memStoreSizing != null) {
                    memStoreSizing.decMemStoreSize(cellLen, heapSize);
                }
                it.remove();
                continue;
            }
            ++versionsVisible;
        }
    }

    @VisibleForTesting
    Cell first() {
        return this.getCellSet().first();
    }

    @Override
    protected long indexEntrySize() {
        return ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY;
    }
}

