/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.SegmentScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;

@InterfaceAudience.Private
public abstract class Segment {
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 6 * ClassSize.REFERENCE + 8 + 1));
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)ClassSize.ATOMIC_REFERENCE + (long)ClassSize.CELL_SET + (long)(2 * ClassSize.ATOMIC_LONG);
    private AtomicReference<CellSet> cellSet = new AtomicReference();
    private final CellComparator comparator;
    protected long minSequenceId;
    private MemStoreLAB memStoreLAB;
    protected final AtomicLong dataSize;
    protected final AtomicLong heapSize;
    protected final TimeRangeTracker timeRangeTracker;
    protected volatile boolean tagsPresent;

    protected Segment(CellComparator comparator, TimeRangeTracker trt) {
        this.comparator = comparator;
        this.dataSize = new AtomicLong(0L);
        this.heapSize = new AtomicLong(0L);
        this.timeRangeTracker = trt;
    }

    protected Segment(CellSet cellSet, CellComparator comparator, MemStoreLAB memStoreLAB, TimeRangeTracker trt) {
        this.cellSet.set(cellSet);
        this.comparator = comparator;
        this.minSequenceId = Long.MAX_VALUE;
        this.memStoreLAB = memStoreLAB;
        this.dataSize = new AtomicLong(0L);
        this.heapSize = new AtomicLong(0L);
        this.tagsPresent = false;
        this.timeRangeTracker = trt;
    }

    protected Segment(Segment segment) {
        this.cellSet.set(segment.getCellSet());
        this.comparator = segment.getComparator();
        this.minSequenceId = segment.getMinSequenceId();
        this.memStoreLAB = segment.getMemStoreLAB();
        this.dataSize = new AtomicLong(segment.keySize());
        this.heapSize = new AtomicLong(segment.heapSize.get());
        this.tagsPresent = segment.isTagsPresent();
        this.timeRangeTracker = segment.getTimeRangeTracker();
    }

    protected KeyValueScanner getScanner(long readPoint) {
        return new SegmentScanner(this, readPoint);
    }

    public KeyValueScanner getScanner(long readPoint, long order) {
        return new SegmentScanner(this, readPoint, order);
    }

    public List<KeyValueScanner> getScanners(long readPoint, long order) {
        return Collections.singletonList(new SegmentScanner(this, readPoint, order));
    }

    public boolean isEmpty() {
        return this.getCellSet().isEmpty();
    }

    public int getCellsCount() {
        return this.getCellSet().size();
    }

    public Cell getFirstAfter(Cell cell) {
        SortedSet<Cell> snTailSet = this.tailSet(cell);
        if (!snTailSet.isEmpty()) {
            return snTailSet.first();
        }
        return null;
    }

    public void close() {
        if (this.memStoreLAB != null) {
            this.memStoreLAB.close();
        }
    }

    public Cell maybeCloneWithAllocator(Cell cell, boolean forceCloneOfBigCell) {
        if (this.memStoreLAB == null) {
            return cell;
        }
        Cell cellFromMslab = null;
        cellFromMslab = forceCloneOfBigCell ? this.memStoreLAB.forceCopyOfBigCellInto(cell) : this.memStoreLAB.copyCellInto(cell);
        return cellFromMslab != null ? cellFromMslab : cell;
    }

    @VisibleForTesting
    static int getCellLength(Cell cell) {
        return KeyValueUtil.length((Cell)cell);
    }

    public boolean shouldSeek(TimeRange tr, long oldestUnexpiredTS) {
        return !this.isEmpty() && (tr.isAllTime() || this.timeRangeTracker.includesTimeRange(tr)) && this.timeRangeTracker.getMax() >= oldestUnexpiredTS;
    }

    public boolean isTagsPresent() {
        return this.tagsPresent;
    }

    public void incScannerCount() {
        if (this.memStoreLAB != null) {
            this.memStoreLAB.incScannerCount();
        }
    }

    public void decScannerCount() {
        if (this.memStoreLAB != null) {
            this.memStoreLAB.decScannerCount();
        }
    }

    protected Segment setCellSet(CellSet cellSetOld, CellSet cellSetNew) {
        this.cellSet.compareAndSet(cellSetOld, cellSetNew);
        return this;
    }

    public long keySize() {
        return this.dataSize.get();
    }

    public long heapSize() {
        return this.heapSize.get();
    }

    protected void incSize(long delta, long heapOverhead) {
        this.dataSize.addAndGet(delta);
        this.heapSize.addAndGet(heapOverhead);
    }

    public long getMinSequenceId() {
        return this.minSequenceId;
    }

    public TimeRangeTracker getTimeRangeTracker() {
        return this.timeRangeTracker;
    }

    public Cell last() {
        return this.getCellSet().last();
    }

    public Iterator<Cell> iterator() {
        return this.getCellSet().iterator();
    }

    public SortedSet<Cell> headSet(Cell firstKeyOnRow) {
        return this.getCellSet().headSet(firstKeyOnRow);
    }

    public int compare(Cell left, Cell right) {
        return this.getComparator().compare(left, right);
    }

    public int compareRows(Cell left, Cell right) {
        return this.getComparator().compareRows(left, right);
    }

    protected CellSet getCellSet() {
        return this.cellSet.get();
    }

    protected CellComparator getComparator() {
        return this.comparator;
    }

    protected void internalAdd(Cell cell, boolean mslabUsed, MemStoreSizing memstoreSizing) {
        boolean succ = this.getCellSet().add(cell);
        this.updateMetaInfo(cell, succ, mslabUsed, memstoreSizing);
    }

    protected void updateMetaInfo(Cell cellToAdd, boolean succ, boolean mslabUsed, MemStoreSizing memstoreSizing) {
        long cellSize = 0L;
        if (succ || mslabUsed) {
            cellSize = Segment.getCellLength(cellToAdd);
        }
        long heapSize = this.heapSizeChange(cellToAdd, succ);
        this.incSize(cellSize, heapSize);
        if (memstoreSizing != null) {
            memstoreSizing.incMemStoreSize(cellSize, heapSize);
        }
        this.getTimeRangeTracker().includeTimestamp(cellToAdd);
        this.minSequenceId = Math.min(this.minSequenceId, cellToAdd.getSequenceId());
        if (cellToAdd.getTagsLength() > 0) {
            this.tagsPresent = true;
        }
    }

    protected void updateMetaInfo(Cell cellToAdd, boolean succ, MemStoreSizing memstoreSizing) {
        this.updateMetaInfo(cellToAdd, succ, this.getMemStoreLAB() != null, memstoreSizing);
    }

    protected long heapSizeChange(Cell cell, boolean succ) {
        if (succ) {
            return ClassSize.align((long)(this.indexEntrySize() + PrivateCellUtil.estimatedHeapSizeOf((Cell)cell)));
        }
        return 0L;
    }

    protected abstract long indexEntrySize();

    protected SortedSet<Cell> tailSet(Cell firstCell) {
        return this.getCellSet().tailSet(firstCell);
    }

    @VisibleForTesting
    MemStoreLAB getMemStoreLAB() {
        return this.memStoreLAB;
    }

    void dump(Logger log) {
        for (Cell cell : this.getCellSet()) {
            log.debug(Objects.toString(cell));
        }
    }

    public String toString() {
        String res = "Type=" + this.getClass().getSimpleName() + ", ";
        res = res + "empty=" + (this.isEmpty() ? "yes" : "no") + ", ";
        res = res + "cellCount=" + this.getCellsCount() + ", ";
        res = res + "cellSize=" + this.keySize() + ", ";
        res = res + "totalHeapSize=" + this.heapSize() + ", ";
        res = res + "min timestamp=" + this.timeRangeTracker.getMin() + ", ";
        res = res + "max timestamp=" + this.timeRangeTracker.getMax();
        return res;
    }
}

