/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterDDLOperationHelper;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ReopenTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ModifyTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.ModifyTableState> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyTableProcedure.class);
    private TableDescriptor unmodifiedTableDescriptor = null;
    private TableDescriptor modifiedTableDescriptor;
    private boolean deleteColumnFamilyInModify;

    public ModifyTableProcedure() {
        this.initilize();
    }

    public ModifyTableProcedure(MasterProcedureEnv env, TableDescriptor htd) throws HBaseIOException {
        this(env, htd, null);
    }

    public ModifyTableProcedure(MasterProcedureEnv env, TableDescriptor htd, ProcedurePrepareLatch latch) throws HBaseIOException {
        super(env, latch);
        this.initilize();
        this.modifiedTableDescriptor = htd;
        this.preflightChecks(env, null);
    }

    private void initilize() {
        this.unmodifiedTableDescriptor = null;
        this.deleteColumnFamilyInModify = false;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case MODIFY_TABLE_PREPARE: {
                    this.prepareModify(env);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PRE_OPERATION);
                    break;
                }
                case MODIFY_TABLE_PRE_OPERATION: {
                    this.preModify(env, state);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case MODIFY_TABLE_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_REMOVE_REPLICA_COLUMN);
                    break;
                }
                case MODIFY_TABLE_REMOVE_REPLICA_COLUMN: {
                    this.updateReplicaColumnsIfNeeded(env, this.unmodifiedTableDescriptor, this.modifiedTableDescriptor);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_POST_OPERATION);
                    break;
                }
                case MODIFY_TABLE_POST_OPERATION: {
                    this.postModify(env, state);
                    this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_REOPEN_ALL_REGIONS);
                    break;
                }
                case MODIFY_TABLE_REOPEN_ALL_REGIONS: {
                    if (env.getAssignmentManager().isTableEnabled(this.getTableName())) {
                        this.addChildProcedure((Procedure[])new ReopenTableRegionsProcedure[]{new ReopenTableRegionsProcedure(this.getTableName())});
                    }
                    if (this.deleteColumnFamilyInModify) {
                        this.setNextState(MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_DELETE_FS_LAYOUT);
                        break;
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case MODIFY_TABLE_DELETE_FS_LAYOUT: {
                    this.deleteFromFs(env, this.unmodifiedTableDescriptor, this.modifiedTableDescriptor);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-modify-table", e);
            }
            LOG.warn("Retriable error trying to modify table={} (in state={})", new Object[]{this.getTableName(), state, e});
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException {
        if (state == MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PREPARE || state == MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.ModifyTableState state) {
        switch (state) {
            case MODIFY_TABLE_PREPARE: 
            case MODIFY_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected void completionCleanup(MasterProcedureEnv env) {
        this.releaseSyncLatch();
    }

    protected MasterProcedureProtos.ModifyTableState getState(int stateId) {
        return MasterProcedureProtos.ModifyTableState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.ModifyTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ModifyTableState getInitialState() {
        return MasterProcedureProtos.ModifyTableState.MODIFY_TABLE_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ModifyTableStateData.Builder modifyTableMsg = MasterProcedureProtos.ModifyTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setModifiedTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.modifiedTableDescriptor)).setDeleteColumnFamilyInModify(this.deleteColumnFamilyInModify);
        if (this.unmodifiedTableDescriptor != null) {
            modifyTableMsg.setUnmodifiedTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.unmodifiedTableDescriptor));
        }
        serializer.serialize((Message)modifyTableMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ModifyTableStateData modifyTableMsg = (MasterProcedureProtos.ModifyTableStateData)serializer.deserialize(MasterProcedureProtos.ModifyTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(modifyTableMsg.getUserInfo()));
        this.modifiedTableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)modifyTableMsg.getModifiedTableSchema());
        this.deleteColumnFamilyInModify = modifyTableMsg.getDeleteColumnFamilyInModify();
        if (modifyTableMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedTableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)modifyTableMsg.getUnmodifiedTableSchema());
        }
    }

    @Override
    public TableName getTableName() {
        return this.modifiedTableDescriptor.getTableName();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareModify(MasterProcedureEnv env) throws IOException {
        if (!MetaTableAccessor.tableExists((Connection)env.getMasterServices().getConnection(), (TableName)this.getTableName())) {
            throw new TableNotFoundException(this.getTableName());
        }
        if (this.modifiedTableDescriptor.getColumnFamilyCount() == 0) {
            throw new DoNotRetryIOException("Table " + this.getTableName().toString() + " should have at least one column family.");
        }
        this.unmodifiedTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        if (env.getMasterServices().getTableStateManager().isTableState(this.getTableName(), TableState.State.ENABLED) && this.modifiedTableDescriptor.getRegionReplication() != this.unmodifiedTableDescriptor.getRegionReplication()) {
            throw new TableNotDisabledException("REGION_REPLICATION change is not supported for enabled tables");
        }
        Set oldFamilies = this.unmodifiedTableDescriptor.getColumnFamilyNames();
        Set newFamilies = this.modifiedTableDescriptor.getColumnFamilyNames();
        for (byte[] familyName : oldFamilies) {
            if (newFamilies.contains(familyName)) continue;
            this.deleteColumnFamilyInModify = true;
            break;
        }
    }

    private void preModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().add(this.modifiedTableDescriptor);
    }

    private void deleteFromFs(MasterProcedureEnv env, TableDescriptor oldTableDescriptor, TableDescriptor newTableDescriptor) throws IOException {
        Set oldFamilies = oldTableDescriptor.getColumnFamilyNames();
        Set newFamilies = newTableDescriptor.getColumnFamilyNames();
        for (byte[] familyName : oldFamilies) {
            if (newFamilies.contains(familyName)) continue;
            MasterDDLOperationHelper.deleteColumnFamilyFromFileSystem(env, this.getTableName(), this.getRegionInfoList(env), familyName, oldTableDescriptor.getColumnFamily(familyName).isMobEnabled());
        }
    }

    private void updateReplicaColumnsIfNeeded(MasterProcedureEnv env, TableDescriptor oldTableDescriptor, TableDescriptor newTableDescriptor) throws IOException {
        int oldReplicaCount = oldTableDescriptor.getRegionReplication();
        int newReplicaCount = newTableDescriptor.getRegionReplication();
        if (newReplicaCount < oldReplicaCount) {
            HashSet<byte[]> tableRows = new HashSet<byte[]>();
            Connection connection = env.getMasterServices().getConnection();
            Scan scan = MetaTableAccessor.getScanForTableName((Connection)connection, (TableName)this.getTableName());
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            try (Table metaTable = connection.getTable(TableName.META_TABLE_NAME);){
                ResultScanner resScanner = metaTable.getScanner(scan);
                for (Result result : resScanner) {
                    tableRows.add(result.getRow());
                }
                MetaTableAccessor.removeRegionReplicasFromMeta(tableRows, (int)newReplicaCount, (int)(oldReplicaCount - newReplicaCount), (Connection)connection);
            }
        }
        if (newReplicaCount > oldReplicaCount) {
            Connection connection = env.getMasterServices().getConnection();
            List existingTableRegions = MetaTableAccessor.getTableRegions((Connection)connection, (TableName)this.getTableName());
            ModifyTableProcedure.addRegionsToMeta(env, newTableDescriptor, existingTableRegions);
            if (oldReplicaCount <= 1) {
                ServerRegionReplicaUtil.setupRegionReplicaReplication(env.getMasterConfiguration());
            }
        }
    }

    private static void addRegionsToMeta(MasterProcedureEnv env, TableDescriptor tableDescriptor, List<RegionInfo> regionInfos) throws IOException {
        MetaTableAccessor.addRegionsToMeta((Connection)env.getMasterServices().getConnection(), regionInfos, (int)tableDescriptor.getRegionReplication());
    }

    private void postModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void runCoprocessorAction(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableState state) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            switch (state) {
                case MODIFY_TABLE_PRE_OPERATION: {
                    cpHost.preModifyTableAction(this.getTableName(), this.unmodifiedTableDescriptor, this.modifiedTableDescriptor, this.getUser());
                    break;
                }
                case MODIFY_TABLE_POST_OPERATION: {
                    cpHost.postCompletedModifyTableAction(this.getTableName(), this.unmodifiedTableDescriptor, this.modifiedTableDescriptor, this.getUser());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
    }

    private List<RegionInfo> getRegionInfoList(MasterProcedureEnv env) throws IOException {
        return env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName());
    }
}

