/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@VisibleForTesting
public class LogRoller
extends HasThread
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LogRoller.class);
    private final ConcurrentMap<WAL, Boolean> walNeedsRoll = new ConcurrentHashMap<WAL, Boolean>();
    private final Server server;
    protected final RegionServerServices services;
    private volatile long lastRollTime = System.currentTimeMillis();
    private final long rollPeriod;
    private final int threadWakeFrequency;
    private long checkLowReplicationInterval;
    private volatile boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWAL(final WAL wal) {
        if (this.walNeedsRoll.containsKey(wal)) {
            return;
        }
        LogRoller logRoller = this;
        synchronized (logRoller) {
            if (this.walNeedsRoll.putIfAbsent(wal, Boolean.FALSE) == null) {
                wal.registerWALActionsListener(new WALActionsListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void logRollRequested(boolean lowReplicas) {
                        LogRoller logRoller = LogRoller.this;
                        synchronized (logRoller) {
                            LogRoller.this.walNeedsRoll.put(wal, Boolean.TRUE);
                            LogRoller.this.notifyAll();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRollAll() {
        LogRoller logRoller = this;
        synchronized (logRoller) {
            ArrayList wals = new ArrayList(this.walNeedsRoll.keySet());
            for (WAL wal : wals) {
                this.walNeedsRoll.put(wal, Boolean.TRUE);
            }
            this.notifyAll();
        }
    }

    public LogRoller(Server server, RegionServerServices services) {
        super("LogRoller");
        this.server = server;
        this.services = services;
        this.rollPeriod = this.server.getConfiguration().getLong("hbase.regionserver.logroll.period", 3600000L);
        this.threadWakeFrequency = this.server.getConfiguration().getInt("hbase.server.thread.wakefrequency", 10000);
        this.checkLowReplicationInterval = this.server.getConfiguration().getLong("hbase.regionserver.hlog.check.lowreplication.interval", 30000L);
    }

    private void checkLowReplication(long now) {
        try {
            for (Map.Entry entry : this.walNeedsRoll.entrySet()) {
                WAL wal = (WAL)entry.getKey();
                boolean needRollAlready = (Boolean)entry.getValue();
                if (needRollAlready || !(wal instanceof AbstractFSWAL)) continue;
                ((AbstractFSWAL)wal).checkLogLowReplication(this.checkLowReplicationInterval);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed checking low replication", e);
        }
    }

    private void abort(String reason, Throwable cause) {
        for (WAL wal : this.walNeedsRoll.keySet()) {
            try {
                wal.shutdown();
            }
            catch (IOException e) {
                LOG.warn("Failed to shutdown wal", (Throwable)e);
            }
        }
        this.server.abort(reason, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            boolean periodic = false;
            long now = System.currentTimeMillis();
            this.checkLowReplication(now);
            boolean bl = periodic = now - this.lastRollTime > this.rollPeriod;
            if (periodic) {
                LOG.debug("Wal roll period {} ms elapsed", (Object)this.rollPeriod);
            } else {
                LogRoller logRoller = this;
                synchronized (logRoller) {
                    if (!this.walNeedsRoll.values().stream().anyMatch(Boolean::booleanValue)) {
                        try {
                            this.wait(this.threadWakeFrequency);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    LOG.debug("WAL roll requested");
                }
            }
            try {
                this.lastRollTime = System.currentTimeMillis();
                for (Map.Entry entry : this.walNeedsRoll.entrySet()) {
                    WAL wal = (WAL)entry.getKey();
                    this.walNeedsRoll.put(wal, Boolean.FALSE);
                    byte[][] regionsToFlush = wal.rollWriter(periodic || (Boolean)entry.getValue() != false);
                    if (regionsToFlush == null) continue;
                    for (byte[] r : regionsToFlush) {
                        this.scheduleFlush(Bytes.toString((byte[])r));
                    }
                }
            }
            catch (ConnectException | FailedLogCloseException e) {
                this.abort("Failed log close in log roller", e);
            }
            catch (IOException ex) {
                this.abort("IOE in log roller", ex instanceof RemoteException ? ((RemoteException)((Object)ex)).unwrapRemoteException() : ex);
            }
            catch (Exception ex) {
                LOG.error("Log rolling failed", (Throwable)ex);
                this.abort("Log rolling failed", ex);
            }
        }
        LOG.info("LogRoller exiting.");
    }

    private void scheduleFlush(String encodedRegionName) {
        HRegion r = (HRegion)this.services.getRegion(encodedRegionName);
        if (r == null) {
            LOG.warn("Failed to schedule flush of {}, because it is not online on us", (Object)encodedRegionName);
            return;
        }
        FlushRequester requester = this.services.getFlushRequester();
        if (requester == null) {
            LOG.warn("Failed to schedule flush of {}, region={}, because FlushRequester is null", (Object)encodedRegionName, (Object)r);
            return;
        }
        requester.requestFlush(r, true, FlushLifeCycleTracker.DUMMY);
    }

    @VisibleForTesting
    public boolean walRollFinished() {
        return this.walNeedsRoll.values().stream().allMatch(needRoll -> needRoll == false);
    }

    @Override
    public void close() {
        this.running = false;
        this.interrupt();
    }
}

