/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Replication", "Coprocesssor"})
public class WALEdit
implements HeapSize {
    private static final Logger LOG = LoggerFactory.getLogger(WALEdit.class);
    public static final byte[] METAFAMILY = Bytes.toBytes((String)"METAFAMILY");
    @VisibleForTesting
    public static final byte[] METAROW = Bytes.toBytes((String)"METAROW");
    @VisibleForTesting
    public static final byte[] COMPACTION = Bytes.toBytes((String)"HBASE::COMPACTION");
    @VisibleForTesting
    public static final byte[] FLUSH = Bytes.toBytes((String)"HBASE::FLUSH");
    @VisibleForTesting
    public static final byte[] REGION_EVENT = Bytes.toBytes((String)"HBASE::REGION_EVENT");
    @VisibleForTesting
    public static final byte[] BULK_LOAD = Bytes.toBytes((String)"HBASE::BULK_LOAD");
    private final boolean replay;
    private ArrayList<Cell> cells = null;
    private Set<byte[]> families = null;

    public WALEdit() {
        this(false);
    }

    @Deprecated
    public WALEdit(boolean isReplay) {
        this(1, isReplay);
    }

    @Deprecated
    public WALEdit(int cellCount) {
        this(cellCount, false);
    }

    public WALEdit(int cellCount, boolean isReplay) {
        this.replay = isReplay;
        this.cells = new ArrayList(cellCount);
    }

    private Set<byte[]> getOrCreateFamilies() {
        if (this.families == null) {
            this.families = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        return this.families;
    }

    public Set<byte[]> getFamilies() {
        return this.families;
    }

    public static boolean isMetaEditFamily(byte[] f) {
        return Bytes.equals((byte[])METAFAMILY, (byte[])f);
    }

    public static boolean isMetaEditFamily(Cell cell) {
        return CellUtil.matchingFamily((Cell)cell, (byte[])METAFAMILY);
    }

    public boolean isMetaEdit() {
        for (Cell cell : this.cells) {
            if (WALEdit.isMetaEditFamily(cell)) continue;
            return false;
        }
        return true;
    }

    public boolean isReplay() {
        return this.replay;
    }

    @InterfaceAudience.Private
    public WALEdit add(Cell cell, byte[] family) {
        this.getOrCreateFamilies().add(family);
        return this.addCell(cell);
    }

    @InterfaceAudience.Private
    public WALEdit add(Cell cell) {
        return this.add(cell, CellUtil.cloneFamily((Cell)cell));
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public int size() {
        return this.cells.size();
    }

    public ArrayList<Cell> getCells() {
        return this.cells;
    }

    @InterfaceAudience.Private
    public void setCells(ArrayList<Cell> cells) {
        this.cells = cells;
        this.families = null;
    }

    public int readFromCells(Codec.Decoder cellDecoder, int expectedCount) throws IOException {
        this.cells.clear();
        this.cells.ensureCapacity(expectedCount);
        while (this.cells.size() < expectedCount && cellDecoder.advance()) {
            this.cells.add(cellDecoder.current());
        }
        return this.cells.size();
    }

    public long heapSize() {
        long ret = ClassSize.ARRAYLIST;
        for (Cell cell : this.cells) {
            ret += PrivateCellUtil.estimatedSizeOfCell((Cell)cell);
        }
        return ret;
    }

    public long estimatedSerializedSizeOf() {
        long ret = 0L;
        for (Cell cell : this.cells) {
            ret += (long)PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[#edits: " + this.cells.size() + " = <");
        for (Cell cell : this.cells) {
            sb.append(cell);
            sb.append("; ");
        }
        sb.append(">]");
        return sb.toString();
    }

    public static WALEdit createFlushWALEdit(RegionInfo hri, WALProtos.FlushDescriptor f) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, FLUSH, EnvironmentEdgeManager.currentTime(), f.toByteArray());
        return new WALEdit().add((Cell)kv, METAFAMILY);
    }

    public static WALProtos.FlushDescriptor getFlushDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn((Cell)cell, (byte[])METAFAMILY, (byte[])FLUSH)) {
            return WALProtos.FlushDescriptor.parseFrom((byte[])CellUtil.cloneValue((Cell)cell));
        }
        return null;
    }

    public static WALEdit createRegionEventWALEdit(RegionInfo hri, WALProtos.RegionEventDescriptor regionEventDesc) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, REGION_EVENT, EnvironmentEdgeManager.currentTime(), regionEventDesc.toByteArray());
        return new WALEdit().add((Cell)kv, METAFAMILY);
    }

    public static WALProtos.RegionEventDescriptor getRegionEventDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn((Cell)cell, (byte[])METAFAMILY, (byte[])REGION_EVENT)) {
            return WALProtos.RegionEventDescriptor.parseFrom((byte[])CellUtil.cloneValue((Cell)cell));
        }
        return null;
    }

    public static WALEdit createCompaction(RegionInfo hri, WALProtos.CompactionDescriptor c) {
        byte[] pbbytes = c.toByteArray();
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, COMPACTION, EnvironmentEdgeManager.currentTime(), pbbytes);
        return new WALEdit().add((Cell)kv, METAFAMILY);
    }

    public static byte[] getRowForRegion(RegionInfo hri) {
        byte[] startKey = hri.getStartKey();
        if (startKey.length == 0) {
            return new byte[]{0};
        }
        return startKey;
    }

    public static WALProtos.CompactionDescriptor getCompaction(Cell kv) throws IOException {
        if (WALEdit.isCompactionMarker(kv)) {
            return WALProtos.CompactionDescriptor.parseFrom((byte[])CellUtil.cloneValue((Cell)kv));
        }
        return null;
    }

    public static boolean isCompactionMarker(Cell cell) {
        return CellUtil.matchingColumn((Cell)cell, (byte[])METAFAMILY, (byte[])COMPACTION);
    }

    public static WALEdit createBulkLoadEvent(RegionInfo hri, WALProtos.BulkLoadDescriptor bulkLoadDescriptor) {
        KeyValue kv = new KeyValue(WALEdit.getRowForRegion(hri), METAFAMILY, BULK_LOAD, EnvironmentEdgeManager.currentTime(), bulkLoadDescriptor.toByteArray());
        return new WALEdit().add((Cell)kv, METAFAMILY);
    }

    public static WALProtos.BulkLoadDescriptor getBulkLoadDescriptor(Cell cell) throws IOException {
        if (CellUtil.matchingColumn((Cell)cell, (byte[])METAFAMILY, (byte[])BULK_LOAD)) {
            return WALProtos.BulkLoadDescriptor.parseFrom((byte[])CellUtil.cloneValue((Cell)cell));
        }
        return null;
    }

    public void add(Map<byte[], List<Cell>> familyMap) {
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            int listSize = e.getValue().size();
            for (int i = 0; i < listSize; ++i) {
                this.addCell(e.getValue().get(i));
            }
            this.addFamily(e.getKey());
        }
    }

    private void addFamily(byte[] family) {
        this.getOrCreateFamilies().add(family);
    }

    private WALEdit addCell(Cell cell) {
        this.cells.add(cell);
        return this;
    }
}

