/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AsyncMetaTableAccessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableAdminApi
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableAdminApi.class);

    @Test
    public void testCreateTable() throws Exception {
        List tables = (List)this.admin.listTableDescriptors().get();
        int numTables = tables.size();
        this.createTableWithDefaultConf(this.tableName);
        tables = (List)this.admin.listTableDescriptors().get();
        Assert.assertEquals((long)(numTables + 1), (long)tables.size());
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(this.tableName, new TableState.State[]{TableState.State.ENABLED}));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)TestAsyncTableAdminApi.getStateFromMeta(this.tableName));
    }

    static TableState.State getStateFromMeta(TableName table) throws Exception {
        Optional state = (Optional)AsyncMetaTableAccessor.getTableState((AsyncTable)ASYNC_CONN.getTable(TableName.META_TABLE_NAME), (TableName)table).get();
        Assert.assertTrue((boolean)state.isPresent());
        return ((TableState)state.get()).getState();
    }

    @Test
    public void testCreateTableNumberOfRegions() throws Exception {
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        this.createTableWithDefaultConf(this.tableName);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        Assert.assertEquals((String)"Table should have only 1 region", (long)1L, (long)regionLocations.size());
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"));
        this.createTableWithDefaultConf(tableName2, new byte[][]{{42}});
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)tableName2).get();
        Assert.assertEquals((String)"Table should have only 2 region", (long)2L, (long)regionLocations.size());
        TableName tableName3 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_3"));
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName3);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"z"), 3).join();
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)tableName3).get();
        Assert.assertEquals((String)"Table should have only 3 region", (long)3L, (long)regionLocations.size());
        TableName tableName4 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_4"));
        builder = TableDescriptorBuilder.newBuilder((TableName)tableName4);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        try {
            this.admin.createTable(builder.build(), "a".getBytes(), "z".getBytes(), 2).join();
            Assert.fail((String)"Should not be able to create a table with only 2 regions using this API.");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        TableName tableName5 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_5"));
        builder = TableDescriptorBuilder.newBuilder((TableName)tableName5);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build(), new byte[]{1}, new byte[]{127}, 16).join();
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)tableName5).get();
        Assert.assertEquals((String)"Table should have 16 region", (long)16L, (long)regionLocations.size());
    }

    @Test
    public void testCreateTableWithRegions() throws Exception {
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)TEST_UTIL.getConfiguration());
        this.createTableWithDefaultConf(this.tableName, splitKeys);
        boolean tableAvailable = (Boolean)this.admin.isTableAvailable(this.tableName, (byte[][])splitKeys).get();
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)tableAvailable);
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        List regions = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        Iterator hris = regions.iterator();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.iterator();
        RegionInfo hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[0]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[1]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[2]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[2]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[3]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[4]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[5]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[5]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[6]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[6]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[7]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[7]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[8]));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[8]));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        if (tablesOnMaster) {
            this.verifyRoundRobinDistribution(regions, expectedRegions);
        }
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"));
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName2);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build(), startKey, endKey, expectedRegions).join();
        regions = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)tableName2).get();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.iterator();
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        hri = ((HRegionLocation)hris.next()).getRegion();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        if (tablesOnMaster) {
            this.verifyRoundRobinDistribution(regions, expectedRegions);
        }
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        TableName tableName3 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_3"));
        builder = TableDescriptorBuilder.newBuilder((TableName)tableName3);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build(), startKey, endKey, expectedRegions).join();
        regions = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)tableName3).get();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        if (tablesOnMaster) {
            this.verifyRoundRobinDistribution(regions, expectedRegions);
        }
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        TableName tableName4 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_4"));
        try {
            this.createTableWithDefaultConf(tableName4, splitKeys);
            Assert.fail((String)"Should not be able to create this table because of duplicate split keys");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    private void verifyRoundRobinDistribution(List<HRegionLocation> regions, int expectedRegions) {
        int numRS = TEST_UTIL.getMiniHBaseCluster().getNumLiveRegionServers();
        HashMap server2Regions = new HashMap();
        regions.stream().forEach(loc -> {
            ServerName server = loc.getServerName();
            server2Regions.computeIfAbsent(server, s -> new ArrayList()).add(loc.getRegion());
        });
        if (numRS >= 2) {
            --numRS;
        }
        float average = (float)expectedRegions / (float)numRS;
        int min = (int)Math.floor(average);
        int max = (int)Math.ceil(average);
        server2Regions.values().forEach(regionList -> Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0));
    }

    @Test
    public void testCreateTableWithOnlyEmptyStartRow() throws Exception {
        byte[][] splitKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY};
        try {
            this.createTableWithDefaultConf(this.tableName, splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testCreateTableWithEmptyRowInTheSplitKeys() throws Exception {
        byte[][] splitKeys = new byte[][]{"region1".getBytes(), HConstants.EMPTY_BYTE_ARRAY, "region2".getBytes()};
        try {
            this.createTableWithDefaultConf(this.tableName, splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testDeleteTable() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        Assert.assertTrue((boolean)((Boolean)this.admin.tableExists(this.tableName).get()));
        TEST_UTIL.getAdmin().disableTable(this.tableName);
        this.admin.deleteTable(this.tableName).join();
        Assert.assertFalse((boolean)((Boolean)this.admin.tableExists(this.tableName).get()));
    }

    @Test
    public void testTruncateTable() throws Exception {
        this.testTruncateTable(this.tableName, false);
    }

    @Test
    public void testTruncateTablePreservingSplits() throws Exception {
        this.testTruncateTable(this.tableName, true);
    }

    private void testTruncateTable(TableName tableName, boolean preserveSplits) throws Exception {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        this.createTableWithDefaultConf(tableName, splitKeys);
        AsyncTable table = ASYNC_CONN.getTable(tableName);
        int expectedRows = 10;
        for (int i = 0; i < expectedRows; ++i) {
            byte[] data = Bytes.toBytes((String)String.valueOf(i));
            Put put = new Put(data);
            put.addColumn(FAMILY, null, data);
            table.put(put).join();
        }
        Assert.assertEquals((long)10L, (long)((List)table.scanAll(new Scan()).get()).size());
        Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        this.admin.disableTable(tableName).join();
        this.admin.truncateTable(tableName, preserveSplits).join();
        Assert.assertEquals((long)0L, (long)((List)table.scanAll(new Scan()).get()).size());
        if (preserveSplits) {
            Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        }
    }
}

