/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestHbck {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHbck.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHbck.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter
    public boolean async;
    private static final TableName TABLE_NAME = TableName.valueOf((String)TestHbck.class.getSimpleName());
    private static ProcedureExecutor<MasterProcedureEnv> procExec;
    private static AsyncConnection ASYNC_CONN;

    @Parameterized.Parameters(name="{index}: async={0}")
    public static List<Object[]> params() {
        return Arrays.asList({false}, {true});
    }

    private Hbck getHbck() throws Exception {
        if (this.async) {
            return (Hbck)ASYNC_CONN.getHbck().get();
        }
        return TEST_UTIL.getHbck();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.createMultiRegionTable(TABLE_NAME, Bytes.toBytes((String)"family1"), 5);
        procExec = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)ASYNC_CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        TEST_UTIL.ensureSomeRegionServersAvailable(3);
    }

    @Test
    public void testBypassProcedure() throws Exception {
        SuspendProcedure proc = new SuspendProcedure();
        long procId = procExec.submitProcedure((Procedure)proc);
        Thread.sleep(500L);
        List<Long> pids = Arrays.asList(procId);
        List results = this.getHbck().bypassProcedure(pids, 30000L, false, false);
        Assert.assertTrue((String)"Failed to by pass procedure!", (boolean)((Boolean)results.get(0)));
        TEST_UTIL.waitFor(5000L, () -> proc.isSuccess() && proc.isBypass());
        LOG.info("{} finished", (Object)proc);
    }

    @Test
    public void testSetTableStateInMeta() throws Exception {
        Hbck hbck = this.getHbck();
        hbck.setTableStateInMeta(new TableState(TABLE_NAME, TableState.State.DISABLED));
        TableState prevState = hbck.setTableStateInMeta(new TableState(TABLE_NAME, TableState.State.ENABLED));
        Assert.assertTrue((String)("Incorrect previous state! expeced=DISABLED, found=" + prevState.getState()), (boolean)prevState.isDisabled());
    }

    @Test
    public void testAssigns() throws Exception {
        Hbck hbck = this.getHbck();
        try (Admin admin = TEST_UTIL.getConnection().getAdmin();){
            RegionState rs;
            List regions = admin.getRegions(TABLE_NAME);
            for (RegionInfo ri : regions) {
                RegionState rs2 = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(ri.getEncodedName());
                LOG.info("RS: {}", (Object)rs2.toString());
            }
            List pids = hbck.unassigns(regions.stream().map(r -> r.getEncodedName()).collect(Collectors.toList()));
            this.waitOnPids(pids);
            pids = hbck.unassigns(regions.stream().map(r -> r.getEncodedName()).collect(Collectors.toList()));
            this.waitOnPids(pids);
            Iterator iterator = pids.iterator();
            while (iterator.hasNext()) {
                long pid = (Long)iterator.next();
                Assert.assertEquals((long)-1L, (long)pid);
            }
            pids = hbck.unassigns(regions.stream().map(r -> r.getEncodedName()).collect(Collectors.toList()), true);
            this.waitOnPids(pids);
            iterator = pids.iterator();
            while (iterator.hasNext()) {
                long pid = (Long)iterator.next();
                Assert.assertNotEquals((long)-1L, (long)pid);
            }
            hbck.bypassProcedure(pids, 10000L, true, true);
            for (RegionInfo ri : regions) {
                rs = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(ri.getEncodedName());
                LOG.info("RS: {}", (Object)rs.toString());
                Assert.assertTrue((String)rs.toString(), (boolean)rs.isClosed());
            }
            pids = hbck.assigns(regions.stream().map(r -> r.getEncodedName()).collect(Collectors.toList()));
            this.waitOnPids(pids);
            pids = hbck.assigns(regions.stream().map(r -> r.getEncodedName()).collect(Collectors.toList()));
            iterator = pids.iterator();
            while (iterator.hasNext()) {
                long pid = (Long)iterator.next();
                Assert.assertEquals((long)-1L, (long)pid);
            }
            for (RegionInfo ri : regions) {
                rs = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionState(ri.getEncodedName());
                LOG.info("RS: {}", (Object)rs.toString());
                Assert.assertTrue((String)rs.toString(), (boolean)rs.isOpened());
            }
            pids = hbck.assigns(Arrays.stream(new String[]{"a", "some rubbish name"}).collect(Collectors.toList()));
            iterator = pids.iterator();
            while (iterator.hasNext()) {
                long pid = (Long)iterator.next();
                Assert.assertEquals((long)-1L, (long)pid);
            }
        }
    }

    @Test
    public void testScheduleSCP() throws Exception {
        HRegionServer testRs = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        TEST_UTIL.loadTable(TEST_UTIL.getConnection().getTable(TABLE_NAME), Bytes.toBytes((String)"family1"), true);
        ServerName serverName = testRs.getServerName();
        Hbck hbck = this.getHbck();
        List pids = hbck.scheduleServerCrashProcedure(Arrays.asList(ProtobufUtil.toServerName((ServerName)serverName)));
        Assert.assertTrue(((Long)pids.get(0) > 0L ? 1 : 0) != 0);
        LOG.info("pid is {}", pids.get(0));
        List newPids = hbck.scheduleServerCrashProcedure(Arrays.asList(ProtobufUtil.toServerName((ServerName)serverName)));
        Assert.assertTrue(((Long)newPids.get(0) < 0L ? 1 : 0) != 0);
        LOG.info("pid is {}", newPids.get(0));
        this.waitOnPids(pids);
    }

    @Test
    public void testRunHbckChore() throws Exception {
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        long endTimestamp = master.getHbckChore().getCheckingEndTimestamp();
        Hbck hbck = this.getHbck();
        boolean ran = false;
        while (!ran) {
            ran = hbck.runHbckChore();
            if (!ran) continue;
            Assert.assertTrue((master.getHbckChore().getCheckingEndTimestamp() > endTimestamp ? 1 : 0) != 0);
        }
    }

    private void waitOnPids(List<Long> pids) {
        TEST_UTIL.waitFor(60000L, () -> pids.stream().allMatch(arg_0 -> procExec.isFinished(arg_0)));
    }

    public static class SuspendProcedure
    extends ProcedureTestingUtility.NoopProcedure<MasterProcedureEnv>
    implements TableProcedureInterface {
        protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException {
            throw new ProcedureSuspendedException();
        }

        public TableName getTableName() {
            return TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.READ;
        }
    }
}

