/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterFailoverBalancerPersistence {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterFailoverBalancerPersistence.class);

    @Test
    public void testMasterFailoverBalancerPersistence() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(3).build();
        TEST_UTIL.startMiniCluster(option);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster active = cluster.getMaster();
        ClusterMetrics clusterStatus = active.getClusterMetrics();
        Assert.assertTrue((boolean)clusterStatus.getBalancerOn());
        active = this.killActiveAndWaitForNewActive(cluster);
        clusterStatus = active.getClusterMetrics();
        Assert.assertTrue((boolean)clusterStatus.getBalancerOn());
        active.balanceSwitch(false);
        active = this.killActiveAndWaitForNewActive(cluster);
        clusterStatus = active.getClusterMetrics();
        Assert.assertFalse((boolean)clusterStatus.getBalancerOn());
        TEST_UTIL.shutdownMiniCluster();
    }

    private HMaster killActiveAndWaitForNewActive(MiniHBaseCluster cluster) throws InterruptedException, IOException {
        int activeIndex = this.getActiveMasterIndex(cluster);
        HMaster active = cluster.getMaster();
        cluster.stopMaster(activeIndex);
        cluster.waitOnMaster(activeIndex);
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster newActive = cluster.getMaster();
        Assert.assertFalse((active == newActive ? 1 : 0) != 0);
        return newActive;
    }

    private int getActiveMasterIndex(MiniHBaseCluster cluster) throws MasterNotRunningException {
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            return i;
        }
        throw new MasterNotRunningException();
    }
}

