/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestLogRoller {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLogRoller.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int LOG_ROLL_PERIOD = 20000;
    private static final String LOG_DIR = "WALs";
    private static final String ARCHIVE_DIR = "archiveWALs";
    private static final String WAL_PREFIX = "test-log-roller";
    private static Configuration CONF;
    private static LogRoller ROLLER;
    private static Path ROOT_DIR;
    private static FileSystem FS;

    @Before
    public void setup() throws Exception {
        CONF = TEST_UTIL.getConfiguration();
        CONF.setInt("hbase.regionserver.logroll.period", 20000);
        CONF.setInt("hbase.server.thread.wakefrequency", 300);
        ROOT_DIR = TEST_UTIL.getRandomDir();
        FS = FileSystem.get((Configuration)CONF);
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)CONF);
        ROLLER = new LogRoller(services);
        ROLLER.start();
    }

    @After
    public void tearDown() throws Exception {
        ROLLER.close();
        FS.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRequestRollWithMultiWal() throws Exception {
        HashMap<FSHLog, Path> wals = new HashMap<FSHLog, Path>();
        for (int i = 1; i <= 3; ++i) {
            FSHLog wal = new FSHLog(FS, ROOT_DIR, LOG_DIR, ARCHIVE_DIR, CONF, null, true, WAL_PREFIX, "." + i);
            wal.rollWriter(true);
            wals.put(wal, wal.getCurrentFileName());
            ROLLER.addWAL((WAL)wal);
            Thread.sleep(1000L);
        }
        Iterator it = wals.entrySet().iterator();
        Map.Entry walEntry = it.next();
        ((FSHLog)walEntry.getKey()).requestLogRoll();
        Thread.sleep(5000L);
        Assert.assertNotEquals(walEntry.getValue(), (Object)((FSHLog)walEntry.getKey()).getCurrentFileName());
        walEntry.setValue(((FSHLog)walEntry.getKey()).getCurrentFileName());
        while (it.hasNext()) {
            walEntry = it.next();
            Assert.assertEquals(walEntry.getValue(), (Object)((FSHLog)walEntry.getKey()).getCurrentFileName());
        }
        Thread.sleep(25000L);
        for (Map.Entry entry : wals.entrySet()) {
            Assert.assertNotEquals(entry.getValue(), (Object)((FSHLog)entry.getKey()).getCurrentFileName());
            ((FSHLog)entry.getKey()).close();
        }
    }
}

