/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestReadAndWriteRegionInfoFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReadAndWriteRegionInfoFile.class);
    private static final HBaseCommonTestingUtility UTIL = new HBaseTestingUtility();
    private static final Configuration CONF = UTIL.getConfiguration();
    private static FileSystem FS;
    private static Path ROOT_DIR;

    @BeforeClass
    public static void setUp() throws IOException {
        ROOT_DIR = UTIL.getDataTestDir();
        FS = ROOT_DIR.getFileSystem(CONF);
    }

    @AfterClass
    public static void tearDown() {
        UTIL.cleanupTestDir();
    }

    @Test
    public void testReadAndWriteRegionInfoFile() throws IOException, InterruptedException {
        RegionInfo ri = RegionInfoBuilder.FIRST_META_REGIONINFO;
        FSTableDescriptors fsTableDescriptors = new FSTableDescriptors(CONF, FS, ROOT_DIR);
        HRegion r = HBaseTestingUtility.createRegionAndWAL(ri, ROOT_DIR, CONF, fsTableDescriptors.get(TableName.META_TABLE_NAME));
        long modtime = this.getModTime(r);
        HBaseTestingUtility.closeRegionAndWAL(r);
        Thread.sleep(1001L);
        r = HRegion.openHRegion((Path)ROOT_DIR, (RegionInfo)ri, (TableDescriptor)fsTableDescriptors.get(TableName.META_TABLE_NAME), null, (Configuration)CONF);
        long modtime2 = this.getModTime(r);
        Assert.assertEquals((long)modtime, (long)modtime2);
        HRegionFileSystem.loadRegionInfoFileContent((FileSystem)r.getRegionFileSystem().getFileSystem(), (Path)r.getRegionFileSystem().getRegionDir());
        HBaseTestingUtility.closeRegionAndWAL(r);
    }

    private long getModTime(HRegion r) throws IOException {
        FileStatus[] statuses = r.getRegionFileSystem().getFileSystem().listStatus(new Path(r.getRegionFileSystem().getRegionDir(), ".regioninfo"));
        Assert.assertTrue((statuses != null && statuses.length == 1 ? 1 : 0) != 0);
        return statuses[0].getModificationTime();
    }
}

