/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.HbckErrorReporter;
import org.apache.hadoop.hbase.util.HbckRegionInfo;
import org.apache.hadoop.hbase.util.HbckTableInfo;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTestHBaseFsck {
    static final int POOL_SIZE = 7;
    protected static final Logger LOG = LoggerFactory.getLogger(BaseTestHBaseFsck.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final Configuration conf = TEST_UTIL.getConfiguration();
    protected static final String FAM_STR = "fam";
    protected static final byte[] FAM = Bytes.toBytes((String)"fam");
    protected static final int REGION_ONLINE_TIMEOUT = 800;
    protected static AssignmentManager assignmentManager;
    protected static RegionStates regionStates;
    protected static ExecutorService tableExecutorService;
    protected static ScheduledThreadPoolExecutor hbfsckExecutorService;
    protected static ClusterConnection connection;
    protected static Admin admin;
    protected Table tbl;
    protected static final byte[][] SPLITS;
    protected static final byte[][] ROWKEYS;
    @Rule
    public TestName name = new TestName();

    protected void dumpMeta(TableName tableName) throws IOException {
        List<byte[]> metaRows = TEST_UTIL.getMetaTableRows(tableName);
        for (byte[] row : metaRows) {
            LOG.info(Bytes.toString((byte[])row));
        }
    }

    protected void undeployRegion(Connection conn, ServerName sn, RegionInfo hri) throws IOException, InterruptedException {
        try {
            HBaseFsckRepair.closeRegionSilentlyAndWait((Connection)conn, (ServerName)sn, (RegionInfo)hri);
            if (!hri.isMetaRegion()) {
                admin.offline(hri.getRegionName());
            }
        }
        catch (IOException ioe) {
            LOG.warn("Got exception when attempting to offline region " + Bytes.toString((byte[])hri.getRegionName()), (Throwable)ioe);
        }
    }

    protected void deleteRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey, boolean unassign, boolean metaRow, boolean hdfs) throws IOException, InterruptedException {
        this.deleteRegion(conf, htd, startKey, endKey, unassign, metaRow, hdfs, false, 0);
    }

    protected void deleteRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey, boolean unassign, boolean metaRow, boolean hdfs, boolean regionInfoOnly, int replicaId) throws IOException, InterruptedException {
        List locations;
        LOG.info("** Before delete:");
        this.dumpMeta(htd.getTableName());
        try (RegionLocator rl = connection.getRegionLocator(this.tbl.getName());){
            locations = rl.getAllRegionLocations();
        }
        for (HRegionLocation location : locations) {
            HRegionInfo hri = location.getRegionInfo();
            ServerName hsa = location.getServerName();
            if (Bytes.compareTo((byte[])hri.getStartKey(), (byte[])startKey) == 0 && Bytes.compareTo((byte[])hri.getEndKey(), (byte[])endKey) == 0 && hri.getReplicaId() == replicaId) {
                Path p;
                FileSystem fs;
                Path rootDir;
                LOG.info("RegionName: " + hri.getRegionNameAsString());
                byte[] deleteRow = hri.getRegionName();
                if (unassign) {
                    LOG.info("Undeploying region " + hri + " from server " + hsa);
                    this.undeployRegion((Connection)connection, hsa, (RegionInfo)hri);
                }
                if (regionInfoOnly) {
                    LOG.info("deleting hdfs .regioninfo data: " + hri.toString() + hsa.toString());
                    rootDir = FSUtils.getRootDir((Configuration)conf);
                    fs = rootDir.getFileSystem(conf);
                    p = new Path(FSUtils.getTableDir((Path)rootDir, (TableName)htd.getTableName()), hri.getEncodedName());
                    Path hriPath = new Path(p, ".regioninfo");
                    fs.delete(hriPath, true);
                }
                if (hdfs) {
                    LOG.info("deleting hdfs data: " + hri.toString() + hsa.toString());
                    rootDir = FSUtils.getRootDir((Configuration)conf);
                    fs = rootDir.getFileSystem(conf);
                    p = new Path(FSUtils.getTableDir((Path)rootDir, (TableName)htd.getTableName()), hri.getEncodedName());
                    HBaseFsck.debugLsr((Configuration)conf, (Path)p);
                    boolean success = fs.delete(p, true);
                    LOG.info("Deleted " + p + " sucessfully? " + success);
                    HBaseFsck.debugLsr((Configuration)conf, (Path)p);
                }
                if (metaRow) {
                    try (Table meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);){
                        Delete delete = new Delete(deleteRow);
                        meta.delete(delete);
                    }
                }
            }
            LOG.info(hri.toString() + hsa.toString());
        }
        TEST_UTIL.getMetaTableRows(htd.getTableName());
        LOG.info("*** After delete:");
        this.dumpMeta(htd.getTableName());
    }

    void setupTable(TableName tablename) throws Exception {
        this.setupTableWithRegionReplica(tablename, 1);
    }

    void setupTableWithRegionReplica(TableName tablename, int replicaCount) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tablename);
        desc.setRegionReplication(replicaCount);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
        desc.addFamily(hcd);
        BaseTestHBaseFsck.createTable(TEST_UTIL, desc, SPLITS);
        this.tbl = connection.getTable(tablename, tableExecutorService);
        ArrayList<Put> puts = new ArrayList<Put>(ROWKEYS.length);
        for (byte[] row : ROWKEYS) {
            Put p = new Put(row);
            p.addColumn(FAM, Bytes.toBytes((String)"val"), row);
            puts.add(p);
        }
        this.tbl.put(puts);
    }

    void setupMobTable(TableName tablename) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tablename);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(0L);
        desc.addFamily(hcd);
        BaseTestHBaseFsck.createTable(TEST_UTIL, desc, SPLITS);
        this.tbl = connection.getTable(tablename, tableExecutorService);
        ArrayList<Put> puts = new ArrayList<Put>(ROWKEYS.length);
        for (byte[] row : ROWKEYS) {
            Put p = new Put(row);
            p.addColumn(FAM, Bytes.toBytes((String)"val"), row);
            puts.add(p);
        }
        this.tbl.put(puts);
    }

    int countRows() throws IOException {
        return TEST_UTIL.countRows(this.tbl);
    }

    int countRows(byte[] start, byte[] end) throws IOException {
        return TEST_UTIL.countRows(this.tbl, new Scan(start, end));
    }

    void cleanupTable(TableName tablename) throws Exception {
        if (this.tbl != null) {
            this.tbl.close();
            this.tbl = null;
        }
        connection.clearRegionLocationCache();
        BaseTestHBaseFsck.deleteTable(TEST_UTIL, tablename);
    }

    Map<ServerName, List<String>> getDeployedHRIs(Admin admin) throws IOException {
        ClusterMetrics status = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
        Set regionServers = status.getLiveServerMetrics().keySet();
        HashMap<ServerName, List<String>> mm = new HashMap<ServerName, List<String>>();
        for (ServerName hsi : regionServers) {
            AdminProtos.AdminService.BlockingInterface server = connection.getAdmin(hsi);
            List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server);
            ArrayList<String> regionNames = new ArrayList<String>(regions.size());
            for (RegionInfo hri : regions) {
                regionNames.add(hri.getRegionNameAsString());
            }
            mm.put(hsi, regionNames);
        }
        return mm;
    }

    ServerName findDeployedHSI(Map<ServerName, List<String>> mm, RegionInfo hri) {
        for (Map.Entry<ServerName, List<String>> e : mm.entrySet()) {
            if (!e.getValue().contains(hri.getRegionNameAsString())) continue;
            return e.getKey();
        }
        return null;
    }

    public void deleteTableDir(TableName table) throws IOException {
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        Path p = FSUtils.getTableDir((Path)rootDir, (TableName)table);
        HBaseFsck.debugLsr((Configuration)conf, (Path)p);
        boolean success = fs.delete(p, true);
        LOG.info("Deleted " + p + " sucessfully? " + success);
    }

    /*
     * Unable to fully structure code
     */
    Path getFlushedHFile(FileSystem fs, TableName table) throws IOException {
        tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)BaseTestHBaseFsck.conf), (TableName)table);
        regionDir = (Path)FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir).get(0);
        famDir = new Path(regionDir, "fam");
        block0: while (true) {
            if ((hfFss = fs.listStatus(famDir)).length == 0) {
                continue;
            }
            var7_7 = hfFss;
            var8_8 = var7_7.length;
            var9_9 = 0;
            while (true) {
                if (var9_9 < var8_8) ** break;
                continue block0;
                hfs = var7_7[var9_9];
                if (!hfs.isDirectory()) {
                    return hfs.getPath();
                }
                ++var9_9;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    Path getFlushedMobFile(FileSystem fs, TableName table) throws IOException {
        famDir = MobUtils.getMobFamilyPath((Configuration)BaseTestHBaseFsck.conf, (TableName)table, (String)"fam");
        block0: while (true) {
            if ((hfFss = fs.listStatus(famDir)).length == 0) {
                continue;
            }
            var5_5 = hfFss;
            var6_6 = var5_5.length;
            var7_7 = 0;
            while (true) {
                if (var7_7 < var6_6) ** break;
                continue block0;
                hfs = var5_5[var7_7];
                if (!hfs.isDirectory()) {
                    return hfs.getPath();
                }
                ++var7_7;
            }
            break;
        }
    }

    String createMobFileName(String oldFileName) {
        MobFileName mobFileName = MobFileName.create((String)oldFileName);
        String startKey = mobFileName.getStartKey();
        String date = mobFileName.getDate();
        return MobFileName.create((String)startKey, (String)date, (String)TEST_UTIL.getRandomUUID().toString().replaceAll("-", "")).getFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doQuarantineTest(TableName table, HBaseFsck hbck, int check, int corrupt, int fail, int quar, int missing) throws Exception {
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            admin.disableTable(table);
            String[] args = new String[]{"-sidelineCorruptHFiles", "-repairHoles", "-ignorePreCheckPermission", table.getNameAsString()};
            HBaseFsck res = hbck.exec((ExecutorService)hbfsckExecutorService, args);
            HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
            Assert.assertEquals((long)hfcc.getHFilesChecked(), (long)check);
            Assert.assertEquals((long)hfcc.getCorrupted().size(), (long)corrupt);
            Assert.assertEquals((long)hfcc.getFailures().size(), (long)fail);
            Assert.assertEquals((long)hfcc.getQuarantined().size(), (long)quar);
            Assert.assertEquals((long)hfcc.getMissing().size(), (long)missing);
            admin.enableTableAsync(table);
            while (!admin.isTableEnabled(table)) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Assert.fail((String)("Interrupted when trying to enable table " + table));
                }
            }
        }
        finally {
            this.cleanupTable(table);
        }
    }

    protected void deleteMetaRegion(Configuration conf, boolean unassign, boolean hdfs, boolean regionInfoOnly) throws IOException, InterruptedException {
        Path p;
        FileSystem fs;
        Path rootDir;
        HRegionLocation metaLocation = connection.getRegionLocator(TableName.META_TABLE_NAME).getRegionLocation(HConstants.EMPTY_START_ROW);
        ServerName hsa = metaLocation.getServerName();
        HRegionInfo hri = metaLocation.getRegionInfo();
        if (unassign) {
            LOG.info("Undeploying meta region " + hri + " from server " + hsa);
            try (Connection unmanagedConnection = ConnectionFactory.createConnection((Configuration)conf);){
                this.undeployRegion(unmanagedConnection, hsa, (RegionInfo)hri);
            }
        }
        if (regionInfoOnly) {
            LOG.info("deleting hdfs .regioninfo data: " + hri.toString() + hsa.toString());
            rootDir = FSUtils.getRootDir((Configuration)conf);
            fs = rootDir.getFileSystem(conf);
            p = new Path(rootDir + "/" + TableName.META_TABLE_NAME.getNameAsString(), hri.getEncodedName());
            Path hriPath = new Path(p, ".regioninfo");
            fs.delete(hriPath, true);
        }
        if (hdfs) {
            LOG.info("deleting hdfs data: " + hri.toString() + hsa.toString());
            rootDir = FSUtils.getRootDir((Configuration)conf);
            fs = rootDir.getFileSystem(conf);
            p = new Path(rootDir + "/" + TableName.META_TABLE_NAME.getNameAsString(), hri.getEncodedName());
            HBaseFsck.debugLsr((Configuration)conf, (Path)p);
            boolean success = fs.delete(p, true);
            LOG.info("Deleted " + p + " sucessfully? " + success);
            HBaseFsck.debugLsr((Configuration)conf, (Path)p);
        }
    }

    public static void createTable(HBaseTestingUtility testUtil, HTableDescriptor htd, byte[][] splitKeys) throws Exception {
        MasterSyncCoprocessor coproc = (MasterSyncCoprocessor)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncCoprocessor.class);
        coproc.tableCreationLatch = new CountDownLatch(1);
        if (splitKeys != null) {
            admin.createTable((TableDescriptor)htd, splitKeys);
        } else {
            admin.createTable((TableDescriptor)htd);
        }
        coproc.tableCreationLatch.await();
        coproc.tableCreationLatch = null;
        testUtil.waitUntilAllRegionsAssigned(htd.getTableName());
    }

    public static void deleteTable(HBaseTestingUtility testUtil, TableName tableName) throws Exception {
        MasterSyncCoprocessor coproc = (MasterSyncCoprocessor)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncCoprocessor.class);
        coproc.tableDeletionLatch = new CountDownLatch(1);
        try {
            admin.disableTable(tableName);
        }
        catch (Exception e) {
            LOG.debug("Table: " + tableName + " already disabled, so just deleting it.");
        }
        admin.deleteTable(tableName);
        coproc.tableDeletionLatch.await();
        coproc.tableDeletionLatch = null;
    }

    static {
        SPLITS = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")};
        ROWKEYS = new byte[][]{Bytes.toBytes((String)"00"), Bytes.toBytes((String)"50"), Bytes.toBytes((String)"A0"), Bytes.toBytes((String)"A5"), Bytes.toBytes((String)"B0"), Bytes.toBytes((String)"B5"), Bytes.toBytes((String)"C0"), Bytes.toBytes((String)"C5")};
    }

    public static class MasterSyncCoprocessor
    implements MasterCoprocessor,
    MasterObserver {
        volatile CountDownLatch tableCreationLatch = null;
        volatile CountDownLatch tableDeletionLatch = null;

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void postCompletedCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            if (this.tableCreationLatch != null) {
                this.tableCreationLatch.countDown();
            }
        }

        public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            if (this.tableDeletionLatch != null) {
                this.tableDeletionLatch.countDown();
            }
        }
    }

    static class MockErrorReporter
    implements HbckErrorReporter {
        static int calledCount = 0;

        MockErrorReporter() {
        }

        public void clear() {
            ++calledCount;
        }

        public void report(String message) {
            ++calledCount;
        }

        public void reportError(String message) {
            ++calledCount;
        }

        public void reportError(HbckErrorReporter.ERROR_CODE errorCode, String message) {
            ++calledCount;
        }

        public void reportError(HbckErrorReporter.ERROR_CODE errorCode, String message, HbckTableInfo table) {
            ++calledCount;
        }

        public void reportError(HbckErrorReporter.ERROR_CODE errorCode, String message, HbckTableInfo table, HbckRegionInfo info) {
            ++calledCount;
        }

        public void reportError(HbckErrorReporter.ERROR_CODE errorCode, String message, HbckTableInfo table, HbckRegionInfo info1, HbckRegionInfo info2) {
            ++calledCount;
        }

        public int summarize() {
            return ++calledCount;
        }

        public void detail(String details) {
            ++calledCount;
        }

        public ArrayList<HbckErrorReporter.ERROR_CODE> getErrorList() {
            ++calledCount;
            return new ArrayList<HbckErrorReporter.ERROR_CODE>();
        }

        public void progress() {
            ++calledCount;
        }

        public void print(String message) {
            ++calledCount;
        }

        public void resetErrors() {
            ++calledCount;
        }

        public boolean tableHasErrors(HbckTableInfo table) {
            ++calledCount;
            return false;
        }
    }
}

