/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncMetaRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncMetaRegionLocator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncMetaRegionLocator.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ConnectionRegistry REGISTRY;
    private static AsyncMetaRegionLocator LOCATOR;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        REGISTRY = ConnectionRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());
        RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(TEST_UTIL, REGISTRY);
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
        LOCATOR = new AsyncMetaRegionLocator(REGISTRY);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)REGISTRY, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        RegionReplicaTestHelper.testLocator(TEST_UTIL, TableName.META_TABLE_NAME, new RegionReplicaTestHelper.Locator(){

            @Override
            public void updateCachedLocationOnError(HRegionLocation loc, Throwable error) throws Exception {
                LOCATOR.updateCachedLocationOnError(loc, error);
            }

            @Override
            public RegionLocations getRegionLocations(TableName tableName, int replicaId, boolean reload) throws Exception {
                return (RegionLocations)LOCATOR.getRegionLocations(replicaId, reload).get();
            }
        });
    }
}

