/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableNoncedRetry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableNoncedRetry.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static byte[] VALUE = Bytes.toBytes((String)"value");
    private static AsyncConnection ASYNC_CONN;
    @Rule
    public TestName testName = new TestName();
    private byte[] row;
    private static AtomicInteger CALLED;
    private static long SLEEP_TIME;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setCoprocessor(SleepOnceCP.class.getName()).build());
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)ASYNC_CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.row = Bytes.toBytes((String)this.testName.getMethodName().replaceAll("[^0-9A-Za-z]", "_"));
        CALLED.set(0);
    }

    @Test
    public void testAppend() throws InterruptedException, ExecutionException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        AsyncTable table = ASYNC_CONN.getTableBuilder(TABLE_NAME).setRpcTimeout(SLEEP_TIME / 2L, TimeUnit.MILLISECONDS).build();
        Result result = (Result)table.append(new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).get();
        Assert.assertEquals((long)2L, (long)CALLED.get());
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
    }

    @Test
    public void testIncrement() throws InterruptedException, ExecutionException {
        Assert.assertEquals((long)0L, (long)CALLED.get());
        AsyncTable table = ASYNC_CONN.getTableBuilder(TABLE_NAME).setRpcTimeout(SLEEP_TIME / 2L, TimeUnit.MILLISECONDS).build();
        Assert.assertEquals((long)1L, (long)((Long)table.incrementColumnValue(this.row, FAMILY, QUALIFIER, 1L).get()));
        Assert.assertEquals((long)2L, (long)CALLED.get());
    }

    static {
        CALLED = new AtomicInteger();
        SLEEP_TIME = 2000L;
    }

    public static final class SleepOnceCP
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append, Result result) throws IOException {
            if (CALLED.getAndIncrement() == 0) {
                Threads.sleepWithoutInterrupt((long)SLEEP_TIME);
            }
            return super.postAppend(c, append, result);
        }

        public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
            if (CALLED.getAndIncrement() == 0) {
                Threads.sleepWithoutInterrupt((long)SLEEP_TIME);
            }
            return super.postIncrement(c, increment, result);
        }
    }
}

