/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestFailedMetaReplicaAssigment {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFailedMetaReplicaAssigment.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.meta.replica.count", 3);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numAlwaysStandByMasters(1).numMasters(1).numRegionServers(1).masterClass(BrokenMetaReplicaMaster.class).build();
        TEST_UTIL.startMiniCluster(option);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFailedReplicaAssignment() throws InterruptedException {
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        TEST_UTIL.waitFor(30000L, () -> master.isInitialized());
        AssignmentManager am = master.getAssignmentManager();
        RegionInfo metaReplicaHri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)1);
        TEST_UTIL.waitFor(30000L, () -> {
            RegionStateNode metaReplicaRegionNode = am.getRegionStates().getOrCreateRegionStateNode(metaReplicaHri);
            return metaReplicaRegionNode.getRegionLocation() != null;
        });
        RegionInfo metaReplicaHri2 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)2);
        RegionStateNode metaReplicaRegionNode2 = am.getRegionStates().getOrCreateRegionStateNode(metaReplicaHri2);
        for (int i = 0; i < 3; ++i) {
            Thread.sleep(2000L);
            Assert.assertNull((Object)metaReplicaRegionNode2.getRegionLocation());
        }
        Assert.assertFalse((boolean)master.isStopping());
        Assert.assertFalse((boolean)master.isStopped());
        Assert.assertTrue((boolean)master.isActiveMaster());
    }

    public static class BrokenMasterMetaAssignmentManager
    extends AssignmentManager {
        MasterServices master;

        public BrokenMasterMetaAssignmentManager(MasterServices master) {
            super(master);
            this.master = master;
        }

        public Future<byte[]> assignAsync(RegionInfo regionInfo, ServerName sn) throws IOException {
            RegionStateNode regionNode = this.getRegionStates().getOrCreateRegionStateNode(regionInfo);
            if (regionNode.getRegionInfo().getReplicaId() == 2) {
                regionNode.setProcedure((TransitRegionStateProcedure)new BrokenTransitRegionStateProcedure());
            }
            return super.assignAsync(regionInfo, sn);
        }
    }

    public static class BrokenMetaReplicaMaster
    extends HMaster {
        public BrokenMetaReplicaMaster(Configuration conf) throws IOException {
            super(conf);
        }

        public AssignmentManager createAssignmentManager(MasterServices master) {
            return new BrokenMasterMetaAssignmentManager(master);
        }
    }

    public static class BrokenTransitRegionStateProcedure
    extends TransitRegionStateProcedure {
        protected BrokenTransitRegionStateProcedure() {
            super(null, null, null, false, TransitRegionStateProcedure.TransitionType.ASSIGN);
        }
    }
}

