/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterFailoverWithMetaReplica {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterFailoverWithMetaReplica.class);
    private static final int num_of_meta_replica = 2;

    @Test
    public void testMasterFailoverWithMetaReplica() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 2);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(2).numRegionServers(2).build();
        TEST_UTIL.startMiniCluster(option);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster oldMaster = cluster.getMaster();
        for (int replicaId = 1; replicaId < 2; ++replicaId) {
            RegionInfo h = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId);
            AssignmentTestingUtil.waitForAssignment(oldMaster.getAssignmentManager(), h);
        }
        int oldProcedureNum = oldMaster.getProcedures().size();
        int activeIndex = -1;
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            activeIndex = i;
        }
        cluster.stopMaster(activeIndex);
        cluster.waitOnMaster(activeIndex);
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster newMaster = cluster.getMaster();
        Assert.assertFalse((oldMaster == newMaster ? 1 : 0) != 0);
        int newProcedureNum = newMaster.getProcedures().size();
        Assert.assertEquals((long)newMaster.getServerManager().getOnlineServers().size(), (long)2L);
        Assert.assertEquals((long)oldProcedureNum, (long)newProcedureNum);
        TEST_UTIL.shutdownMiniCluster();
    }
}

