/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestBulkLoad {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBulkLoad.class);
    @ClassRule
    public static TemporaryFolder testFolder = new TemporaryFolder();
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final WAL log = (WAL)Mockito.mock(WAL.class);
    private final Configuration conf = HBaseConfiguration.create();
    private final Random random = new Random();
    private final byte[] randomBytes = new byte[100];
    private final byte[] family1 = Bytes.toBytes((String)"family1");
    private final byte[] family2 = Bytes.toBytes((String)"family2");
    private final byte[] family3 = Bytes.toBytes((String)"family3");
    @Rule
    public TestName name = new TestName();

    @Before
    public void before() throws IOException {
        this.random.nextBytes(this.randomBytes);
    }

    @Test
    public void verifyBulkLoadEvent() throws IOException {
        TableName tableName = TableName.valueOf((String)"test", (String)"test");
        List<Pair<byte[], String>> familyPaths = this.withFamilyPathsFor(new byte[][]{this.family1});
        byte[] familyName = (byte[])familyPaths.get(0).getFirst();
        String storeFileName = (String)familyPaths.get(0).getSecond();
        storeFileName = new Path(storeFileName).getName();
        ArrayList<String> storeFileNames = new ArrayList<String>();
        storeFileNames.add(storeFileName);
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestBulkLoad.bulkLogWalEdit(WALEdit.BULK_LOAD, tableName.toBytes(), familyName, storeFileNames)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        this.testRegionWithFamiliesAndSpecifiedTableName(tableName, new byte[][]{this.family1}).bulkLoadHFiles(familyPaths, false, null);
        ((WAL)Mockito.verify((Object)this.log)).sync(ArgumentMatchers.anyLong());
    }

    @Test
    public void bulkHLogShouldThrowNoErrorAndWriteMarkerWithBlankInput() throws IOException {
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(new ArrayList(), false, null);
    }

    @Test
    public void shouldBulkLoadSingleFamilyHLog() throws IOException {
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(this.withFamilyPathsFor(new byte[][]{this.family1}), false, null);
        ((WAL)Mockito.verify((Object)this.log)).sync(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldBulkLoadManyFamilyHLog() throws IOException {
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        this.testRegionWithFamilies(this.family1, this.family2).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
        ((WAL)Mockito.verify((Object)this.log)).sync(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldBulkLoadManyFamilyHLogEvenWhenTableNameNamespaceSpecified() throws IOException {
        Mockito.when((Object)this.log.appendMarker((RegionInfo)ArgumentMatchers.any(), (WALKeyImpl)ArgumentMatchers.any(), (WALEdit)MockitoHamcrest.argThat(TestBulkLoad.bulkLogWalEditType(WALEdit.BULK_LOAD)))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                WALKeyImpl walKey = (WALKeyImpl)invocation.getArgument(1);
                MultiVersionConcurrencyControl mvcc = walKey.getMvcc();
                if (mvcc != null) {
                    MultiVersionConcurrencyControl.WriteEntry we = mvcc.begin();
                    walKey.setWriteEntry(we);
                }
                return 1L;
            }
        });
        TableName tableName = TableName.valueOf((String)"test", (String)"test");
        this.testRegionWithFamiliesAndSpecifiedTableName(tableName, this.family1, this.family2).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
        ((WAL)Mockito.verify((Object)this.log)).sync(ArgumentMatchers.anyLong());
    }

    @Test(expected=DoNotRetryIOException.class)
    public void shouldCrashIfBulkLoadFamiliesNotInTable() throws IOException {
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void shouldCrashIfBulkLoadMultiFamiliesNotInTable() throws IOException {
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(this.withFamilyPathsFor(this.family1, this.family2, this.family3), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void bulkHLogShouldThrowErrorWhenFamilySpecifiedAndHFileExistsButNotInTableDescriptor() throws IOException {
        this.testRegionWithFamilies(new byte[0][]).bulkLoadHFiles(this.withFamilyPathsFor(new byte[][]{this.family1}), false, null);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void shouldThrowErrorIfBadFamilySpecifiedAsFamilyPath() throws IOException {
        this.testRegionWithFamilies(new byte[0][]).bulkLoadHFiles(Arrays.asList(this.withInvalidColumnFamilyButProperHFileLocation(this.family1)), false, null);
    }

    @Test(expected=FileNotFoundException.class)
    public void shouldThrowErrorIfHFileDoesNotExist() throws IOException {
        List<Pair> list = Arrays.asList(this.withMissingHFileForFamily(this.family1));
        this.testRegionWithFamilies(new byte[][]{this.family1}).bulkLoadHFiles(list, false, null);
    }

    @Test(expected=FileNotFoundException.class)
    public void shouldThrowErrorIfMultiHFileDoesNotExist() throws IOException {
        ArrayList<Pair> list = new ArrayList<Pair>();
        list.addAll(Arrays.asList(this.withMissingHFileForFamily(this.family1)));
        list.addAll(Arrays.asList(this.withMissingHFileForFamily(this.family2)));
        this.testRegionWithFamilies(this.family1, this.family2).bulkLoadHFiles(list, false, null);
    }

    private Pair<byte[], String> withMissingHFileForFamily(byte[] family) {
        return new Pair((Object)family, (Object)this.getNotExistFilePath());
    }

    private String getNotExistFilePath() {
        Path path = new Path(TEST_UTIL.getDataTestDir(), "does_not_exist");
        return path.toUri().getPath();
    }

    private Pair<byte[], String> withInvalidColumnFamilyButProperHFileLocation(byte[] family) throws IOException {
        this.createHFileForFamilies(family);
        return new Pair((Object)new byte[]{0, 1, 2}, (Object)this.getNotExistFilePath());
    }

    private HRegion testRegionWithFamiliesAndSpecifiedTableName(TableName tableName, byte[] ... families) throws IOException {
        HRegionInfo hRegionInfo = new HRegionInfo(tableName);
        HTableDescriptor hTableDescriptor = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            hTableDescriptor.addFamily(new HColumnDescriptor(family));
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return HRegion.createHRegion((RegionInfo)hRegionInfo, (Path)new Path(testFolder.newFolder().toURI()), (Configuration)this.conf, (TableDescriptor)hTableDescriptor, (WAL)this.log);
    }

    private HRegion testRegionWithFamilies(byte[] ... families) throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        return this.testRegionWithFamiliesAndSpecifiedTableName(tableName, families);
    }

    private List<Pair<byte[], String>> getBlankFamilyPaths() {
        return new ArrayList<Pair<byte[], String>>();
    }

    private List<Pair<byte[], String>> withFamilyPathsFor(byte[] ... families) throws IOException {
        List<Pair<byte[], String>> familyPaths = this.getBlankFamilyPaths();
        for (byte[] family : families) {
            familyPaths.add((Pair<byte[], String>)new Pair((Object)family, (Object)this.createHFileForFamilies(family)));
        }
        return familyPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHFileForFamilies(byte[] family) throws IOException {
        HFile.WriterFactory hFileFactory = HFile.getWriterFactoryNoCache((Configuration)this.conf);
        File hFileLocation = testFolder.newFile();
        try (FSDataOutputStream out = new FSDataOutputStream((OutputStream)new FileOutputStream(hFileLocation), null);){
            hFileFactory.withOutputStream(out);
            hFileFactory.withFileContext(new HFileContextBuilder().build());
            try (HFile.Writer writer = hFileFactory.create();){
                writer.append((Cell)new KeyValue(CellUtil.createCell((byte[])this.randomBytes, (byte[])family, (byte[])this.randomBytes, (long)0L, (byte)KeyValue.Type.Put.getCode(), (byte[])this.randomBytes)));
            }
        }
        return hFileLocation.getAbsoluteFile().getAbsolutePath();
    }

    private static Matcher<WALEdit> bulkLogWalEditType(byte[] typeBytes) {
        return new WalMatcher(typeBytes);
    }

    private static Matcher<WALEdit> bulkLogWalEdit(byte[] typeBytes, byte[] tableName, byte[] familyName, List<String> storeFileNames) {
        return new WalMatcher(typeBytes, tableName, familyName, storeFileNames);
    }

    private static class WalMatcher
    extends TypeSafeMatcher<WALEdit> {
        private final byte[] typeBytes;
        private final byte[] tableName;
        private final byte[] familyName;
        private final List<String> storeFileNames;

        public WalMatcher(byte[] typeBytes) {
            this(typeBytes, null, null, null);
        }

        public WalMatcher(byte[] typeBytes, byte[] tableName, byte[] familyName, List<String> storeFileNames) {
            this.typeBytes = typeBytes;
            this.tableName = tableName;
            this.familyName = familyName;
            this.storeFileNames = storeFileNames;
        }

        protected boolean matchesSafely(WALEdit item) {
            WALProtos.BulkLoadDescriptor desc;
            Assert.assertTrue((boolean)Arrays.equals(CellUtil.cloneQualifier((Cell)((Cell)item.getCells().get(0))), this.typeBytes));
            try {
                desc = WALEdit.getBulkLoadDescriptor((Cell)((Cell)item.getCells().get(0)));
            }
            catch (IOException e) {
                return false;
            }
            Assert.assertNotNull((Object)desc);
            if (this.tableName != null) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])ProtobufUtil.toTableName((HBaseProtos.TableName)desc.getTableName()).getName(), (byte[])this.tableName));
            }
            if (this.storeFileNames != null) {
                boolean index = false;
                WALProtos.StoreDescriptor store = desc.getStores(0);
                Assert.assertTrue((boolean)Bytes.equals((byte[])store.getFamilyName().toByteArray(), (byte[])this.familyName));
                Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)store.getStoreHomeDir()), (byte[])this.familyName));
                Assert.assertEquals((long)this.storeFileNames.size(), (long)store.getStoreFileCount());
            }
            return true;
        }

        public void describeTo(Description description) {
        }
    }
}

