/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.replication.regionserver.DumpReplicationQueues;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestDumpReplicationQueues {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDumpReplicationQueues.class);

    @Test
    public void testDumpReplicationReturnsWalSorted() throws Exception {
        Configuration config = HBaseConfiguration.create();
        ZKWatcher zkWatcherMock = (ZKWatcher)Mockito.mock(ZKWatcher.class);
        ZNodePaths zNodePath = new ZNodePaths(config);
        RecoverableZooKeeper recoverableZooKeeperMock = (RecoverableZooKeeper)Mockito.mock(RecoverableZooKeeper.class);
        Mockito.when((Object)zkWatcherMock.getRecoverableZooKeeper()).thenReturn((Object)recoverableZooKeeperMock);
        Mockito.when((Object)zkWatcherMock.getZNodePaths()).thenReturn((Object)zNodePath);
        ArrayList<String> nodes = new ArrayList<String>();
        String server = "rs1,60030," + System.currentTimeMillis();
        nodes.add(server);
        Mockito.when((Object)recoverableZooKeeperMock.getChildren("/hbase/rs", null)).thenReturn(nodes);
        Mockito.when((Object)recoverableZooKeeperMock.getChildren("/hbase/replication/rs", null)).thenReturn(nodes);
        ArrayList<String> queuesIds = new ArrayList<String>();
        queuesIds.add("1");
        Mockito.when((Object)recoverableZooKeeperMock.getChildren("/hbase/replication/rs/" + server, null)).thenReturn(queuesIds);
        ArrayList<String> wals = new ArrayList<String>();
        wals.add("rs1%2C60964%2C1549394085556.1549394101427");
        wals.add("rs1%2C60964%2C1549394085556.1549394101426");
        wals.add("rs1%2C60964%2C1549394085556.1549394101428");
        Mockito.when((Object)recoverableZooKeeperMock.getChildren("/hbase/replication/rs/" + server + "/1", null)).thenReturn(wals);
        DumpReplicationQueues dumpQueues = new DumpReplicationQueues();
        HashSet<String> peerIds = new HashSet<String>();
        peerIds.add("1");
        dumpQueues.setConf(config);
        String dump = dumpQueues.dumpQueues(zkWatcherMock, peerIds, false);
        String[] parsedDump = dump.split("Replication position for");
        Assert.assertEquals((String)"Parsed dump should have 4 parts.", (long)4L, (long)parsedDump.length);
        Assert.assertTrue((String)("First wal should be rs1%2C60964%2C1549394085556.1549394101426, but got: " + parsedDump[1]), (parsedDump[1].indexOf("rs1%2C60964%2C1549394085556.1549394101426") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Second wal should be rs1%2C60964%2C1549394085556.1549394101427, but got: " + parsedDump[2]), (parsedDump[2].indexOf("rs1%2C60964%2C1549394085556.1549394101427") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Third wal should be rs1%2C60964%2C1549394085556.1549394101428, but got: " + parsedDump[3]), (parsedDump[3].indexOf("rs1%2C60964%2C1549394085556.1549394101428") >= 0 ? 1 : 0) != 0);
    }
}

