/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.function.Consumer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class DoubleArrayCost {
    private double[] costs;
    private boolean costsChanged;
    private double cost;

    DoubleArrayCost() {
    }

    void prepare(int length) {
        if (this.costs == null || this.costs.length != length) {
            this.costs = new double[length];
        }
    }

    void applyCostsChange(Consumer<double[]> consumer) {
        consumer.accept(this.costs);
        this.costsChanged = true;
    }

    double cost() {
        if (this.costsChanged) {
            this.cost = DoubleArrayCost.computeCost(this.costs);
            this.costsChanged = false;
        }
        return this.cost;
    }

    private static double computeCost(double[] stats) {
        double totalCost = 0.0;
        double total = DoubleArrayCost.getSum(stats);
        double count = stats.length;
        double mean = total / count;
        for (int i = 0; i < stats.length; ++i) {
            double n = stats[i];
            double diff = Math.abs(mean - n);
            totalCost += diff;
        }
        return StochasticLoadBalancer.scale(DoubleArrayCost.getMinSkew(total, count), DoubleArrayCost.getMaxSkew(total, count), totalCost);
    }

    private static double getSum(double[] stats) {
        double total = 0.0;
        for (double s : stats) {
            total += s;
        }
        return total;
    }

    public static double getMinSkew(double total, double numServers) {
        double min;
        double mean = total / numServers;
        if (numServers > total) {
            min = (numServers - total) * mean + (1.0 - mean) * total;
        } else {
            int numHigh = (int)(total - Math.floor(mean) * numServers);
            int numLow = (int)(numServers - (double)numHigh);
            min = (double)numHigh * (Math.ceil(mean) - mean) + (double)numLow * (mean - Math.floor(mean));
        }
        return min;
    }

    public static double getMaxSkew(double total, double numServers) {
        double mean = total / numServers;
        return total - mean + (numServers - 1.0) * mean;
    }
}

