/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.SplitWALManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.SplitWALRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitWALProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.SplitWALState>
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SplitWALProcedure.class);
    private String walPath;
    private ServerName worker;
    private ServerName crashedServer;
    private RetryCounter retryCounter;

    public SplitWALProcedure() {
    }

    public SplitWALProcedure(String walPath, ServerName crashedServer) {
        this.walPath = walPath;
        this.crashedServer = crashedServer;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SplitWALState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        SplitWALManager splitWALManager = env.getMasterServices().getSplitWALManager();
        switch (state) {
            case ACQUIRE_SPLIT_WAL_WORKER: {
                this.worker = splitWALManager.acquireSplitWALWorker((Procedure<?>)this);
                this.setNextState(MasterProcedureProtos.SplitWALState.DISPATCH_WAL_TO_WORKER);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case DISPATCH_WAL_TO_WORKER: {
                assert (this.worker != null);
                this.addChildProcedure(new SplitWALRemoteProcedure[]{new SplitWALRemoteProcedure(this.worker, this.crashedServer, this.walPath)});
                this.setNextState(MasterProcedureProtos.SplitWALState.RELEASE_SPLIT_WORKER);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case RELEASE_SPLIT_WORKER: {
                boolean finished;
                try {
                    finished = splitWALManager.isSplitWALFinished(this.walPath);
                }
                catch (IOException ioe) {
                    if (this.retryCounter == null) {
                        this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
                    }
                    long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
                    LOG.warn("Failed to check whether splitting wal {} success, wait {} seconds to retry", new Object[]{this.walPath, backoff / 1000L, ioe});
                    this.setTimeout(Math.toIntExact(backoff));
                    this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                    this.skipPersistence();
                    throw new ProcedureSuspendedException();
                }
                splitWALManager.releaseSplitWALWorker(this.worker, env.getProcedureScheduler());
                if (!finished) {
                    LOG.warn("Failed to split wal {} by server {}, retry...", (Object)this.walPath, (Object)this.worker);
                    this.setNextState(MasterProcedureProtos.SplitWALState.ACQUIRE_SPLIT_WAL_WORKER);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                ServerCrashProcedure.updateProgress(env, this.getParentProcId());
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.SplitWALState splitOneWalState) throws IOException, InterruptedException {
        if (splitOneWalState == this.getInitialState()) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    protected MasterProcedureProtos.SplitWALState getState(int stateId) {
        return MasterProcedureProtos.SplitWALState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.SplitWALState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.SplitWALState getInitialState() {
        return MasterProcedureProtos.SplitWALState.ACQUIRE_SPLIT_WAL_WORKER;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.SplitWALData.Builder builder = MasterProcedureProtos.SplitWALData.newBuilder();
        builder.setWalPath(this.walPath).setCrashedServer(ProtobufUtil.toServerName((ServerName)this.crashedServer));
        if (this.worker != null) {
            builder.setWorker(ProtobufUtil.toServerName((ServerName)this.worker));
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.SplitWALData data = (MasterProcedureProtos.SplitWALData)serializer.deserialize(MasterProcedureProtos.SplitWALData.class);
        this.walPath = data.getWalPath();
        this.crashedServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getCrashedServer());
        if (data.hasWorker()) {
            this.worker = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getWorker());
        }
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront((Procedure)this);
        return false;
    }

    public String getWAL() {
        return this.walPath;
    }

    @VisibleForTesting
    public ServerName getWorker() {
        return this.worker;
    }

    @Override
    public ServerName getServerName() {
        return this.crashedServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return AbstractFSWALProvider.isMetaFile(new Path(this.walPath));
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.SPLIT_WAL;
    }

    protected void afterReplay(MasterProcedureEnv env) {
        if (this.worker != null && env != null && env.getMasterServices() != null && env.getMasterServices().getSplitWALManager() != null) {
            env.getMasterServices().getSplitWALManager().addUsedSplitWALWorker(this.worker);
        }
    }

    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getProcName());
        if (this.worker != null) {
            builder.append(", worker=");
            builder.append(this.worker);
        }
        if (this.retryCounter != null) {
            builder.append(", retry=");
            builder.append(this.retryCounter);
        }
    }

    public String getProcName() {
        return this.getClass().getSimpleName() + " " + SplitWALProcedure.getWALNameFromStrPath(this.getWAL());
    }

    static String getWALNameFromStrPath(String path) {
        int slashIndex = path.lastIndexOf(47);
        return slashIndex != -1 ? path.substring(slashIndex + 1) : path;
    }
}

