/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import org.apache.hadoop.hbase.replication.regionserver.SerialReplicationChecker;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SerialReplicationSourceWALReader
extends ReplicationSourceWALReader {
    private Cell firstCellInEntryBeforeFiltering;
    private final SerialReplicationChecker checker;

    public SerialReplicationSourceWALReader(FileSystem fs, Configuration conf, ReplicationSourceLogQueue logQueue, long startPosition, WALEntryFilter filter, ReplicationSource source, String walGroupId) {
        super(fs, conf, logQueue, startPosition, filter, source, walGroupId);
        this.checker = new SerialReplicationChecker(conf, source);
    }

    @Override
    protected WALEntryBatch readWALEntries(WALEntryStream entryStream, WALEntryBatch batch) throws IOException, InterruptedException {
        boolean hasNext;
        Path currentPath = entryStream.getCurrentPath();
        if (!entryStream.hasNext()) {
            if (currentPath != null && SerialReplicationSourceWALReader.switched(entryStream, currentPath)) {
                return WALEntryBatch.endOfFile(currentPath);
            }
            return null;
        }
        if (currentPath != null) {
            if (SerialReplicationSourceWALReader.switched(entryStream, currentPath)) {
                return WALEntryBatch.endOfFile(currentPath);
            }
        } else {
            currentPath = entryStream.getCurrentPath();
        }
        long positionBefore = entryStream.getPosition();
        batch = this.createBatch(entryStream);
        do {
            WAL.Entry entry = entryStream.peek();
            boolean doFiltering = true;
            if (this.firstCellInEntryBeforeFiltering == null) {
                assert (!entry.getEdit().isEmpty()) : "should not write empty edits";
                this.firstCellInEntryBeforeFiltering = entry.getEdit().getCells().get(0);
            } else {
                doFiltering = false;
            }
            if (doFiltering) {
                entry = this.filterEntry(entry);
            }
            if (entry != null) {
                if (!this.checker.canPush(entry, this.firstCellInEntryBeforeFiltering)) {
                    if (batch.getLastWalPosition() > positionBefore) break;
                    this.checker.waitUntilCanPush(entry, this.firstCellInEntryBeforeFiltering);
                }
                batch.setLastSeqId(Bytes.toString((byte[])entry.getKey().getEncodedRegionName()), entry.getKey().getSequenceId());
                this.removeEntryFromStream(entryStream, batch);
                if (this.addEntryToBatch(batch, entry)) {
                    break;
                }
            } else {
                this.removeEntryFromStream(entryStream, batch);
            }
            hasNext = entryStream.hasNext();
            if (!SerialReplicationSourceWALReader.switched(entryStream, currentPath)) continue;
            batch.setEndOfFile(true);
            break;
        } while (hasNext);
        return batch;
    }

    private void removeEntryFromStream(WALEntryStream entryStream, WALEntryBatch batch) throws IOException {
        entryStream.next();
        this.firstCellInEntryBeforeFiltering = null;
        batch.setLastWalPosition(entryStream.getPosition());
    }
}

