/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestRAMCache {
    private static final Logger LOG = LoggerFactory.getLogger(TestRAMCache.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRAMCache.class);

    @Test
    public void testAtomicRAMCache() throws Exception {
        int size = 100;
        int length = 33 + size;
        byte[] byteArr = new byte[length];
        BucketCache.RAMCache cache = new BucketCache.RAMCache();
        BlockCacheKey key = new BlockCacheKey("file-1", 1L);
        MockHFileBlock blk = new MockHFileBlock(BlockType.DATA, size, size, -1L, ByteBuffer.wrap(byteArr, 0, size), true, -1L, 52, -1, new HFileContextBuilder().build(), ByteBuffAllocator.HEAP);
        BucketCache.RAMQueueEntry re = new BucketCache.RAMQueueEntry(key, (Cacheable)blk, 1L, false, ByteBuffAllocator.NONE);
        Assert.assertNull((Object)cache.putIfAbsent(key, re));
        Assert.assertEquals((Object)cache.putIfAbsent(key, re), (Object)re);
        CountDownLatch latch = new CountDownLatch(1);
        blk.setLatch(latch);
        AtomicBoolean error = new AtomicBoolean(false);
        Thread t1 = new Thread(() -> {
            try {
                cache.get(key);
            }
            catch (Exception e) {
                error.set(true);
            }
        });
        t1.start();
        Thread.sleep(200L);
        AtomicBoolean removed = new AtomicBoolean(false);
        Thread t2 = new Thread(() -> {
            cache.remove(key);
            removed.set(true);
        });
        t2.start();
        Thread.sleep(200L);
        Assert.assertFalse((boolean)removed.get());
        latch.countDown();
        Thread.sleep(200L);
        Assert.assertTrue((boolean)removed.get());
        Assert.assertFalse((boolean)error.get());
    }

    private static class MockHFileBlock
    extends HFileBlock {
        private volatile CountDownLatch latch;

        MockHFileBlock(BlockType blockType, int onDiskSizeWithoutHeader, int uncompressedSizeWithoutHeader, long prevBlockOffset, ByteBuffer b, boolean fillHeader, long offset, int nextBlockOnDiskSize, int onDiskDataSizeWithHeader, HFileContext fileContext, ByteBuffAllocator allocator) {
            super(blockType, onDiskSizeWithoutHeader, uncompressedSizeWithoutHeader, prevBlockOffset, ByteBuff.wrap((ByteBuffer)b), fillHeader, offset, nextBlockOnDiskSize, onDiskDataSizeWithHeader, fileContext, allocator);
        }

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public MockHFileBlock retain() {
            try {
                if (this.latch != null) {
                    this.latch.await();
                }
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted exception error: ", (Throwable)e);
            }
            super.retain();
            return this;
        }
    }
}

