/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestStochasticLoadBalancerBalanceCluster
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerBalanceCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestStochasticLoadBalancerBalanceCluster.class);

    @Test
    public void testBalanceCluster() throws Exception {
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 180000L);
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 20000000L);
        loadBalancer.setConf(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            TreeMap<ServerName, List<RegionInfo>> servers = this.mockClusterServers(mockCluster);
            List<ServerAndLoad> list = this.convertToList(servers);
            LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
            HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(servers);
            List plans = loadBalancer.balanceCluster(LoadOfAllTable);
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, servers);
            LOG.info("Mock Balance : " + this.printMock(balancedCluster));
            this.assertClusterAsBalanced(balancedCluster);
            LoadOfAllTable = this.mockClusterServersWithTables(servers);
            List secondPlans = loadBalancer.balanceCluster(LoadOfAllTable);
            Assert.assertNull((Object)secondPlans);
            for (Map.Entry entry : servers.entrySet()) {
                this.returnRegions((List)entry.getValue());
                this.returnServer((ServerName)entry.getKey());
            }
        }
    }
}

