/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={FilterTests.class, MediumTests.class})
public class TestMultipleColumnPrefixFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultipleColumnPrefixFilter.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @Test
    public void testMultipleColumnPrefixFilter() throws IOException {
        String family = "Family";
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMaxVersions(3);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        HRegion region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
        List<String> rows = this.generateRandomWords(100, "row");
        List<String> columns = this.generateRandomWords(10000, "column");
        long maxTimestamp = 2L;
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        HashMap prefixMap = new HashMap();
        prefixMap.put("p", new ArrayList());
        prefixMap.put("q", new ArrayList());
        prefixMap.put("s", new ArrayList());
        String valueString = "ValueString";
        for (String row : rows) {
            Put p = new Put(Bytes.toBytes((String)row));
            p.setDurability(Durability.SKIP_WAL);
            for (String column : columns) {
                for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                    KeyValue kv = KeyValueTestUtil.create((String)row, (String)family, (String)column, (long)timestamp, (String)valueString);
                    p.add((Cell)kv);
                    kvList.add(kv);
                    for (String s : prefixMap.keySet()) {
                        if (!column.startsWith(s)) continue;
                        ((List)prefixMap.get(s)).add(kv);
                    }
                }
            }
            region.put(p);
        }
        Scan scan = new Scan();
        scan.setMaxVersions();
        byte[][] filter_prefix = new byte[][]{{112}, {113}};
        MultipleColumnPrefixFilter filter = new MultipleColumnPrefixFilter((byte[][])filter_prefix);
        scan.setFilter((Filter)filter);
        ArrayList results = new ArrayList();
        HRegion.RegionScannerImpl scanner = region.getScanner(scan);
        while (scanner.next(results)) {
        }
        Assert.assertEquals((long)(((List)prefixMap.get("p")).size() + ((List)prefixMap.get("q")).size()), (long)results.size());
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testMultipleColumnPrefixFilterWithManyFamilies() throws IOException {
        String family1 = "Family1";
        String family2 = "Family2";
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor hcd1 = new HColumnDescriptor(family1);
        hcd1.setMaxVersions(3);
        htd.addFamily(hcd1);
        HColumnDescriptor hcd2 = new HColumnDescriptor(family2);
        hcd2.setMaxVersions(3);
        htd.addFamily(hcd2);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        HRegion region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
        List<String> rows = this.generateRandomWords(100, "row");
        List<String> columns = this.generateRandomWords(10000, "column");
        long maxTimestamp = 3L;
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        HashMap prefixMap = new HashMap();
        prefixMap.put("p", new ArrayList());
        prefixMap.put("q", new ArrayList());
        prefixMap.put("s", new ArrayList());
        String valueString = "ValueString";
        for (String row : rows) {
            Put p = new Put(Bytes.toBytes((String)row));
            p.setDurability(Durability.SKIP_WAL);
            for (String column : columns) {
                for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                    double rand = Math.random();
                    KeyValue kv = rand < 0.5 ? KeyValueTestUtil.create((String)row, (String)family1, (String)column, (long)timestamp, (String)valueString) : KeyValueTestUtil.create((String)row, (String)family2, (String)column, (long)timestamp, (String)valueString);
                    p.add((Cell)kv);
                    kvList.add(kv);
                    for (String s : prefixMap.keySet()) {
                        if (!column.startsWith(s)) continue;
                        ((List)prefixMap.get(s)).add(kv);
                    }
                }
            }
            region.put(p);
        }
        Scan scan = new Scan();
        scan.setMaxVersions();
        byte[][] filter_prefix = new byte[][]{{112}, {113}};
        MultipleColumnPrefixFilter filter = new MultipleColumnPrefixFilter((byte[][])filter_prefix);
        scan.setFilter((Filter)filter);
        ArrayList results = new ArrayList();
        HRegion.RegionScannerImpl scanner = region.getScanner(scan);
        while (scanner.next(results)) {
        }
        Assert.assertEquals((long)(((List)prefixMap.get("p")).size() + ((List)prefixMap.get("q")).size()), (long)results.size());
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testMultipleColumnPrefixFilterWithColumnPrefixFilter() throws IOException {
        String family = "Family";
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        htd.addFamily(new HColumnDescriptor(family));
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        HRegion region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
        List<String> rows = this.generateRandomWords(100, "row");
        List<String> columns = this.generateRandomWords(10000, "column");
        long maxTimestamp = 2L;
        String valueString = "ValueString";
        for (String row : rows) {
            Put p = new Put(Bytes.toBytes((String)row));
            p.setDurability(Durability.SKIP_WAL);
            for (String column : columns) {
                for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                    KeyValue kv = KeyValueTestUtil.create((String)row, (String)family, (String)column, (long)timestamp, (String)valueString);
                    p.add((Cell)kv);
                }
            }
            region.put(p);
        }
        Scan scan1 = new Scan();
        scan1.setMaxVersions();
        byte[][] filter_prefix = new byte[][]{{112}};
        MultipleColumnPrefixFilter multiplePrefixFilter = new MultipleColumnPrefixFilter((byte[][])filter_prefix);
        scan1.setFilter((Filter)multiplePrefixFilter);
        ArrayList results1 = new ArrayList();
        HRegion.RegionScannerImpl scanner1 = region.getScanner(scan1);
        while (scanner1.next(results1)) {
        }
        Scan scan2 = new Scan();
        scan2.setMaxVersions();
        ColumnPrefixFilter singlePrefixFilter = new ColumnPrefixFilter(Bytes.toBytes((String)"p"));
        scan2.setFilter((Filter)singlePrefixFilter);
        ArrayList results2 = new ArrayList();
        HRegion.RegionScannerImpl scanner2 = region.getScanner(scan1);
        while (scanner2.next(results2)) {
        }
        Assert.assertEquals((long)results1.size(), (long)results2.size());
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    List<String> generateRandomWords(int numberOfWords, String suffix) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            int lengthOfWords = (int)(Math.random() * 2.0) + 1;
            char[] wordChar = new char[lengthOfWords];
            for (int j = 0; j < wordChar.length; ++j) {
                wordChar[j] = (char)(Math.random() * 26.0 + 97.0);
            }
            String word = suffix == null ? new String(wordChar) : new String(wordChar) + suffix;
            wordSet.add(word);
        }
        ArrayList<String> wordList = new ArrayList<String>(wordSet);
        return wordList;
    }
}

