/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.thrift2.generated.TColumn;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TDeleteType;
import org.apache.hadoop.hbase.thrift2.generated.TDurability;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TMutation;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.thrift2.generated.TTimeRange;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ThriftUtilities {
    private ThriftUtilities() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static Get getFromThrift(TGet in) throws IOException {
        Get out = new Get(in.getRow());
        if (in.isSetTimestamp()) {
            out.setTimeStamp(in.getTimestamp());
        } else if (in.isSetTimeRange()) {
            out.setTimeRange(in.getTimeRange().getMinStamp(), in.getTimeRange().getMaxStamp());
        }
        if (in.isSetMaxVersions()) {
            out.setMaxVersions(in.getMaxVersions());
        }
        if (in.isSetFilterString()) {
            ParseFilter parseFilter = new ParseFilter();
            out.setFilter(parseFilter.parseFilterString(in.getFilterString()));
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (!in.isSetColumns()) {
            return out;
        }
        for (TColumn column : in.getColumns()) {
            if (column.isSetQualifier()) {
                out.addColumn(column.getFamily(), column.getQualifier());
                continue;
            }
            out.addFamily(column.getFamily());
        }
        return out;
    }

    public static List<Get> getsFromThrift(List<TGet> in) throws IOException {
        ArrayList<Get> out = new ArrayList<Get>(in.size());
        for (TGet get2 : in) {
            out.add(ThriftUtilities.getFromThrift(get2));
        }
        return out;
    }

    public static TResult resultFromHBase(Result in) {
        Cell[] raw = in.rawCells();
        TResult out = new TResult();
        byte[] row = in.getRow();
        if (row != null) {
            out.setRow(in.getRow());
        }
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        for (Cell kv : raw) {
            TColumnValue col = new TColumnValue();
            col.setFamily(CellUtil.cloneFamily((Cell)kv));
            col.setQualifier(CellUtil.cloneQualifier((Cell)kv));
            col.setTimestamp(kv.getTimestamp());
            col.setValue(CellUtil.cloneValue((Cell)kv));
            columnValues.add(col);
        }
        out.setColumnValues(columnValues);
        return out;
    }

    public static List<TResult> resultsFromHBase(Result[] in) {
        ArrayList<TResult> out = new ArrayList<TResult>(in.length);
        for (Result result : in) {
            out.add(ThriftUtilities.resultFromHBase(result));
        }
        return out;
    }

    public static Put putFromThrift(TPut in) {
        Put out = in.isSetTimestamp() ? new Put(in.getRow(), in.getTimestamp()) : new Put(in.getRow());
        if (in.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        for (TColumnValue columnValue : in.getColumnValues()) {
            if (columnValue.isSetTimestamp()) {
                out.add(columnValue.getFamily(), columnValue.getQualifier(), columnValue.getTimestamp(), columnValue.getValue());
                continue;
            }
            out.add(columnValue.getFamily(), columnValue.getQualifier(), columnValue.getValue());
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        return out;
    }

    public static List<Put> putsFromThrift(List<TPut> in) {
        ArrayList<Put> out = new ArrayList<Put>(in.size());
        for (TPut put2 : in) {
            out.add(ThriftUtilities.putFromThrift(put2));
        }
        return out;
    }

    public static Delete deleteFromThrift(TDelete in) {
        Delete out;
        if (in.isSetColumns()) {
            out = new Delete(in.getRow());
            for (TColumn column : in.getColumns()) {
                if (column.isSetQualifier()) {
                    if (column.isSetTimestamp()) {
                        if (in.isSetDeleteType() && in.getDeleteType().equals((Object)TDeleteType.DELETE_COLUMNS)) {
                            out.deleteColumns(column.getFamily(), column.getQualifier(), column.getTimestamp());
                            continue;
                        }
                        out.deleteColumn(column.getFamily(), column.getQualifier(), column.getTimestamp());
                        continue;
                    }
                    if (in.isSetDeleteType() && in.getDeleteType().equals((Object)TDeleteType.DELETE_COLUMNS)) {
                        out.deleteColumns(column.getFamily(), column.getQualifier());
                        continue;
                    }
                    out.deleteColumn(column.getFamily(), column.getQualifier());
                    continue;
                }
                if (column.isSetTimestamp()) {
                    out.deleteFamily(column.getFamily(), column.getTimestamp());
                    continue;
                }
                out.deleteFamily(column.getFamily());
            }
        } else {
            out = in.isSetTimestamp() ? new Delete(in.getRow(), in.getTimestamp()) : new Delete(in.getRow());
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        return out;
    }

    public static List<Delete> deletesFromThrift(List<TDelete> in) {
        ArrayList<Delete> out = new ArrayList<Delete>(in.size());
        for (TDelete delete : in) {
            out.add(ThriftUtilities.deleteFromThrift(delete));
        }
        return out;
    }

    public static TDelete deleteFromHBase(Delete in) {
        TDelete out = new TDelete(ByteBuffer.wrap(in.getRow()));
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        long rowTimestamp = in.getTimeStamp();
        if (rowTimestamp != Long.MAX_VALUE) {
            out.setTimestamp(rowTimestamp);
        }
        for (Map.Entry familyEntry : in.getFamilyCellMap().entrySet()) {
            TColumn column = new TColumn(ByteBuffer.wrap((byte[])familyEntry.getKey()));
            for (Cell cell : (List)familyEntry.getValue()) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                byte[] family = kv.getFamily();
                byte[] qualifier = kv.getQualifier();
                long timestamp = kv.getTimestamp();
                if (family != null) {
                    column.setFamily(family);
                }
                if (qualifier != null) {
                    column.setQualifier(qualifier);
                }
                if (timestamp == Long.MAX_VALUE) continue;
                column.setTimestamp(kv.getTimestamp());
            }
            columns.add(column);
        }
        out.setColumns(columns);
        return out;
    }

    public static RowMutations rowMutationsFromThrift(TRowMutations in) throws IOException {
        RowMutations out = new RowMutations(in.getRow());
        List<TMutation> mutations = in.getMutations();
        for (TMutation mutation : mutations) {
            if (mutation.isSetPut()) {
                out.add(ThriftUtilities.putFromThrift(mutation.getPut()));
            }
            if (!mutation.isSetDeleteSingle()) continue;
            out.add(ThriftUtilities.deleteFromThrift(mutation.getDeleteSingle()));
        }
        return out;
    }

    public static Scan scanFromThrift(TScan in) throws IOException {
        TTimeRange timeRange;
        Scan out = new Scan();
        if (in.isSetStartRow()) {
            out.setStartRow(in.getStartRow());
        }
        if (in.isSetStopRow()) {
            out.setStopRow(in.getStopRow());
        }
        if (in.isSetCaching()) {
            out.setCaching(in.getCaching());
        }
        if (in.isSetMaxVersions()) {
            out.setMaxVersions(in.getMaxVersions());
        }
        if (in.isSetColumns()) {
            for (TColumn column : in.getColumns()) {
                if (column.isSetQualifier()) {
                    out.addColumn(column.getFamily(), column.getQualifier());
                    continue;
                }
                out.addFamily(column.getFamily());
            }
        }
        if ((timeRange = in.getTimeRange()) != null && timeRange.isSetMinStamp() && timeRange.isSetMaxStamp()) {
            out.setTimeRange(timeRange.getMinStamp(), timeRange.getMaxStamp());
        }
        if (in.isSetBatchSize()) {
            out.setBatch(in.getBatchSize());
        }
        if (in.isSetFilterString()) {
            ParseFilter parseFilter = new ParseFilter();
            out.setFilter(parseFilter.parseFilterString(in.getFilterString()));
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        return out;
    }

    public static Increment incrementFromThrift(TIncrement in) throws IOException {
        Increment out = new Increment(in.getRow());
        for (TColumnIncrement column : in.getColumns()) {
            out.addColumn(column.getFamily(), column.getQualifier(), column.getAmount());
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        return out;
    }

    private static void addAttributes(OperationWithAttributes op, Map<ByteBuffer, ByteBuffer> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return;
        }
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : attributes.entrySet()) {
            String name = Bytes.toStringBinary((byte[])Bytes.getBytes((ByteBuffer)entry.getKey()));
            byte[] value = Bytes.getBytes((ByteBuffer)entry.getValue());
            op.setAttribute(name, value);
        }
    }

    private static Durability durabilityFromThrift(TDurability tDurability) {
        switch (tDurability.getValue()) {
            case 1: {
                return Durability.SKIP_WAL;
            }
            case 2: {
                return Durability.ASYNC_WAL;
            }
            case 3: {
                return Durability.SYNC_WAL;
            }
            case 4: {
                return Durability.FSYNC_WAL;
            }
        }
        return null;
    }
}

