/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;

@InterfaceAudience.Private
public class CallQueue
implements BlockingQueue<Runnable> {
    private static Log LOG = LogFactory.getLog(CallQueue.class);
    private final BlockingQueue<Call> underlyingQueue;
    private final ThriftMetrics metrics;

    public CallQueue(BlockingQueue<Call> underlyingQueue, ThriftMetrics metrics) {
        this.underlyingQueue = underlyingQueue;
        this.metrics = metrics;
    }

    private static long now() {
        return System.nanoTime();
    }

    @Override
    public Runnable poll() {
        Call result = (Call)this.underlyingQueue.poll();
        this.updateMetrics(result);
        return result;
    }

    private void updateMetrics(Call result) {
        if (result == null) {
            return;
        }
        this.metrics.incTimeInQueue(result.timeInQueue());
        this.metrics.setCallQueueLen(this.size());
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        Call result = this.underlyingQueue.poll(timeout, unit);
        this.updateMetrics(result);
        return result;
    }

    @Override
    public Runnable remove() {
        Call result = (Call)this.underlyingQueue.remove();
        this.updateMetrics(result);
        return result;
    }

    @Override
    public Runnable take() throws InterruptedException {
        Call result = this.underlyingQueue.take();
        this.updateMetrics(result);
        return result;
    }

    @Override
    public int drainTo(Collection<? super Runnable> destination) {
        return this.drainTo(destination, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super Runnable> destination, int maxElements) {
        if (destination == this) {
            throw new IllegalArgumentException("A BlockingQueue cannot drain to itself.");
        }
        ArrayList drained = new ArrayList();
        this.underlyingQueue.drainTo(drained, maxElements);
        for (Call r : drained) {
            this.updateMetrics(r);
        }
        destination.addAll(drained);
        int sz = drained.size();
        LOG.info((Object)("Elements drained: " + sz));
        return sz;
    }

    @Override
    public boolean offer(Runnable element) {
        return this.underlyingQueue.offer(new Call(element));
    }

    @Override
    public boolean offer(Runnable element, long timeout, TimeUnit unit) throws InterruptedException {
        return this.underlyingQueue.offer(new Call(element), timeout, unit);
    }

    @Override
    public void put(Runnable element) throws InterruptedException {
        this.underlyingQueue.put(new Call(element));
    }

    @Override
    public boolean add(Runnable element) {
        return this.underlyingQueue.add(new Call(element));
    }

    @Override
    public boolean addAll(Collection<? extends Runnable> elements) {
        int added = 0;
        for (Runnable runnable : elements) {
            added += this.underlyingQueue.add(new Call(runnable)) ? 1 : 0;
        }
        return added != 0;
    }

    @Override
    public Runnable element() {
        return (Runnable)this.underlyingQueue.element();
    }

    @Override
    public Runnable peek() {
        return (Runnable)this.underlyingQueue.peek();
    }

    @Override
    public void clear() {
        this.underlyingQueue.clear();
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        return this.underlyingQueue.containsAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingQueue.isEmpty();
    }

    @Override
    public Iterator<Runnable> iterator() {
        return new Iterator<Runnable>(){
            final Iterator<Call> underlyingIterator;
            {
                this.underlyingIterator = CallQueue.this.underlyingQueue.iterator();
            }

            @Override
            public Runnable next() {
                return this.underlyingIterator.next();
            }

            @Override
            public boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            @Override
            public void remove() {
                this.underlyingIterator.remove();
            }
        };
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        return this.underlyingQueue.removeAll(elements);
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        return this.underlyingQueue.retainAll(elements);
    }

    @Override
    public int size() {
        return this.underlyingQueue.size();
    }

    @Override
    public Object[] toArray() {
        return this.underlyingQueue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.underlyingQueue.toArray(array);
    }

    @Override
    public boolean contains(Object element) {
        return this.underlyingQueue.contains(element);
    }

    @Override
    public int remainingCapacity() {
        return this.underlyingQueue.remainingCapacity();
    }

    @Override
    public boolean remove(Object element) {
        return this.underlyingQueue.remove(element);
    }

    public static class Call
    implements Runnable {
        final long startTime;
        final Runnable underlyingRunnable;

        Call(Runnable underlyingRunnable) {
            this.underlyingRunnable = underlyingRunnable;
            this.startTime = CallQueue.now();
        }

        @Override
        public void run() {
            this.underlyingRunnable.run();
        }

        public long timeInQueue() {
            return CallQueue.now() - this.startTime;
        }

        public boolean equals(Object other) {
            if (other instanceof Call) {
                Call otherCall = (Call)other;
                return this.underlyingRunnable.equals(otherCall.underlyingRunnable);
            }
            if (other instanceof Runnable) {
                return this.underlyingRunnable.equals(other);
            }
            return false;
        }

        public int hashCode() {
            return this.underlyingRunnable.hashCode();
        }
    }
}

