/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.thrift2.generated.TCellVisibility;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TDurability;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TAppend
implements TBase<TAppend, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("TAppend");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 2);
    private static final TField ATTRIBUTES_FIELD_DESC = new TField("attributes", 13, 3);
    private static final TField DURABILITY_FIELD_DESC = new TField("durability", 8, 4);
    private static final TField CELL_VISIBILITY_FIELD_DESC = new TField("cellVisibility", 12, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer row;
    public List<TColumnValue> columns;
    public Map<ByteBuffer, ByteBuffer> attributes;
    public TDurability durability;
    public TCellVisibility cellVisibility;
    private _Fields[] optionals = new _Fields[]{_Fields.ATTRIBUTES, _Fields.DURABILITY, _Fields.CELL_VISIBILITY};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TAppend() {
    }

    public TAppend(ByteBuffer row, List<TColumnValue> columns) {
        this();
        this.row = row;
        this.columns = columns;
    }

    public TAppend(TAppend other) {
        if (other.isSetRow()) {
            this.row = TBaseHelper.copyBinary((ByteBuffer)other.row);
        }
        if (other.isSetColumns()) {
            ArrayList<TColumnValue> __this__columns = new ArrayList<TColumnValue>();
            for (TColumnValue tColumnValue : other.columns) {
                __this__columns.add(new TColumnValue(tColumnValue));
            }
            this.columns = __this__columns;
        }
        if (other.isSetAttributes()) {
            HashMap<ByteBuffer, ByteBuffer> __this__attributes = new HashMap<ByteBuffer, ByteBuffer>();
            for (Map.Entry entry : other.attributes.entrySet()) {
                ByteBuffer other_element_key = (ByteBuffer)entry.getKey();
                ByteBuffer other_element_value = (ByteBuffer)entry.getValue();
                ByteBuffer __this__attributes_copy_key = TBaseHelper.copyBinary((ByteBuffer)other_element_key);
                ByteBuffer __this__attributes_copy_value = TBaseHelper.copyBinary((ByteBuffer)other_element_value);
                __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
            }
            this.attributes = __this__attributes;
        }
        if (other.isSetDurability()) {
            this.durability = other.durability;
        }
        if (other.isSetCellVisibility()) {
            this.cellVisibility = new TCellVisibility(other.cellVisibility);
        }
    }

    public TAppend deepCopy() {
        return new TAppend(this);
    }

    public void clear() {
        this.row = null;
        this.columns = null;
        this.attributes = null;
        this.durability = null;
        this.cellVisibility = null;
    }

    public byte[] getRow() {
        this.setRow(TBaseHelper.rightSize((ByteBuffer)this.row));
        return this.row == null ? null : this.row.array();
    }

    public ByteBuffer bufferForRow() {
        return this.row;
    }

    public TAppend setRow(byte[] row) {
        this.setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
        return this;
    }

    public TAppend setRow(ByteBuffer row) {
        this.row = row;
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<TColumnValue> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(TColumnValue elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<TColumnValue>();
        }
        this.columns.add(elem);
    }

    public List<TColumnValue> getColumns() {
        return this.columns;
    }

    public TAppend setColumns(List<TColumnValue> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getAttributesSize() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
        if (this.attributes == null) {
            this.attributes = new HashMap<ByteBuffer, ByteBuffer>();
        }
        this.attributes.put(key, val);
    }

    public Map<ByteBuffer, ByteBuffer> getAttributes() {
        return this.attributes;
    }

    public TAppend setAttributes(Map<ByteBuffer, ByteBuffer> attributes) {
        this.attributes = attributes;
        return this;
    }

    public void unsetAttributes() {
        this.attributes = null;
    }

    public boolean isSetAttributes() {
        return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
        if (!value) {
            this.attributes = null;
        }
    }

    public TDurability getDurability() {
        return this.durability;
    }

    public TAppend setDurability(TDurability durability) {
        this.durability = durability;
        return this;
    }

    public void unsetDurability() {
        this.durability = null;
    }

    public boolean isSetDurability() {
        return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
        if (!value) {
            this.durability = null;
        }
    }

    public TCellVisibility getCellVisibility() {
        return this.cellVisibility;
    }

    public TAppend setCellVisibility(TCellVisibility cellVisibility) {
        this.cellVisibility = cellVisibility;
        return this;
    }

    public void unsetCellVisibility() {
        this.cellVisibility = null;
    }

    public boolean isSetCellVisibility() {
        return this.cellVisibility != null;
    }

    public void setCellVisibilityIsSet(boolean value) {
        if (!value) {
            this.cellVisibility = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((ByteBuffer)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case ATTRIBUTES: {
                if (value == null) {
                    this.unsetAttributes();
                    break;
                }
                this.setAttributes((Map)value);
                break;
            }
            case DURABILITY: {
                if (value == null) {
                    this.unsetDurability();
                    break;
                }
                this.setDurability((TDurability)((Object)value));
                break;
            }
            case CELL_VISIBILITY: {
                if (value == null) {
                    this.unsetCellVisibility();
                    break;
                }
                this.setCellVisibility((TCellVisibility)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROW: {
                return this.getRow();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case ATTRIBUTES: {
                return this.getAttributes();
            }
            case DURABILITY: {
                return this.getDurability();
            }
            case CELL_VISIBILITY: {
                return this.getCellVisibility();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ROW: {
                return this.isSetRow();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case ATTRIBUTES: {
                return this.isSetAttributes();
            }
            case DURABILITY: {
                return this.isSetDurability();
            }
            case CELL_VISIBILITY: {
                return this.isSetCellVisibility();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TAppend) {
            return this.equals((TAppend)that);
        }
        return false;
    }

    public boolean equals(TAppend that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!this.row.equals(that.row)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!((Object)this.columns).equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_attributes = this.isSetAttributes();
        boolean that_present_attributes = that.isSetAttributes();
        if (this_present_attributes || that_present_attributes) {
            if (!this_present_attributes || !that_present_attributes) {
                return false;
            }
            if (!((Object)this.attributes).equals(that.attributes)) {
                return false;
            }
        }
        boolean this_present_durability = this.isSetDurability();
        boolean that_present_durability = that.isSetDurability();
        if (this_present_durability || that_present_durability) {
            if (!this_present_durability || !that_present_durability) {
                return false;
            }
            if (!this.durability.equals((Object)that.durability)) {
                return false;
            }
        }
        boolean this_present_cellVisibility = this.isSetCellVisibility();
        boolean that_present_cellVisibility = that.isSetCellVisibility();
        if (this_present_cellVisibility || that_present_cellVisibility) {
            if (!this_present_cellVisibility || !that_present_cellVisibility) {
                return false;
            }
            if (!this.cellVisibility.equals(that.cellVisibility)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_row = this.isSetRow();
        builder.append(present_row);
        if (present_row) {
            builder.append((Object)this.row);
        }
        boolean present_columns = this.isSetColumns();
        builder.append(present_columns);
        if (present_columns) {
            builder.append(this.columns);
        }
        boolean present_attributes = this.isSetAttributes();
        builder.append(present_attributes);
        if (present_attributes) {
            builder.append(this.attributes);
        }
        boolean present_durability = this.isSetDurability();
        builder.append(present_durability);
        if (present_durability) {
            builder.append(this.durability.getValue());
        }
        boolean present_cellVisibility = this.isSetCellVisibility();
        builder.append(present_cellVisibility);
        if (present_cellVisibility) {
            builder.append((Object)this.cellVisibility);
        }
        return builder.toHashCode();
    }

    public int compareTo(TAppend other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        TAppend typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetRow()).compareTo(typedOther.isSetRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.row, (Comparable)typedOther.row)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(typedOther.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, typedOther.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAttributes()).compareTo(typedOther.isSetAttributes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAttributes() && (lastComparison = TBaseHelper.compareTo(this.attributes, typedOther.attributes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDurability()).compareTo(typedOther.isSetDurability());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDurability() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.durability), (Comparable)((Object)typedOther.durability))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCellVisibility()).compareTo(typedOther.isSetCellVisibility());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCellVisibility() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.cellVisibility), (Comparable)((Object)typedOther.cellVisibility))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TAppend(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.row, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        if (this.isSetAttributes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("attributes:");
            if (this.attributes == null) {
                sb.append("null");
            } else {
                sb.append(this.attributes);
            }
            first = false;
        }
        if (this.isSetDurability()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("durability:");
            if (this.durability == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.durability);
            }
            first = false;
        }
        if (this.isSetCellVisibility()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("cellVisibility:");
            if (this.cellVisibility == null) {
                sb.append("null");
            } else {
                sb.append(this.cellVisibility);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.row == null) {
            throw new TProtocolException("Required field 'row' was not present! Struct: " + this.toString());
        }
        if (this.columns == null) {
            throw new TProtocolException("Required field 'columns' was not present! Struct: " + this.toString());
        }
        if (this.cellVisibility != null) {
            this.cellVisibility.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TAppendStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TAppendTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ROW, new FieldMetaData("row", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TColumnValue.class))));
        tmpMap.put(_Fields.ATTRIBUTES, new FieldMetaData("attributes", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11, true), new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.DURABILITY, new FieldMetaData("durability", 2, (FieldValueMetaData)new EnumMetaData(16, TDurability.class)));
        tmpMap.put(_Fields.CELL_VISIBILITY, new FieldMetaData("cellVisibility", 2, (FieldValueMetaData)new StructMetaData(12, TCellVisibility.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TAppend.class, metaDataMap);
    }

    private static class TAppendTupleScheme
    extends TupleScheme<TAppend> {
        private TAppendTupleScheme() {
        }

        public void write(TProtocol prot, TAppend struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBinary(struct.row);
            oprot.writeI32(struct.columns.size());
            for (TColumnValue _iter97 : struct.columns) {
                _iter97.write((TProtocol)oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetAttributes()) {
                optionals.set(0);
            }
            if (struct.isSetDurability()) {
                optionals.set(1);
            }
            if (struct.isSetCellVisibility()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetAttributes()) {
                oprot.writeI32(struct.attributes.size());
                for (Map.Entry<ByteBuffer, ByteBuffer> _iter98 : struct.attributes.entrySet()) {
                    oprot.writeBinary(_iter98.getKey());
                    oprot.writeBinary(_iter98.getValue());
                }
            }
            if (struct.isSetDurability()) {
                oprot.writeI32(struct.durability.getValue());
            }
            if (struct.isSetCellVisibility()) {
                struct.cellVisibility.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, TAppend struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.row = iprot.readBinary();
            struct.setRowIsSet(true);
            TList _list99 = new TList(12, iprot.readI32());
            struct.columns = new ArrayList<TColumnValue>(_list99.size);
            for (int _i100 = 0; _i100 < _list99.size; ++_i100) {
                TColumnValue _elem101 = new TColumnValue();
                _elem101.read((TProtocol)iprot);
                struct.columns.add(_elem101);
            }
            struct.setColumnsIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                TMap _map102 = new TMap(11, 11, iprot.readI32());
                struct.attributes = new HashMap<ByteBuffer, ByteBuffer>(2 * _map102.size);
                for (int _i103 = 0; _i103 < _map102.size; ++_i103) {
                    ByteBuffer _key104 = iprot.readBinary();
                    ByteBuffer _val105 = iprot.readBinary();
                    struct.attributes.put(_key104, _val105);
                }
                struct.setAttributesIsSet(true);
            }
            if (incoming.get(1)) {
                struct.durability = TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
            }
            if (incoming.get(2)) {
                struct.cellVisibility = new TCellVisibility();
                struct.cellVisibility.read((TProtocol)iprot);
                struct.setCellVisibilityIsSet(true);
            }
        }
    }

    private static class TAppendTupleSchemeFactory
    implements SchemeFactory {
        private TAppendTupleSchemeFactory() {
        }

        public TAppendTupleScheme getScheme() {
            return new TAppendTupleScheme();
        }
    }

    private static class TAppendStandardScheme
    extends StandardScheme<TAppend> {
        private TAppendStandardScheme() {
        }

        public void read(TProtocol iprot, TAppend struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.row = iprot.readBinary();
                            struct.setRowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list88 = iprot.readListBegin();
                            struct.columns = new ArrayList<TColumnValue>(_list88.size);
                            for (int _i89 = 0; _i89 < _list88.size; ++_i89) {
                                TColumnValue _elem90 = new TColumnValue();
                                _elem90.read(iprot);
                                struct.columns.add(_elem90);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 13) {
                            TMap _map91 = iprot.readMapBegin();
                            struct.attributes = new HashMap<ByteBuffer, ByteBuffer>(2 * _map91.size);
                            for (int _i92 = 0; _i92 < _map91.size; ++_i92) {
                                ByteBuffer _key93 = iprot.readBinary();
                                ByteBuffer _val94 = iprot.readBinary();
                                struct.attributes.put(_key93, _val94);
                            }
                            iprot.readMapEnd();
                            struct.setAttributesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.durability = TDurability.findByValue(iprot.readI32());
                            struct.setDurabilityIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 12) {
                            struct.cellVisibility = new TCellVisibility();
                            struct.cellVisibility.read(iprot);
                            struct.setCellVisibilityIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TAppend struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.row != null) {
                oprot.writeFieldBegin(ROW_FIELD_DESC);
                oprot.writeBinary(struct.row);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (TColumnValue tColumnValue : struct.columns) {
                    tColumnValue.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.attributes != null && struct.isSetAttributes()) {
                oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.attributes.size()));
                for (Map.Entry entry : struct.attributes.entrySet()) {
                    oprot.writeBinary((ByteBuffer)entry.getKey());
                    oprot.writeBinary((ByteBuffer)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.durability != null && struct.isSetDurability()) {
                oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
                oprot.writeI32(struct.durability.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.cellVisibility != null && struct.isSetCellVisibility()) {
                oprot.writeFieldBegin(CELL_VISIBILITY_FIELD_DESC);
                struct.cellVisibility.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TAppendStandardSchemeFactory
    implements SchemeFactory {
        private TAppendStandardSchemeFactory() {
        }

        public TAppendStandardScheme getScheme() {
            return new TAppendStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROW(1, "row"),
        COLUMNS(2, "columns"),
        ATTRIBUTES(3, "attributes"),
        DURABILITY(4, "durability"),
        CELL_VISIBILITY(5, "cellVisibility");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ROW;
                }
                case 2: {
                    return COLUMNS;
                }
                case 3: {
                    return ATTRIBUTES;
                }
                case 4: {
                    return DURABILITY;
                }
                case 5: {
                    return CELL_VISIBILITY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

