/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.security.SecurityUtil;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.thrift.CallQueue;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

@InterfaceAudience.Private
public class ThriftServer {
    private static final Log log = LogFactory.getLog(ThriftServer.class);
    static final String THRIFT_QOP_KEY = "hbase.thrift.security.qop";
    public static final int DEFAULT_LISTEN_PORT = 9090;

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Thrift", null, ThriftServer.getOptions(), "To start the Thrift server run 'bin/hbase-daemon.sh start thrift2'\nTo shutdown the thrift server run 'bin/hbase-daemon.sh stop thrift2' or send a kill signal to the thrift server pid", true);
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("b", "bind", true, "Address to bind the Thrift server to. [default: 0.0.0.0]");
        options.addOption("p", "port", true, "Port to bind to [default: 9090]");
        options.addOption("f", "framed", false, "Use framed transport");
        options.addOption("c", "compact", false, "Use the compact protocol");
        options.addOption("h", "help", false, "Print help information");
        options.addOption(null, "infoport", true, "Port for web UI");
        OptionGroup servers = new OptionGroup();
        servers.addOption(new Option("nonblocking", false, "Use the TNonblockingServer. This implies the framed transport."));
        servers.addOption(new Option("hsha", false, "Use the THsHaServer. This implies the framed transport."));
        servers.addOption(new Option("threadpool", false, "Use the TThreadPoolServer. This is the default."));
        options.addOptionGroup(servers);
        return options;
    }

    private static CommandLine parseArguments(Configuration conf, Options options, String[] args) throws ParseException, IOException {
        GenericOptionsParser genParser = new GenericOptionsParser(conf, args);
        String[] remainingArgs = genParser.getRemainingArgs();
        PosixParser parser = new PosixParser();
        return parser.parse(options, remainingArgs);
    }

    private static TProtocolFactory getTProtocolFactory(boolean isCompact) {
        if (isCompact) {
            log.debug((Object)"Using compact protocol");
            return new TCompactProtocol.Factory();
        }
        log.debug((Object)"Using binary protocol");
        return new TBinaryProtocol.Factory();
    }

    private static TTransportFactory getTTransportFactory(String qop, String name, String host, boolean framed, int frameSize) {
        if (framed) {
            if (qop != null) {
                throw new RuntimeException("Thrift server authentication doesn't work with framed transport yet");
            }
            log.debug((Object)"Using framed transport");
            return new TFramedTransport.Factory(frameSize);
        }
        if (qop == null) {
            return new TTransportFactory();
        }
        HashMap<String, String> saslProperties = new HashMap<String, String>();
        saslProperties.put("javax.security.sasl.qop", qop);
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        saslFactory.addServerDefinition("GSSAPI", name, host, saslProperties, (CallbackHandler)new SaslRpcServer.SaslGssCallbackHandler(){

            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                AuthorizeCallback ac = null;
                for (Callback callback : callbacks) {
                    if (!(callback instanceof AuthorizeCallback)) {
                        throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                    }
                    ac = (AuthorizeCallback)callback;
                }
                if (ac != null) {
                    String authzid;
                    String authid = ac.getAuthenticationID();
                    if (!authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(false);
                    } else {
                        ac.setAuthorized(true);
                        String userName = SecurityUtil.getUserFromPrincipal((String)authzid);
                        log.info((Object)("Effective user: " + userName));
                        ac.setAuthorizedID(userName);
                    }
                }
            }
        });
        return saslFactory;
    }

    private static InetSocketAddress bindToPort(String bindValue, int listenPort) throws UnknownHostException {
        try {
            if (bindValue == null) {
                return new InetSocketAddress(listenPort);
            }
            return new InetSocketAddress(InetAddress.getByName(bindValue), listenPort);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Could not bind to provided ip address", e);
        }
    }

    private static TServer getTNonBlockingServer(TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) throws TTransportException {
        TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase Nonblocking Thrift server on " + inetSocketAddress.toString()));
        TNonblockingServer.Args serverArgs = new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport);
        serverArgs.processor(processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new TNonblockingServer((AbstractNonblockingServer.AbstractNonblockingServerArgs)serverArgs);
    }

    private static TServer getTHsHaServer(TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress, ThriftMetrics metrics) throws TTransportException {
        TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase HsHA Thrift server on " + inetSocketAddress.toString()));
        THsHaServer.Args serverArgs = new THsHaServer.Args((TNonblockingServerTransport)serverTransport);
        ExecutorService executorService = ThriftServer.createExecutor(serverArgs.getWorkerThreads(), metrics);
        serverArgs.executorService(executorService);
        serverArgs.processor(processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new THsHaServer(serverArgs);
    }

    private static ExecutorService createExecutor(int workerThreads, ThriftMetrics metrics) {
        CallQueue callQueue = new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(), metrics);
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(true);
        tfb.setNameFormat("thrift2-worker-%d");
        return new ThreadPoolExecutor(workerThreads, workerThreads, Long.MAX_VALUE, TimeUnit.SECONDS, (BlockingQueue<Runnable>)callQueue, tfb.build());
    }

    private static TServer getTThreadPoolServer(TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) throws TTransportException {
        TServerSocket serverTransport = new TServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase ThreadPool Thrift server on " + inetSocketAddress.toString()));
        TThreadPoolServer.Args serverArgs = new TThreadPoolServer.Args((TServerTransport)serverTransport);
        serverArgs.processor(processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new TThreadPoolServer(serverArgs);
    }

    protected static void registerFilters(Configuration conf) {
        String[] filters = conf.getStrings("hbase.thrift.filters");
        if (filters != null) {
            for (String filterClass : filters) {
                String[] filterPart = filterClass.split(":");
                if (filterPart.length != 2) {
                    log.warn((Object)("Invalid filter specification " + filterClass + " - skipping"));
                    continue;
                }
                ParseFilter.registerFilter((String)filterPart[0], (String)filterPart[1]);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        boolean securityEnabled;
        TServer server = null;
        Options options = ThriftServer.getOptions();
        Configuration conf = HBaseConfiguration.create();
        CommandLine cmd = ThriftServer.parseArguments(conf, options, args);
        List argList = cmd.getArgList();
        if (cmd.hasOption("help") || !argList.contains("start") || argList.contains("stop")) {
            ThriftServer.printUsage();
            System.exit(1);
        }
        int listenPort = 0;
        try {
            listenPort = cmd.hasOption("port") ? Integer.parseInt(cmd.getOptionValue("port")) : conf.getInt("hbase.regionserver.thrift.port", 9090);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse the value provided for the port option", e);
        }
        String host = null;
        String name = null;
        UserProvider userProvider = UserProvider.instantiate((Configuration)conf);
        boolean bl = securityEnabled = userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled();
        if (securityEnabled) {
            host = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.thrift.dns.interface", "default"), (String)conf.get("hbase.thrift.dns.nameserver", "default")));
            userProvider.login("hbase.thrift.keytab.file", "hbase.thrift.kerberos.principal", host);
        }
        UserGroupInformation realUser = userProvider.getCurrent().getUGI();
        String qop = conf.get(THRIFT_QOP_KEY);
        if (qop != null) {
            if (!(qop.equals("auth") || qop.equals("auth-int") || qop.equals("auth-conf"))) {
                throw new IOException("Invalid hbase.thrift.security.qop: " + qop + ", it must be 'auth', 'auth-int', or 'auth-conf'");
            }
            if (!securityEnabled) {
                throw new IOException("Thrift server must run in secure mode to support authentication");
            }
            name = SecurityUtil.getUserFromPrincipal((String)conf.get("hbase.thrift.kerberos.principal"));
        }
        boolean nonblocking = cmd.hasOption("nonblocking");
        boolean hsha = cmd.hasOption("hsha");
        ThriftMetrics metrics = new ThriftMetrics(conf, ThriftMetrics.ThriftServerType.TWO);
        String implType = "threadpool";
        if (nonblocking) {
            implType = "nonblocking";
        } else if (hsha) {
            implType = "hsha";
        }
        conf.set("hbase.regionserver.thrift.server.type", implType);
        conf.setInt("hbase.regionserver.thrift.port", listenPort);
        ThriftServer.registerFilters(conf);
        boolean compact2 = cmd.hasOption("compact") || conf.getBoolean("hbase.regionserver.thrift.compact", false);
        TProtocolFactory protocolFactory = ThriftServer.getTProtocolFactory(compact2);
        final ThriftHBaseServiceHandler hbaseHandler = new ThriftHBaseServiceHandler(conf, userProvider);
        THBaseService.Iface handler = ThriftHBaseServiceHandler.newInstance(hbaseHandler, metrics);
        final THBaseService.Processor<THBaseService.Iface> p = new THBaseService.Processor<THBaseService.Iface>(handler);
        conf.setBoolean("hbase.regionserver.thrift.compact", compact2);
        TProcessor processor = p;
        boolean framed = cmd.hasOption("framed") || conf.getBoolean("hbase.regionserver.thrift.framed", false) || nonblocking || hsha;
        TTransportFactory transportFactory = ThriftServer.getTTransportFactory(qop, name, host, framed, conf.getInt("hbase.regionserver.thrift.framed.max_frame_size_in_mb", 2) * 1024 * 1024);
        InetSocketAddress inetSocketAddress = ThriftServer.bindToPort(cmd.getOptionValue("bind"), listenPort);
        conf.setBoolean("hbase.regionserver.thrift.framed", framed);
        if (qop != null) {
            processor = new TProcessor(){

                public boolean process(TProtocol inProt, TProtocol outProt) throws TException {
                    TSaslServerTransport saslServerTransport = (TSaslServerTransport)inProt.getTransport();
                    SaslServer saslServer = saslServerTransport.getSaslServer();
                    String principal = saslServer.getAuthorizationID();
                    hbaseHandler.setEffectiveUser(principal);
                    return p.process(inProt, outProt);
                }
            };
        }
        try {
            if (cmd.hasOption("infoport")) {
                String val = cmd.getOptionValue("infoport");
                conf.setInt("hbase.thrift.info.port", Integer.valueOf(val).intValue());
                log.debug((Object)("Web UI port set to " + val));
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"Could not parse the value provided for the infoport option", (Throwable)e);
            ThriftServer.printUsage();
            System.exit(1);
        }
        int port = conf.getInt("hbase.thrift.info.port", 9095);
        if (port >= 0) {
            conf.setLong("startcode", System.currentTimeMillis());
            String a = conf.get("hbase.thrift.info.bindAddress", "0.0.0.0");
            InfoServer infoServer = new InfoServer("thrift", a, port, false, conf);
            infoServer.setAttribute("hbase.conf", (Object)conf);
            infoServer.start();
        }
        server = nonblocking ? ThriftServer.getTNonBlockingServer(protocolFactory, processor, transportFactory, inetSocketAddress) : (hsha ? ThriftServer.getTHsHaServer(protocolFactory, processor, transportFactory, inetSocketAddress, metrics) : ThriftServer.getTThreadPoolServer(protocolFactory, processor, transportFactory, inetSocketAddress));
        final TServer tserver = server;
        realUser.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                tserver.serve();
                return null;
            }
        });
    }
}

