/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSource;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSourceFactory;

@InterfaceAudience.Private
public class ThriftMetrics {
    private MetricsThriftServerSource source;
    private final long slowResponseTime;
    public static final String SLOW_RESPONSE_NANO_SEC = "hbase.thrift.slow.response.nano.second";
    public static final long DEFAULT_SLOW_RESPONSE_NANO_SEC = 10000000L;

    public MetricsThriftServerSource getSource() {
        return this.source;
    }

    public void setSource(MetricsThriftServerSource source) {
        this.source = source;
    }

    public ThriftMetrics(Configuration conf, ThriftServerType t) {
        this.slowResponseTime = conf.getLong(SLOW_RESPONSE_NANO_SEC, 10000000L);
        if (t == ThriftServerType.ONE) {
            this.source = ((MetricsThriftServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsThriftServerSourceFactory.class)).createThriftOneSource();
        } else if (t == ThriftServerType.TWO) {
            this.source = ((MetricsThriftServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsThriftServerSourceFactory.class)).createThriftTwoSource();
        }
    }

    public void incTimeInQueue(long time) {
        this.source.incTimeInQueue(time);
    }

    public void setCallQueueLen(int len) {
        this.source.setCallQueueLen(len);
    }

    public void incNumRowKeysInBatchGet(int diff) {
        this.source.incNumRowKeysInBatchGet(diff);
    }

    public void incNumRowKeysInBatchMutate(int diff) {
        this.source.incNumRowKeysInBatchMutate(diff);
    }

    public void incMethodTime(String name, long time) {
        this.source.incMethodTime(name, time);
        this.source.incCall(time);
        if (time > this.slowResponseTime) {
            this.source.incSlowCall(time);
        }
    }

    public static enum ThriftServerType {
        ONE,
        TWO;

    }
}

