/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTableFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftUtilities;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;
import org.apache.hadoop.hbase.thrift2.generated.TIllegalArgument;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConnectionCache;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;

@InterfaceAudience.Private
public class ThriftHBaseServiceHandler
implements THBaseService.Iface {
    private final Cache<String, HTablePool> htablePools;
    private final Callable<? extends HTablePool> htablePoolCreater;
    private static final Log LOG = LogFactory.getLog(ThriftHBaseServiceHandler.class);
    private final AtomicInteger nextScannerId = new AtomicInteger(0);
    private final Map<Integer, ResultScanner> scannerMap = new ConcurrentHashMap<Integer, ResultScanner>();
    private final ConnectionCache connectionCache;
    private final HTableFactory tableFactory;
    private final int maxPoolSize;
    static final String CLEANUP_INTERVAL = "hbase.thrift.connection.cleanup-interval";
    static final String MAX_IDLETIME = "hbase.thrift.connection.max-idletime";

    public static THBaseService.Iface newInstance(THBaseService.Iface handler, ThriftMetrics metrics) {
        return (THBaseService.Iface)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{THBaseService.Iface.class}, (InvocationHandler)new THBaseServiceMetricsProxy(handler, metrics));
    }

    private static long now() {
        return System.nanoTime();
    }

    ThriftHBaseServiceHandler(final Configuration conf, UserProvider userProvider) throws IOException {
        int cleanInterval = conf.getInt(CLEANUP_INTERVAL, 10000);
        int maxIdleTime = conf.getInt(MAX_IDLETIME, 600000);
        this.connectionCache = new ConnectionCache(conf, userProvider, cleanInterval, maxIdleTime);
        this.tableFactory = new HTableFactory(){

            public HTableInterface createHTableInterface(Configuration config, byte[] tableName) {
                try {
                    return ThriftHBaseServiceHandler.this.connectionCache.getTable(Bytes.toString((byte[])tableName));
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
        this.htablePools = CacheBuilder.newBuilder().expireAfterAccess((long)maxIdleTime, TimeUnit.MILLISECONDS).softValues().concurrencyLevel(4).build();
        this.maxPoolSize = conf.getInt("hbase.thrift.htablepool.size.max", 1000);
        this.htablePoolCreater = new Callable<HTablePool>(){

            @Override
            public HTablePool call() {
                return new HTablePool(conf, ThriftHBaseServiceHandler.this.maxPoolSize, (HTableInterfaceFactory)ThriftHBaseServiceHandler.this.tableFactory);
            }
        };
    }

    private Table getTable(ByteBuffer tableName) {
        String currentUser = this.connectionCache.getEffectiveUser();
        try {
            HTablePool htablePool = (HTablePool)this.htablePools.get((Object)currentUser, this.htablePoolCreater);
            return htablePool.getTable(TBaseHelper.byteBufferToByteArray((ByteBuffer)tableName));
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    private void closeTable(Table table) throws TIOError {
        try {
            table.close();
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    private TIOError getTIOError(IOException e) {
        TIOError err = new TIOError();
        err.setMessage(e.getMessage());
        return err;
    }

    private int addScanner(ResultScanner scanner) {
        int id = this.nextScannerId.getAndIncrement();
        this.scannerMap.put(id, scanner);
        return id;
    }

    private ResultScanner getScanner(int id) {
        return this.scannerMap.get(id);
    }

    void setEffectiveUser(String effectiveUser) {
        this.connectionCache.setEffectiveUser(effectiveUser);
    }

    protected ResultScanner removeScanner(int id) {
        return this.scannerMap.remove(id);
    }

    @Override
    public boolean exists(ByteBuffer table, TGet get2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            boolean bl = htable.exists(ThriftUtilities.getFromThrift(get2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult get(ByteBuffer table, TGet get2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.get(ThriftUtilities.getFromThrift(get2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<TResult> getMultiple(ByteBuffer table, List<TGet> gets) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            List<TResult> list = ThriftUtilities.resultsFromHBase(htable.get(ThriftUtilities.getsFromThrift(gets)));
            return list;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void put(ByteBuffer table, TPut put2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            htable.put(ThriftUtilities.putFromThrift(put2));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public boolean checkAndPut(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, ByteBuffer value, TPut put2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            boolean bl = htable.checkAndPut(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family), TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier), value == null ? null : TBaseHelper.byteBufferToByteArray((ByteBuffer)value), ThriftUtilities.putFromThrift(put2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void putMultiple(ByteBuffer table, List<TPut> puts) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            htable.put(ThriftUtilities.putsFromThrift(puts));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void deleteSingle(ByteBuffer table, TDelete deleteSingle2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            htable.delete(ThriftUtilities.deleteFromThrift(deleteSingle2));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<TDelete> deleteMultiple(ByteBuffer table, List<TDelete> deletes) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            htable.delete(ThriftUtilities.deletesFromThrift(deletes));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean checkAndDelete(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, ByteBuffer value, TDelete deleteSingle2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            if (value == null) {
                boolean bl = htable.checkAndDelete(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family), TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier), null, ThriftUtilities.deleteFromThrift(deleteSingle2));
                return bl;
            }
            boolean bl = htable.checkAndDelete(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family), TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier), TBaseHelper.byteBufferToByteArray((ByteBuffer)value), ThriftUtilities.deleteFromThrift(deleteSingle2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult increment(ByteBuffer table, TIncrement increment2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.increment(ThriftUtilities.incrementFromThrift(increment2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult append(ByteBuffer table, TAppend append2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.append(ThriftUtilities.appendFromThrift(append2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public int openScanner(ByteBuffer table, TScan scan) throws TIOError, TException {
        Table htable = this.getTable(table);
        ResultScanner resultScanner = null;
        try {
            resultScanner = htable.getScanner(ThriftUtilities.scanFromThrift(scan));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
        return this.addScanner(resultScanner);
    }

    @Override
    public List<TResult> getScannerRows(int scannerId, int numRows) throws TIOError, TIllegalArgument, TException {
        ResultScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            TIllegalArgument ex = new TIllegalArgument();
            ex.setMessage("Invalid scanner Id");
            throw ex;
        }
        try {
            return ThriftUtilities.resultsFromHBase(scanner.next(numRows));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<TResult> getScannerResults(ByteBuffer table, TScan scan, int numRows) throws TIOError, TException {
        Table htable = this.getTable(table);
        List<TResult> results = null;
        ResultScanner scanner = null;
        try {
            scanner = htable.getScanner(ThriftUtilities.scanFromThrift(scan));
            results = ThriftUtilities.resultsFromHBase(scanner.next(numRows));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            this.closeTable(htable);
        }
        return results;
    }

    @Override
    public void closeScanner(int scannerId) throws TIOError, TIllegalArgument, TException {
        LOG.debug((Object)("scannerClose: id=" + scannerId));
        ResultScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            String message = "scanner ID is invalid";
            LOG.warn((Object)message);
            TIllegalArgument ex = new TIllegalArgument();
            ex.setMessage("Invalid scanner Id");
            throw ex;
        }
        scanner.close();
        this.removeScanner(scannerId);
    }

    @Override
    public void mutateRow(ByteBuffer table, TRowMutations rowMutations) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            htable.mutateRow(ThriftUtilities.rowMutationsFromThrift(rowMutations));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    private static class THBaseServiceMetricsProxy
    implements InvocationHandler {
        private final THBaseService.Iface handler;
        private final ThriftMetrics metrics;

        private THBaseServiceMetricsProxy(THBaseService.Iface handler, ThriftMetrics metrics) {
            this.handler = handler;
            this.metrics = metrics;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result;
            try {
                long start = ThriftHBaseServiceHandler.now();
                result = m.invoke((Object)this.handler, args);
                int processTime = (int)(ThriftHBaseServiceHandler.now() - start);
                this.metrics.incMethodTime(m.getName(), processTime);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
            }
            return result;
        }
    }
}

