/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.thrift.IncrementCoalescerMBean;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.generated.TIncrement;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.thrift.TException;

public class IncrementCoalescer
implements IncrementCoalescerMBean {
    private final AtomicLong failedIncrements = new AtomicLong();
    private final AtomicLong successfulCoalescings = new AtomicLong();
    private final AtomicLong totalIncrements = new AtomicLong();
    private final ConcurrentMap<FullyQualifiedRow, Long> countersMap = new ConcurrentHashMap<FullyQualifiedRow, Long>(100000, 0.75f, 1500);
    private final ThreadPoolExecutor pool;
    private final ThriftServerRunner.HBaseHandler handler;
    private int maxQueueSize = 500000;
    private static final int CORE_POOL_SIZE = 1;
    protected final Log LOG = LogFactory.getLog((String)this.getClass().getName());

    public IncrementCoalescer(ThriftServerRunner.HBaseHandler hand) {
        this.handler = hand;
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.pool = new ThreadPoolExecutor(1, 1, 50L, TimeUnit.MILLISECONDS, queue, Threads.newDaemonThreadFactory((String)"IncrementCoalescer"));
        MBeanUtil.registerMBean((String)"thrift", (String)"Thrift", (Object)this);
    }

    public boolean queueIncrement(TIncrement inc) throws TException {
        if (!this.canQueue()) {
            this.failedIncrements.incrementAndGet();
            return false;
        }
        return this.internalQueueTincrement(inc);
    }

    public boolean queueIncrements(List<TIncrement> incs) throws TException {
        if (!this.canQueue()) {
            this.failedIncrements.incrementAndGet();
            return false;
        }
        for (TIncrement tinc : incs) {
            this.internalQueueTincrement(tinc);
        }
        return true;
    }

    private boolean internalQueueTincrement(TIncrement inc) throws TException {
        byte[][] famAndQf = KeyValue.parseColumn((byte[])inc.getColumn());
        if (famAndQf.length != 2) {
            return false;
        }
        return this.internalQueueIncrement(inc.getTable(), inc.getRow(), famAndQf[0], famAndQf[1], inc.getAmmount());
    }

    private boolean internalQueueIncrement(byte[] tableName, byte[] rowKey, byte[] fam, byte[] qual, long ammount) throws TException {
        int countersMapSize = this.countersMap.size();
        this.dynamicallySetCoreSize(countersMapSize);
        this.totalIncrements.incrementAndGet();
        FullyQualifiedRow key = new FullyQualifiedRow(tableName, rowKey, fam, qual);
        long currentAmount = ammount;
        while (true) {
            Long value;
            if ((value = (Long)this.countersMap.remove(key)) == null) {
                value = currentAmount;
            } else {
                value = value + currentAmount;
                this.successfulCoalescings.incrementAndGet();
            }
            Long oldValue = this.countersMap.putIfAbsent(key, value);
            if (oldValue == null) break;
            currentAmount = value;
        }
        if (this.pool.getQueue().size() <= 1000) {
            Callable<Integer> callable = this.createIncCallable();
            this.pool.submit(callable);
        }
        return true;
    }

    public boolean canQueue() {
        return this.countersMap.size() < this.maxQueueSize;
    }

    private Callable<Integer> createIncCallable() {
        return new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int failures = 0;
                Set keys = IncrementCoalescer.this.countersMap.keySet();
                for (FullyQualifiedRow row : keys) {
                    Long counter = (Long)IncrementCoalescer.this.countersMap.remove(row);
                    if (counter == null) continue;
                    try {
                        Table table = IncrementCoalescer.this.handler.getTable(row.getTable());
                        if (failures > 2) {
                            throw new IOException("Auto-Fail rest of ICVs");
                        }
                        table.incrementColumnValue(row.getRowKey(), row.getFamily(), row.getQualifier(), counter.longValue());
                    }
                    catch (IOException e) {
                        ++failures;
                        IncrementCoalescer.this.LOG.error((Object)("FAILED_ICV: " + Bytes.toString((byte[])row.getTable()) + ", " + Bytes.toStringBinary((byte[])row.getRowKey()) + ", " + Bytes.toStringBinary((byte[])row.getFamily()) + ", " + Bytes.toStringBinary((byte[])row.getQualifier()) + ", " + counter), (Throwable)e);
                    }
                }
                return failures;
            }
        };
    }

    private void dynamicallySetCoreSize(int countersMapSize) {
        if (countersMapSize % 10 != 0) {
            return;
        }
        double currentRatio = (double)countersMapSize / (double)this.maxQueueSize;
        int newValue = 1;
        if (!(currentRatio < 0.1)) {
            newValue = currentRatio < 0.3 ? 2 : (currentRatio < 0.5 ? 4 : (currentRatio < 0.7 ? 8 : (currentRatio < 0.9 ? 14 : 22)));
        }
        if (this.pool.getCorePoolSize() != newValue) {
            this.pool.setCorePoolSize(newValue);
        }
    }

    @Override
    public int getQueueSize() {
        return this.pool.getQueue().size();
    }

    @Override
    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @Override
    public void setMaxQueueSize(int newSize) {
        this.maxQueueSize = newSize;
    }

    @Override
    public long getPoolCompletedTaskCount() {
        return this.pool.getCompletedTaskCount();
    }

    @Override
    public long getPoolTaskCount() {
        return this.pool.getTaskCount();
    }

    @Override
    public int getPoolLargestPoolSize() {
        return this.pool.getLargestPoolSize();
    }

    @Override
    public int getCorePoolSize() {
        return this.pool.getCorePoolSize();
    }

    @Override
    public void setCorePoolSize(int newCoreSize) {
        this.pool.setCorePoolSize(newCoreSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.pool.getMaximumPoolSize();
    }

    @Override
    public void setMaxPoolSize(int newMaxSize) {
        this.pool.setMaximumPoolSize(newMaxSize);
    }

    @Override
    public long getFailedIncrements() {
        return this.failedIncrements.get();
    }

    @Override
    public long getSuccessfulCoalescings() {
        return this.successfulCoalescings.get();
    }

    @Override
    public long getTotalIncrements() {
        return this.totalIncrements.get();
    }

    @Override
    public long getCountersMapSize() {
        return this.countersMap.size();
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DaemonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "ICV-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static class FullyQualifiedRow {
        private byte[] table;
        private byte[] rowKey;
        private byte[] family;
        private byte[] qualifier;

        public FullyQualifiedRow(byte[] table, byte[] rowKey, byte[] fam, byte[] qual) {
            this.table = table;
            this.rowKey = rowKey;
            this.family = fam;
            this.qualifier = qual;
        }

        public byte[] getTable() {
            return this.table;
        }

        public void setTable(byte[] table) {
            this.table = table;
        }

        public byte[] getRowKey() {
            return this.rowKey;
        }

        public void setRowKey(byte[] rowKey) {
            this.rowKey = rowKey;
        }

        public byte[] getFamily() {
            return this.family;
        }

        public void setFamily(byte[] fam) {
            this.family = fam;
        }

        public byte[] getQualifier() {
            return this.qualifier;
        }

        public void setQualifier(byte[] qual) {
            this.qualifier = qual;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.family);
            result = 31 * result + Arrays.hashCode(this.qualifier);
            result = 31 * result + Arrays.hashCode(this.rowKey);
            result = 31 * result + Arrays.hashCode(this.table);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FullyQualifiedRow other = (FullyQualifiedRow)obj;
            if (!Arrays.equals(this.family, other.family)) {
                return false;
            }
            if (!Arrays.equals(this.qualifier, other.qualifier)) {
                return false;
            }
            if (!Arrays.equals(this.rowKey, other.rowKey)) {
                return false;
            }
            return Arrays.equals(this.table, other.table);
        }
    }
}

