/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TColumn;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TRowResult
implements TBase<TRowResult, _Fields>,
Serializable,
Cloneable,
Comparable<TRowResult> {
    private static final TStruct STRUCT_DESC = new TStruct("TRowResult");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 13, 2);
    private static final TField SORTED_COLUMNS_FIELD_DESC = new TField("sortedColumns", 15, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer row;
    public Map<ByteBuffer, TCell> columns;
    public List<TColumn> sortedColumns;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TRowResult() {
    }

    public TRowResult(ByteBuffer row) {
        this();
        this.row = TBaseHelper.copyBinary((ByteBuffer)row);
    }

    public TRowResult(TRowResult other) {
        if (other.isSetRow()) {
            this.row = other.row;
        }
        if (other.isSetColumns()) {
            HashMap<ByteBuffer, TCell> __this__columns = new HashMap<ByteBuffer, TCell>(other.columns.size());
            for (Map.Entry entry : other.columns.entrySet()) {
                ByteBuffer other_element_key = (ByteBuffer)entry.getKey();
                TCell other_element_value = (TCell)entry.getValue();
                ByteBuffer __this__columns_copy_key = other_element_key;
                TCell __this__columns_copy_value = new TCell(other_element_value);
                __this__columns.put(__this__columns_copy_key, __this__columns_copy_value);
            }
            this.columns = __this__columns;
        }
        if (other.isSetSortedColumns()) {
            ArrayList<TColumn> __this__sortedColumns = new ArrayList<TColumn>(other.sortedColumns.size());
            for (TColumn tColumn : other.sortedColumns) {
                __this__sortedColumns.add(new TColumn(tColumn));
            }
            this.sortedColumns = __this__sortedColumns;
        }
    }

    public TRowResult deepCopy() {
        return new TRowResult(this);
    }

    public void clear() {
        this.row = null;
        this.columns = null;
        this.sortedColumns = null;
    }

    public byte[] getRow() {
        this.setRow(TBaseHelper.rightSize((ByteBuffer)this.row));
        return this.row == null ? null : this.row.array();
    }

    public ByteBuffer bufferForRow() {
        return TBaseHelper.copyBinary((ByteBuffer)this.row);
    }

    public TRowResult setRow(byte[] row) {
        this.row = row == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(row, row.length));
        return this;
    }

    public TRowResult setRow(ByteBuffer row) {
        this.row = TBaseHelper.copyBinary((ByteBuffer)row);
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public void putToColumns(ByteBuffer key, TCell val) {
        if (this.columns == null) {
            this.columns = new HashMap<ByteBuffer, TCell>();
        }
        this.columns.put(key, val);
    }

    public Map<ByteBuffer, TCell> getColumns() {
        return this.columns;
    }

    public TRowResult setColumns(Map<ByteBuffer, TCell> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getSortedColumnsSize() {
        return this.sortedColumns == null ? 0 : this.sortedColumns.size();
    }

    public Iterator<TColumn> getSortedColumnsIterator() {
        return this.sortedColumns == null ? null : this.sortedColumns.iterator();
    }

    public void addToSortedColumns(TColumn elem) {
        if (this.sortedColumns == null) {
            this.sortedColumns = new ArrayList<TColumn>();
        }
        this.sortedColumns.add(elem);
    }

    public List<TColumn> getSortedColumns() {
        return this.sortedColumns;
    }

    public TRowResult setSortedColumns(List<TColumn> sortedColumns) {
        this.sortedColumns = sortedColumns;
        return this;
    }

    public void unsetSortedColumns() {
        this.sortedColumns = null;
    }

    public boolean isSetSortedColumns() {
        return this.sortedColumns != null;
    }

    public void setSortedColumnsIsSet(boolean value) {
        if (!value) {
            this.sortedColumns = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((ByteBuffer)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((Map)value);
                break;
            }
            case SORTED_COLUMNS: {
                if (value == null) {
                    this.unsetSortedColumns();
                    break;
                }
                this.setSortedColumns((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROW: {
                return this.getRow();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case SORTED_COLUMNS: {
                return this.getSortedColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ROW: {
                return this.isSetRow();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case SORTED_COLUMNS: {
                return this.isSetSortedColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TRowResult) {
            return this.equals((TRowResult)that);
        }
        return false;
    }

    public boolean equals(TRowResult that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!this.row.equals(that.row)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_sortedColumns = this.isSetSortedColumns();
        boolean that_present_sortedColumns = that.isSetSortedColumns();
        if (this_present_sortedColumns || that_present_sortedColumns) {
            if (!this_present_sortedColumns || !that_present_sortedColumns) {
                return false;
            }
            if (!this.sortedColumns.equals(that.sortedColumns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_row = this.isSetRow();
        list.add(present_row);
        if (present_row) {
            list.add(this.row);
        }
        boolean present_columns = this.isSetColumns();
        list.add(present_columns);
        if (present_columns) {
            list.add(this.columns);
        }
        boolean present_sortedColumns = this.isSetSortedColumns();
        list.add(present_sortedColumns);
        if (present_sortedColumns) {
            list.add(this.sortedColumns);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TRowResult other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRow()).compareTo(other.isSetRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.row, (Comparable)other.row)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSortedColumns()).compareTo(other.isSetSortedColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSortedColumns() && (lastComparison = TBaseHelper.compareTo(this.sortedColumns, other.sortedColumns)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TRowResult(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.row, (StringBuilder)sb);
        }
        first = false;
        if (this.isSetColumns()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columns:");
            if (this.columns == null) {
                sb.append("null");
            } else {
                sb.append(this.columns);
            }
            first = false;
        }
        if (this.isSetSortedColumns()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sortedColumns:");
            if (this.sortedColumns == null) {
                sb.append("null");
            } else {
                sb.append(this.sortedColumns);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TRowResultStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TRowResultTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.COLUMNS, _Fields.SORTED_COLUMNS};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ROW, new FieldMetaData("row", 3, new FieldValueMetaData(11, "Text")));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11, "Text"), (FieldValueMetaData)new StructMetaData(12, TCell.class))));
        tmpMap.put(_Fields.SORTED_COLUMNS, new FieldMetaData("sortedColumns", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TColumn.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TRowResult.class, metaDataMap);
    }

    private static class TRowResultTupleScheme
    extends TupleScheme<TRowResult> {
        private TRowResultTupleScheme() {
        }

        public void write(TProtocol prot, TRowResult struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetRow()) {
                optionals.set(0);
            }
            if (struct.isSetColumns()) {
                optionals.set(1);
            }
            if (struct.isSetSortedColumns()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetRow()) {
                oprot.writeBinary(struct.row);
            }
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns.size());
                for (Map.Entry entry : struct.columns.entrySet()) {
                    oprot.writeBinary((ByteBuffer)entry.getKey());
                    ((TCell)entry.getValue()).write((TProtocol)oprot);
                }
            }
            if (struct.isSetSortedColumns()) {
                oprot.writeI32(struct.sortedColumns.size());
                for (TColumn tColumn : struct.sortedColumns) {
                    tColumn.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, TRowResult struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
            }
            if (incoming.get(1)) {
                TMap _map19 = new TMap(11, 12, iprot.readI32());
                struct.columns = new HashMap<ByteBuffer, TCell>(2 * _map19.size);
                for (int _i22 = 0; _i22 < _map19.size; ++_i22) {
                    ByteBuffer _key20 = iprot.readBinary();
                    TCell _val21 = new TCell();
                    _val21.read((TProtocol)iprot);
                    struct.columns.put(_key20, _val21);
                }
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list23 = new TList(12, iprot.readI32());
                struct.sortedColumns = new ArrayList<TColumn>(_list23.size);
                for (int _i25 = 0; _i25 < _list23.size; ++_i25) {
                    TColumn _elem24 = new TColumn();
                    _elem24.read((TProtocol)iprot);
                    struct.sortedColumns.add(_elem24);
                }
                struct.setSortedColumnsIsSet(true);
            }
        }
    }

    private static class TRowResultTupleSchemeFactory
    implements SchemeFactory {
        private TRowResultTupleSchemeFactory() {
        }

        public TRowResultTupleScheme getScheme() {
            return new TRowResultTupleScheme();
        }
    }

    private static class TRowResultStandardScheme
    extends StandardScheme<TRowResult> {
        private TRowResultStandardScheme() {
        }

        public void read(TProtocol iprot, TRowResult struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.row = iprot.readBinary();
                            struct.setRowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 13) {
                            TMap _map8 = iprot.readMapBegin();
                            struct.columns = new HashMap<ByteBuffer, TCell>(2 * _map8.size);
                            for (int _i11 = 0; _i11 < _map8.size; ++_i11) {
                                ByteBuffer _key9 = iprot.readBinary();
                                TCell _val10 = new TCell();
                                _val10.read(iprot);
                                struct.columns.put(_key9, _val10);
                            }
                            iprot.readMapEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list12 = iprot.readListBegin();
                            struct.sortedColumns = new ArrayList<TColumn>(_list12.size);
                            for (int _i14 = 0; _i14 < _list12.size; ++_i14) {
                                TColumn _elem13 = new TColumn();
                                _elem13.read(iprot);
                                struct.sortedColumns.add(_elem13);
                            }
                            iprot.readListEnd();
                            struct.setSortedColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TRowResult struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.row != null) {
                oprot.writeFieldBegin(ROW_FIELD_DESC);
                oprot.writeBinary(struct.row);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null && struct.isSetColumns()) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 12, struct.columns.size()));
                for (Map.Entry entry : struct.columns.entrySet()) {
                    oprot.writeBinary((ByteBuffer)entry.getKey());
                    ((TCell)entry.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.sortedColumns != null && struct.isSetSortedColumns()) {
                oprot.writeFieldBegin(SORTED_COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.sortedColumns.size()));
                for (TColumn tColumn : struct.sortedColumns) {
                    tColumn.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TRowResultStandardSchemeFactory
    implements SchemeFactory {
        private TRowResultStandardSchemeFactory() {
        }

        public TRowResultStandardScheme getScheme() {
            return new TRowResultStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROW(1, "row"),
        COLUMNS(2, "columns"),
        SORTED_COLUMNS(3, "sortedColumns");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ROW;
                }
                case 2: {
                    return COLUMNS;
                }
                case 3: {
                    return SORTED_COLUMNS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

