/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class THRegionInfo
implements TBase<THRegionInfo, _Fields>,
Serializable,
Cloneable,
Comparable<THRegionInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("THRegionInfo");
    private static final TField REGION_ID_FIELD_DESC = new TField("regionId", 10, 1);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 2);
    private static final TField START_KEY_FIELD_DESC = new TField("startKey", 11, 3);
    private static final TField END_KEY_FIELD_DESC = new TField("endKey", 11, 4);
    private static final TField OFFLINE_FIELD_DESC = new TField("offline", 2, 5);
    private static final TField SPLIT_FIELD_DESC = new TField("split", 2, 6);
    private static final TField REPLICA_ID_FIELD_DESC = new TField("replicaId", 8, 7);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public long regionId;
    public ByteBuffer tableName;
    public ByteBuffer startKey;
    public ByteBuffer endKey;
    public boolean offline;
    public boolean split;
    public int replicaId;
    private static final int __REGIONID_ISSET_ID = 0;
    private static final int __OFFLINE_ISSET_ID = 1;
    private static final int __SPLIT_ISSET_ID = 2;
    private static final int __REPLICAID_ISSET_ID = 3;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public THRegionInfo() {
    }

    public THRegionInfo(long regionId, ByteBuffer tableName) {
        this();
        this.regionId = regionId;
        this.setRegionIdIsSet(true);
        this.tableName = TBaseHelper.copyBinary((ByteBuffer)tableName);
    }

    public THRegionInfo(THRegionInfo other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.regionId = other.regionId;
        if (other.isSetTableName()) {
            this.tableName = TBaseHelper.copyBinary((ByteBuffer)other.tableName);
        }
        if (other.isSetStartKey()) {
            this.startKey = TBaseHelper.copyBinary((ByteBuffer)other.startKey);
        }
        if (other.isSetEndKey()) {
            this.endKey = TBaseHelper.copyBinary((ByteBuffer)other.endKey);
        }
        this.offline = other.offline;
        this.split = other.split;
        this.replicaId = other.replicaId;
    }

    public THRegionInfo deepCopy() {
        return new THRegionInfo(this);
    }

    public void clear() {
        this.setRegionIdIsSet(false);
        this.regionId = 0L;
        this.tableName = null;
        this.startKey = null;
        this.endKey = null;
        this.setOfflineIsSet(false);
        this.offline = false;
        this.setSplitIsSet(false);
        this.split = false;
        this.setReplicaIdIsSet(false);
        this.replicaId = 0;
    }

    public long getRegionId() {
        return this.regionId;
    }

    public THRegionInfo setRegionId(long regionId) {
        this.regionId = regionId;
        this.setRegionIdIsSet(true);
        return this;
    }

    public void unsetRegionId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetRegionId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setRegionIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public byte[] getTableName() {
        this.setTableName(TBaseHelper.rightSize((ByteBuffer)this.tableName));
        return this.tableName == null ? null : this.tableName.array();
    }

    public ByteBuffer bufferForTableName() {
        return TBaseHelper.copyBinary((ByteBuffer)this.tableName);
    }

    public THRegionInfo setTableName(byte[] tableName) {
        this.tableName = tableName == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(tableName, tableName.length));
        return this;
    }

    public THRegionInfo setTableName(ByteBuffer tableName) {
        this.tableName = TBaseHelper.copyBinary((ByteBuffer)tableName);
        return this;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public byte[] getStartKey() {
        this.setStartKey(TBaseHelper.rightSize((ByteBuffer)this.startKey));
        return this.startKey == null ? null : this.startKey.array();
    }

    public ByteBuffer bufferForStartKey() {
        return TBaseHelper.copyBinary((ByteBuffer)this.startKey);
    }

    public THRegionInfo setStartKey(byte[] startKey) {
        this.startKey = startKey == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(startKey, startKey.length));
        return this;
    }

    public THRegionInfo setStartKey(ByteBuffer startKey) {
        this.startKey = TBaseHelper.copyBinary((ByteBuffer)startKey);
        return this;
    }

    public void unsetStartKey() {
        this.startKey = null;
    }

    public boolean isSetStartKey() {
        return this.startKey != null;
    }

    public void setStartKeyIsSet(boolean value) {
        if (!value) {
            this.startKey = null;
        }
    }

    public byte[] getEndKey() {
        this.setEndKey(TBaseHelper.rightSize((ByteBuffer)this.endKey));
        return this.endKey == null ? null : this.endKey.array();
    }

    public ByteBuffer bufferForEndKey() {
        return TBaseHelper.copyBinary((ByteBuffer)this.endKey);
    }

    public THRegionInfo setEndKey(byte[] endKey) {
        this.endKey = endKey == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(endKey, endKey.length));
        return this;
    }

    public THRegionInfo setEndKey(ByteBuffer endKey) {
        this.endKey = TBaseHelper.copyBinary((ByteBuffer)endKey);
        return this;
    }

    public void unsetEndKey() {
        this.endKey = null;
    }

    public boolean isSetEndKey() {
        return this.endKey != null;
    }

    public void setEndKeyIsSet(boolean value) {
        if (!value) {
            this.endKey = null;
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public THRegionInfo setOffline(boolean offline) {
        this.offline = offline;
        this.setOfflineIsSet(true);
        return this;
    }

    public void unsetOffline() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetOffline() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setOfflineIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public boolean isSplit() {
        return this.split;
    }

    public THRegionInfo setSplit(boolean split) {
        this.split = split;
        this.setSplitIsSet(true);
        return this;
    }

    public void unsetSplit() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetSplit() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setSplitIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public THRegionInfo setReplicaId(int replicaId) {
        this.replicaId = replicaId;
        this.setReplicaIdIsSet(true);
        return this;
    }

    public void unsetReplicaId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetReplicaId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setReplicaIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case REGION_ID: {
                if (value == null) {
                    this.unsetRegionId();
                    break;
                }
                this.setRegionId((Long)value);
                break;
            }
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((ByteBuffer)value);
                break;
            }
            case START_KEY: {
                if (value == null) {
                    this.unsetStartKey();
                    break;
                }
                this.setStartKey((ByteBuffer)value);
                break;
            }
            case END_KEY: {
                if (value == null) {
                    this.unsetEndKey();
                    break;
                }
                this.setEndKey((ByteBuffer)value);
                break;
            }
            case OFFLINE: {
                if (value == null) {
                    this.unsetOffline();
                    break;
                }
                this.setOffline((Boolean)value);
                break;
            }
            case SPLIT: {
                if (value == null) {
                    this.unsetSplit();
                    break;
                }
                this.setSplit((Boolean)value);
                break;
            }
            case REPLICA_ID: {
                if (value == null) {
                    this.unsetReplicaId();
                    break;
                }
                this.setReplicaId((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case REGION_ID: {
                return this.getRegionId();
            }
            case TABLE_NAME: {
                return this.getTableName();
            }
            case START_KEY: {
                return this.getStartKey();
            }
            case END_KEY: {
                return this.getEndKey();
            }
            case OFFLINE: {
                return this.isOffline();
            }
            case SPLIT: {
                return this.isSplit();
            }
            case REPLICA_ID: {
                return this.getReplicaId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case REGION_ID: {
                return this.isSetRegionId();
            }
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case START_KEY: {
                return this.isSetStartKey();
            }
            case END_KEY: {
                return this.isSetEndKey();
            }
            case OFFLINE: {
                return this.isSetOffline();
            }
            case SPLIT: {
                return this.isSetSplit();
            }
            case REPLICA_ID: {
                return this.isSetReplicaId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof THRegionInfo) {
            return this.equals((THRegionInfo)that);
        }
        return false;
    }

    public boolean equals(THRegionInfo that) {
        if (that == null) {
            return false;
        }
        boolean this_present_regionId = true;
        boolean that_present_regionId = true;
        if (this_present_regionId || that_present_regionId) {
            if (!this_present_regionId || !that_present_regionId) {
                return false;
            }
            if (this.regionId != that.regionId) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_startKey = this.isSetStartKey();
        boolean that_present_startKey = that.isSetStartKey();
        if (this_present_startKey || that_present_startKey) {
            if (!this_present_startKey || !that_present_startKey) {
                return false;
            }
            if (!this.startKey.equals(that.startKey)) {
                return false;
            }
        }
        boolean this_present_endKey = this.isSetEndKey();
        boolean that_present_endKey = that.isSetEndKey();
        if (this_present_endKey || that_present_endKey) {
            if (!this_present_endKey || !that_present_endKey) {
                return false;
            }
            if (!this.endKey.equals(that.endKey)) {
                return false;
            }
        }
        boolean this_present_offline = this.isSetOffline();
        boolean that_present_offline = that.isSetOffline();
        if (this_present_offline || that_present_offline) {
            if (!this_present_offline || !that_present_offline) {
                return false;
            }
            if (this.offline != that.offline) {
                return false;
            }
        }
        boolean this_present_split = this.isSetSplit();
        boolean that_present_split = that.isSetSplit();
        if (this_present_split || that_present_split) {
            if (!this_present_split || !that_present_split) {
                return false;
            }
            if (this.split != that.split) {
                return false;
            }
        }
        boolean this_present_replicaId = this.isSetReplicaId();
        boolean that_present_replicaId = that.isSetReplicaId();
        if (this_present_replicaId || that_present_replicaId) {
            if (!this_present_replicaId || !that_present_replicaId) {
                return false;
            }
            if (this.replicaId != that.replicaId) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_regionId = true;
        list.add(Boolean.valueOf(present_regionId));
        if (present_regionId) {
            list.add(Long.valueOf(this.regionId));
        }
        boolean present_tableName = this.isSetTableName();
        list.add(Boolean.valueOf(present_tableName));
        if (present_tableName) {
            list.add(this.tableName);
        }
        boolean present_startKey = this.isSetStartKey();
        list.add(Boolean.valueOf(present_startKey));
        if (present_startKey) {
            list.add(this.startKey);
        }
        boolean present_endKey = this.isSetEndKey();
        list.add(Boolean.valueOf(present_endKey));
        if (present_endKey) {
            list.add(this.endKey);
        }
        boolean present_offline = this.isSetOffline();
        list.add(Boolean.valueOf(present_offline));
        if (present_offline) {
            list.add(Boolean.valueOf(this.offline));
        }
        boolean present_split = this.isSetSplit();
        list.add(Boolean.valueOf(present_split));
        if (present_split) {
            list.add(Boolean.valueOf(this.split));
        }
        boolean present_replicaId = this.isSetReplicaId();
        list.add(Boolean.valueOf(present_replicaId));
        if (present_replicaId) {
            list.add(Integer.valueOf(this.replicaId));
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(THRegionInfo other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRegionId()).compareTo(other.isSetRegionId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRegionId() && (lastComparison = TBaseHelper.compareTo((long)this.regionId, (long)other.regionId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(other.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tableName, (Comparable)other.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStartKey()).compareTo(other.isSetStartKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStartKey() && (lastComparison = TBaseHelper.compareTo((Comparable)this.startKey, (Comparable)other.startKey)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEndKey()).compareTo(other.isSetEndKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEndKey() && (lastComparison = TBaseHelper.compareTo((Comparable)this.endKey, (Comparable)other.endKey)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOffline()).compareTo(other.isSetOffline());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOffline() && (lastComparison = TBaseHelper.compareTo((boolean)this.offline, (boolean)other.offline)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSplit()).compareTo(other.isSetSplit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSplit() && (lastComparison = TBaseHelper.compareTo((boolean)this.split, (boolean)other.split)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicaId()).compareTo(other.isSetReplicaId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaId() && (lastComparison = TBaseHelper.compareTo((int)this.replicaId, (int)other.replicaId)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("THRegionInfo(");
        boolean first = true;
        sb.append("regionId:");
        sb.append(this.regionId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.tableName, (StringBuilder)sb);
        }
        first = false;
        if (this.isSetStartKey()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("startKey:");
            if (this.startKey == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.startKey, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetEndKey()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("endKey:");
            if (this.endKey == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.endKey, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetOffline()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("offline:");
            sb.append(this.offline);
            first = false;
        }
        if (this.isSetSplit()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("split:");
            sb.append(this.split);
            first = false;
        }
        if (this.isSetReplicaId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replicaId:");
            sb.append(this.replicaId);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.tableName == null) {
            throw new TProtocolException("Required field 'tableName' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new THRegionInfoStandardSchemeFactory());
        schemes.put(TupleScheme.class, new THRegionInfoTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.START_KEY, _Fields.END_KEY, _Fields.OFFLINE, _Fields.SPLIT, _Fields.REPLICA_ID};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.REGION_ID, new FieldMetaData("regionId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.START_KEY, new FieldMetaData("startKey", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.END_KEY, new FieldMetaData("endKey", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.OFFLINE, new FieldMetaData("offline", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.SPLIT, new FieldMetaData("split", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.REPLICA_ID, new FieldMetaData("replicaId", 2, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(THRegionInfo.class, metaDataMap);
    }

    private static class THRegionInfoTupleScheme
    extends TupleScheme<THRegionInfo> {
        private THRegionInfoTupleScheme() {
        }

        public void write(TProtocol prot, THRegionInfo struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.regionId);
            oprot.writeBinary(struct.tableName);
            BitSet optionals = new BitSet();
            if (struct.isSetStartKey()) {
                optionals.set(0);
            }
            if (struct.isSetEndKey()) {
                optionals.set(1);
            }
            if (struct.isSetOffline()) {
                optionals.set(2);
            }
            if (struct.isSetSplit()) {
                optionals.set(3);
            }
            if (struct.isSetReplicaId()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetStartKey()) {
                oprot.writeBinary(struct.startKey);
            }
            if (struct.isSetEndKey()) {
                oprot.writeBinary(struct.endKey);
            }
            if (struct.isSetOffline()) {
                oprot.writeBool(struct.offline);
            }
            if (struct.isSetSplit()) {
                oprot.writeBool(struct.split);
            }
            if (struct.isSetReplicaId()) {
                oprot.writeI32(struct.replicaId);
            }
        }

        public void read(TProtocol prot, THRegionInfo struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.regionId = iprot.readI64();
            struct.setRegionIdIsSet(true);
            struct.tableName = iprot.readBinary();
            struct.setTableNameIsSet(true);
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.startKey = iprot.readBinary();
                struct.setStartKeyIsSet(true);
            }
            if (incoming.get(1)) {
                struct.endKey = iprot.readBinary();
                struct.setEndKeyIsSet(true);
            }
            if (incoming.get(2)) {
                struct.offline = iprot.readBool();
                struct.setOfflineIsSet(true);
            }
            if (incoming.get(3)) {
                struct.split = iprot.readBool();
                struct.setSplitIsSet(true);
            }
            if (incoming.get(4)) {
                struct.replicaId = iprot.readI32();
                struct.setReplicaIdIsSet(true);
            }
        }
    }

    private static class THRegionInfoTupleSchemeFactory
    implements SchemeFactory {
        private THRegionInfoTupleSchemeFactory() {
        }

        public THRegionInfoTupleScheme getScheme() {
            return new THRegionInfoTupleScheme();
        }
    }

    private static class THRegionInfoStandardScheme
    extends StandardScheme<THRegionInfo> {
        private THRegionInfoStandardScheme() {
        }

        public void read(TProtocol iprot, THRegionInfo struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.regionId = iprot.readI64();
                            struct.setRegionIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.tableName = iprot.readBinary();
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.startKey = iprot.readBinary();
                            struct.setStartKeyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.endKey = iprot.readBinary();
                            struct.setEndKeyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 2) {
                            struct.offline = iprot.readBool();
                            struct.setOfflineIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 2) {
                            struct.split = iprot.readBool();
                            struct.setSplitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.replicaId = iprot.readI32();
                            struct.setReplicaIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetRegionId()) {
                throw new TProtocolException("Required field 'regionId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, THRegionInfo struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(REGION_ID_FIELD_DESC);
            oprot.writeI64(struct.regionId);
            oprot.writeFieldEnd();
            if (struct.tableName != null) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeBinary(struct.tableName);
                oprot.writeFieldEnd();
            }
            if (struct.startKey != null && struct.isSetStartKey()) {
                oprot.writeFieldBegin(START_KEY_FIELD_DESC);
                oprot.writeBinary(struct.startKey);
                oprot.writeFieldEnd();
            }
            if (struct.endKey != null && struct.isSetEndKey()) {
                oprot.writeFieldBegin(END_KEY_FIELD_DESC);
                oprot.writeBinary(struct.endKey);
                oprot.writeFieldEnd();
            }
            if (struct.isSetOffline()) {
                oprot.writeFieldBegin(OFFLINE_FIELD_DESC);
                oprot.writeBool(struct.offline);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSplit()) {
                oprot.writeFieldBegin(SPLIT_FIELD_DESC);
                oprot.writeBool(struct.split);
                oprot.writeFieldEnd();
            }
            if (struct.isSetReplicaId()) {
                oprot.writeFieldBegin(REPLICA_ID_FIELD_DESC);
                oprot.writeI32(struct.replicaId);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class THRegionInfoStandardSchemeFactory
    implements SchemeFactory {
        private THRegionInfoStandardSchemeFactory() {
        }

        public THRegionInfoStandardScheme getScheme() {
            return new THRegionInfoStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        REGION_ID(1, "regionId"),
        TABLE_NAME(2, "tableName"),
        START_KEY(3, "startKey"),
        END_KEY(4, "endKey"),
        OFFLINE(5, "offline"),
        SPLIT(6, "split"),
        REPLICA_ID(7, "replicaId");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return REGION_ID;
                }
                case 2: {
                    return TABLE_NAME;
                }
                case 3: {
                    return START_KEY;
                }
                case 4: {
                    return END_KEY;
                }
                case 5: {
                    return OFFLINE;
                }
                case 6: {
                    return SPLIT;
                }
                case 7: {
                    return REPLICA_ID;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

