/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.TAppend;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TColumn;
import org.apache.hadoop.hbase.thrift.generated.TIncrement;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ThriftUtilities {
    public static HColumnDescriptor colDescFromThrift(ColumnDescriptor in) throws IllegalArgument {
        Compression.Algorithm comp = Compression.getCompressionAlgorithmByName((String)in.compression.toLowerCase(Locale.ROOT));
        BloomType bt = BloomType.valueOf((String)in.bloomFilterType);
        if (in.name == null || !in.name.hasRemaining()) {
            throw new IllegalArgument("column name is empty");
        }
        byte[] parsedName = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)in.name))[0];
        HColumnDescriptor col = new HColumnDescriptor(parsedName).setMaxVersions(in.maxVersions).setCompressionType(comp).setInMemory(in.inMemory).setBlockCacheEnabled(in.blockCacheEnabled).setTimeToLive(in.timeToLive > 0 ? in.timeToLive : Integer.MAX_VALUE).setBloomFilterType(bt);
        return col;
    }

    public static ColumnDescriptor colDescFromHbase(HColumnDescriptor in) {
        ColumnDescriptor col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(Bytes.add((byte[])in.getName(), (byte[])KeyValue.COLUMN_FAMILY_DELIM_ARRAY));
        col.maxVersions = in.getMaxVersions();
        col.compression = in.getCompressionType().toString();
        col.inMemory = in.isInMemory();
        col.blockCacheEnabled = in.isBlockCacheEnabled();
        col.bloomFilterType = in.getBloomFilterType().toString();
        col.timeToLive = in.getTimeToLive();
        return col;
    }

    public static List<TCell> cellFromHBase(Cell in) {
        ArrayList<TCell> list = new ArrayList<TCell>(1);
        if (in != null) {
            list.add(new TCell(ByteBuffer.wrap(CellUtil.cloneValue((Cell)in)), in.getTimestamp()));
        }
        return list;
    }

    public static List<TCell> cellFromHBase(Cell[] in) {
        ArrayList<TCell> list = null;
        if (in != null) {
            list = new ArrayList(in.length);
            for (int i = 0; i < in.length; ++i) {
                list.add(new TCell(ByteBuffer.wrap(CellUtil.cloneValue((Cell)in[i])), in[i].getTimestamp()));
            }
        } else {
            list = new ArrayList<TCell>(0);
        }
        return list;
    }

    public static List<TRowResult> rowResultFromHBase(Result[] in, boolean sortColumns) {
        ArrayList<TRowResult> results = new ArrayList<TRowResult>(in.length);
        for (Result result_ : in) {
            if (result_ == null || result_.isEmpty()) continue;
            TRowResult result = new TRowResult();
            result.row = ByteBuffer.wrap(result_.getRow());
            if (sortColumns) {
                result.sortedColumns = new ArrayList<TColumn>();
                for (Cell kv : result_.rawCells()) {
                    result.sortedColumns.add(new TColumn(ByteBuffer.wrap(KeyValue.makeColumn((byte[])CellUtil.cloneFamily((Cell)kv), (byte[])CellUtil.cloneQualifier((Cell)kv))), new TCell(ByteBuffer.wrap(CellUtil.cloneValue((Cell)kv)), kv.getTimestamp())));
                }
            } else {
                result.columns = new TreeMap<ByteBuffer, TCell>();
                for (Cell kv : result_.rawCells()) {
                    result.columns.put(ByteBuffer.wrap(KeyValue.makeColumn((byte[])CellUtil.cloneFamily((Cell)kv), (byte[])CellUtil.cloneQualifier((Cell)kv))), new TCell(ByteBuffer.wrap(CellUtil.cloneValue((Cell)kv)), kv.getTimestamp()));
                }
            }
            results.add(result);
        }
        return results;
    }

    public static List<TRowResult> rowResultFromHBase(Result[] in) {
        return ThriftUtilities.rowResultFromHBase(in, false);
    }

    public static List<TRowResult> rowResultFromHBase(Result in) {
        Result[] result = new Result[]{in};
        return ThriftUtilities.rowResultFromHBase(result);
    }

    public static Increment incrementFromThrift(TIncrement tincrement) {
        Increment inc = new Increment(tincrement.getRow());
        byte[][] famAndQf = KeyValue.parseColumn((byte[])tincrement.getColumn());
        if (famAndQf.length != 2) {
            return null;
        }
        inc.addColumn(famAndQf[0], famAndQf[1], tincrement.getAmmount());
        return inc;
    }

    public static Append appendFromThrift(TAppend tappend) {
        Append append2 = new Append(tappend.getRow());
        List<ByteBuffer> columns = tappend.getColumns();
        List<ByteBuffer> values = tappend.getValues();
        if (columns.size() != values.size()) {
            throw new IllegalArgumentException("Sizes of columns and values in tappend object are not matching");
        }
        int length = columns.size();
        for (int i = 0; i < length; ++i) {
            byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.getBytes((ByteBuffer)columns.get(i)));
            append2.add(famAndQf[0], famAndQf[1], Bytes.getBytes((ByteBuffer)values.get(i)));
        }
        return append2;
    }
}

