/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class Mutation
implements TBase<Mutation, _Fields>,
Serializable,
Cloneable,
Comparable<Mutation> {
    private static final TStruct STRUCT_DESC = new TStruct("Mutation");
    private static final TField IS_DELETE_FIELD_DESC = new TField("isDelete", 2, 1);
    private static final TField COLUMN_FIELD_DESC = new TField("column", 11, 2);
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 3);
    private static final TField WRITE_TO_WAL_FIELD_DESC = new TField("writeToWAL", 2, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public boolean isDelete;
    public ByteBuffer column;
    public ByteBuffer value;
    public boolean writeToWAL;
    private static final int __ISDELETE_ISSET_ID = 0;
    private static final int __WRITETOWAL_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Mutation() {
        this.isDelete = false;
        this.writeToWAL = true;
    }

    public Mutation(boolean isDelete, ByteBuffer column, ByteBuffer value, boolean writeToWAL) {
        this();
        this.isDelete = isDelete;
        this.setIsDeleteIsSet(true);
        this.column = TBaseHelper.copyBinary((ByteBuffer)column);
        this.value = TBaseHelper.copyBinary((ByteBuffer)value);
        this.writeToWAL = writeToWAL;
        this.setWriteToWALIsSet(true);
    }

    public Mutation(Mutation other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.isDelete = other.isDelete;
        if (other.isSetColumn()) {
            this.column = other.column;
        }
        if (other.isSetValue()) {
            this.value = other.value;
        }
        this.writeToWAL = other.writeToWAL;
    }

    public Mutation deepCopy() {
        return new Mutation(this);
    }

    public void clear() {
        this.isDelete = false;
        this.column = null;
        this.value = null;
        this.writeToWAL = true;
    }

    public boolean isIsDelete() {
        return this.isDelete;
    }

    public Mutation setIsDelete(boolean isDelete) {
        this.isDelete = isDelete;
        this.setIsDeleteIsSet(true);
        return this;
    }

    public void unsetIsDelete() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetIsDelete() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIsDeleteIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public byte[] getColumn() {
        this.setColumn(TBaseHelper.rightSize((ByteBuffer)this.column));
        return this.column == null ? null : this.column.array();
    }

    public ByteBuffer bufferForColumn() {
        return TBaseHelper.copyBinary((ByteBuffer)this.column);
    }

    public Mutation setColumn(byte[] column) {
        this.column = column == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(column, column.length));
        return this;
    }

    public Mutation setColumn(ByteBuffer column) {
        this.column = TBaseHelper.copyBinary((ByteBuffer)column);
        return this;
    }

    public void unsetColumn() {
        this.column = null;
    }

    public boolean isSetColumn() {
        return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
        if (!value) {
            this.column = null;
        }
    }

    public byte[] getValue() {
        this.setValue(TBaseHelper.rightSize((ByteBuffer)this.value));
        return this.value == null ? null : this.value.array();
    }

    public ByteBuffer bufferForValue() {
        return TBaseHelper.copyBinary((ByteBuffer)this.value);
    }

    public Mutation setValue(byte[] value) {
        this.value = value == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(value, value.length));
        return this;
    }

    public Mutation setValue(ByteBuffer value) {
        this.value = TBaseHelper.copyBinary((ByteBuffer)value);
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean value) {
        if (!value) {
            this.value = null;
        }
    }

    public boolean isWriteToWAL() {
        return this.writeToWAL;
    }

    public Mutation setWriteToWAL(boolean writeToWAL) {
        this.writeToWAL = writeToWAL;
        this.setWriteToWALIsSet(true);
        return this;
    }

    public void unsetWriteToWAL() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetWriteToWAL() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setWriteToWALIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case IS_DELETE: {
                if (value == null) {
                    this.unsetIsDelete();
                    break;
                }
                this.setIsDelete((Boolean)value);
                break;
            }
            case COLUMN: {
                if (value == null) {
                    this.unsetColumn();
                    break;
                }
                this.setColumn((ByteBuffer)value);
                break;
            }
            case VALUE: {
                if (value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((ByteBuffer)value);
                break;
            }
            case WRITE_TO_WAL: {
                if (value == null) {
                    this.unsetWriteToWAL();
                    break;
                }
                this.setWriteToWAL((Boolean)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case IS_DELETE: {
                return this.isIsDelete();
            }
            case COLUMN: {
                return this.getColumn();
            }
            case VALUE: {
                return this.getValue();
            }
            case WRITE_TO_WAL: {
                return this.isWriteToWAL();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case IS_DELETE: {
                return this.isSetIsDelete();
            }
            case COLUMN: {
                return this.isSetColumn();
            }
            case VALUE: {
                return this.isSetValue();
            }
            case WRITE_TO_WAL: {
                return this.isSetWriteToWAL();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Mutation) {
            return this.equals((Mutation)that);
        }
        return false;
    }

    public boolean equals(Mutation that) {
        if (that == null) {
            return false;
        }
        boolean this_present_isDelete = true;
        boolean that_present_isDelete = true;
        if (this_present_isDelete || that_present_isDelete) {
            if (!this_present_isDelete || !that_present_isDelete) {
                return false;
            }
            if (this.isDelete != that.isDelete) {
                return false;
            }
        }
        boolean this_present_column = this.isSetColumn();
        boolean that_present_column = that.isSetColumn();
        if (this_present_column || that_present_column) {
            if (!this_present_column || !that_present_column) {
                return false;
            }
            if (!this.column.equals(that.column)) {
                return false;
            }
        }
        boolean this_present_value = this.isSetValue();
        boolean that_present_value = that.isSetValue();
        if (this_present_value || that_present_value) {
            if (!this_present_value || !that_present_value) {
                return false;
            }
            if (!this.value.equals(that.value)) {
                return false;
            }
        }
        boolean this_present_writeToWAL = true;
        boolean that_present_writeToWAL = true;
        if (this_present_writeToWAL || that_present_writeToWAL) {
            if (!this_present_writeToWAL || !that_present_writeToWAL) {
                return false;
            }
            if (this.writeToWAL != that.writeToWAL) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_isDelete = true;
        list.add(Boolean.valueOf(present_isDelete));
        if (present_isDelete) {
            list.add(Boolean.valueOf(this.isDelete));
        }
        boolean present_column = this.isSetColumn();
        list.add(Boolean.valueOf(present_column));
        if (present_column) {
            list.add(this.column);
        }
        boolean present_value = this.isSetValue();
        list.add(Boolean.valueOf(present_value));
        if (present_value) {
            list.add(this.value);
        }
        boolean present_writeToWAL = true;
        list.add(Boolean.valueOf(present_writeToWAL));
        if (present_writeToWAL) {
            list.add(Boolean.valueOf(this.writeToWAL));
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(Mutation other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetIsDelete()).compareTo(other.isSetIsDelete());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsDelete() && (lastComparison = TBaseHelper.compareTo((boolean)this.isDelete, (boolean)other.isDelete)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn()).compareTo(other.isSetColumn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn() && (lastComparison = TBaseHelper.compareTo((Comparable)this.column, (Comparable)other.column)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(other.isSetValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo((Comparable)this.value, (Comparable)other.value)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetWriteToWAL()).compareTo(other.isSetWriteToWAL());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWriteToWAL() && (lastComparison = TBaseHelper.compareTo((boolean)this.writeToWAL, (boolean)other.writeToWAL)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Mutation(");
        boolean first = true;
        sb.append("isDelete:");
        sb.append(this.isDelete);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("column:");
        if (this.column == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.column, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("value:");
        if (this.value == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.value, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("writeToWAL:");
        sb.append(this.writeToWAL);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new MutationStandardSchemeFactory());
        schemes.put(TupleScheme.class, new MutationTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.IS_DELETE, new FieldMetaData("isDelete", 3, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.COLUMN, new FieldMetaData("column", 3, new FieldValueMetaData(11, "Text")));
        tmpMap.put(_Fields.VALUE, new FieldMetaData("value", 3, new FieldValueMetaData(11, "Text")));
        tmpMap.put(_Fields.WRITE_TO_WAL, new FieldMetaData("writeToWAL", 3, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Mutation.class, metaDataMap);
    }

    private static class MutationTupleScheme
    extends TupleScheme<Mutation> {
        private MutationTupleScheme() {
        }

        public void write(TProtocol prot, Mutation struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetIsDelete()) {
                optionals.set(0);
            }
            if (struct.isSetColumn()) {
                optionals.set(1);
            }
            if (struct.isSetValue()) {
                optionals.set(2);
            }
            if (struct.isSetWriteToWAL()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetIsDelete()) {
                oprot.writeBool(struct.isDelete);
            }
            if (struct.isSetColumn()) {
                oprot.writeBinary(struct.column);
            }
            if (struct.isSetValue()) {
                oprot.writeBinary(struct.value);
            }
            if (struct.isSetWriteToWAL()) {
                oprot.writeBool(struct.writeToWAL);
            }
        }

        public void read(TProtocol prot, Mutation struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.isDelete = iprot.readBool();
                struct.setIsDeleteIsSet(true);
            }
            if (incoming.get(1)) {
                struct.column = iprot.readBinary();
                struct.setColumnIsSet(true);
            }
            if (incoming.get(2)) {
                struct.value = iprot.readBinary();
                struct.setValueIsSet(true);
            }
            if (incoming.get(3)) {
                struct.writeToWAL = iprot.readBool();
                struct.setWriteToWALIsSet(true);
            }
        }
    }

    private static class MutationTupleSchemeFactory
    implements SchemeFactory {
        private MutationTupleSchemeFactory() {
        }

        public MutationTupleScheme getScheme() {
            return new MutationTupleScheme();
        }
    }

    private static class MutationStandardScheme
    extends StandardScheme<Mutation> {
        private MutationStandardScheme() {
        }

        public void read(TProtocol iprot, Mutation struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 2) {
                            struct.isDelete = iprot.readBool();
                            struct.setIsDeleteIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.column = iprot.readBinary();
                            struct.setColumnIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.value = iprot.readBinary();
                            struct.setValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 2) {
                            struct.writeToWAL = iprot.readBool();
                            struct.setWriteToWALIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, Mutation struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(IS_DELETE_FIELD_DESC);
            oprot.writeBool(struct.isDelete);
            oprot.writeFieldEnd();
            if (struct.column != null) {
                oprot.writeFieldBegin(COLUMN_FIELD_DESC);
                oprot.writeBinary(struct.column);
                oprot.writeFieldEnd();
            }
            if (struct.value != null) {
                oprot.writeFieldBegin(VALUE_FIELD_DESC);
                oprot.writeBinary(struct.value);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(WRITE_TO_WAL_FIELD_DESC);
            oprot.writeBool(struct.writeToWAL);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class MutationStandardSchemeFactory
    implements SchemeFactory {
        private MutationStandardSchemeFactory() {
        }

        public MutationStandardScheme getScheme() {
            return new MutationStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        IS_DELETE(1, "isDelete"),
        COLUMN(2, "column"),
        VALUE(3, "value"),
        WRITE_TO_WAL(4, "writeToWAL");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return IS_DELETE;
                }
                case 2: {
                    return COLUMN;
                }
                case 3: {
                    return VALUE;
                }
                case 4: {
                    return WRITE_TO_WAL;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

