/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslServer;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.http.HttpServerUtil;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.metrics.JvmPauseMonitorSource;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityUtil;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.thrift.CallQueue;
import org.apache.hadoop.hbase.thrift.HBaseServiceHandler;
import org.apache.hadoop.hbase.thrift.HThreadedSelectorServerArgs;
import org.apache.hadoop.hbase.thrift.HbaseHandlerMetricsProxy;
import org.apache.hadoop.hbase.thrift.ImplType;
import org.apache.hadoop.hbase.thrift.TBoundedThreadPoolServer;
import org.apache.hadoop.hbase.thrift.THBaseThreadPoolExecutor;
import org.apache.hadoop.hbase.thrift.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift.ThriftHttpServlet;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.JvmPauseMonitor;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServlet;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class ThriftServer
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftServer.class);
    protected Configuration conf;
    protected InfoServer infoServer;
    protected TProcessor processor;
    protected ThriftMetrics metrics;
    protected HBaseServiceHandler hbaseServiceHandler;
    protected UserGroupInformation serviceUGI;
    protected boolean httpEnabled;
    protected SaslUtil.QualityOfProtection qop;
    protected String host;
    protected int listenPort;
    protected boolean securityEnabled;
    protected boolean doAsEnabled;
    protected JvmPauseMonitor pauseMonitor;
    protected volatile TServer tserver;
    protected volatile Server httpServer;

    public ThriftServer(Configuration conf) {
        this.conf = HBaseConfiguration.create((Configuration)conf);
    }

    protected ThriftMetrics createThriftMetrics(Configuration conf) {
        return new ThriftMetrics(conf, ThriftMetrics.ThriftServerType.ONE);
    }

    protected void setupParamters() throws IOException {
        String strQop;
        UserProvider userProvider = UserProvider.instantiate((Configuration)this.conf);
        boolean bl = this.securityEnabled = userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled();
        if (this.securityEnabled) {
            this.host = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)this.conf.get("hbase.thrift.dns.interface", "default"), (String)this.conf.get("hbase.thrift.dns.nameserver", "default")));
            userProvider.login("hbase.thrift.keytab.file", "hbase.thrift.kerberos.principal", this.host);
        }
        this.serviceUGI = userProvider.getCurrent().getUGI();
        this.listenPort = this.conf.getInt("hbase.regionserver.thrift.port", 9090);
        this.metrics = this.createThriftMetrics(this.conf);
        this.pauseMonitor = new JvmPauseMonitor(this.conf, (JvmPauseMonitorSource)this.metrics.getSource());
        this.hbaseServiceHandler = this.createHandler(this.conf, userProvider);
        this.hbaseServiceHandler.initMetrics(this.metrics);
        this.processor = this.createProcessor();
        this.httpEnabled = this.conf.getBoolean("hbase.regionserver.thrift.http", false);
        this.doAsEnabled = this.conf.getBoolean("hbase.thrift.support.proxyuser", false);
        if (this.doAsEnabled && !this.httpEnabled) {
            LOG.warn("Fail to enable the doAs feature. hbase.regionserver.thrift.http is not configured");
        }
        if ((strQop = this.conf.get("hbase.thrift.security.qop")) != null) {
            this.qop = SaslUtil.getQop((String)strQop);
        }
        if (this.qop != null) {
            if (this.qop != SaslUtil.QualityOfProtection.AUTHENTICATION && this.qop != SaslUtil.QualityOfProtection.INTEGRITY && this.qop != SaslUtil.QualityOfProtection.PRIVACY) {
                throw new IOException(String.format("Invalid %s: It must be one of %s, %s, or %s.", "hbase.thrift.security.qop", SaslUtil.QualityOfProtection.AUTHENTICATION.name(), SaslUtil.QualityOfProtection.INTEGRITY.name(), SaslUtil.QualityOfProtection.PRIVACY.name()));
            }
            this.checkHttpSecurity(this.qop, this.conf);
            if (!this.securityEnabled) {
                throw new IOException("Thrift server must run in secure mode to support authentication");
            }
        }
        ThriftServer.registerFilters(this.conf);
        this.pauseMonitor.start();
    }

    protected void startInfoServer() throws IOException {
        int port = this.conf.getInt("hbase.thrift.info.port", 9095);
        if (port >= 0) {
            this.conf.setLong("startcode", System.currentTimeMillis());
            String a = this.conf.get("hbase.thrift.info.bindAddress", "0.0.0.0");
            this.infoServer = new InfoServer("thrift", a, port, false, this.conf);
            this.infoServer.setAttribute("hbase.conf", (Object)this.conf);
            this.infoServer.start();
        }
    }

    protected void checkHttpSecurity(SaslUtil.QualityOfProtection qop, Configuration conf) {
        if (qop == SaslUtil.QualityOfProtection.PRIVACY && conf.getBoolean("hbase.regionserver.thrift.http", false) && !conf.getBoolean("hbase.thrift.ssl.enabled", false)) {
            throw new IllegalArgumentException("Thrift HTTP Server's QoP is privacy, but hbase.thrift.ssl.enabled is false");
        }
    }

    protected HBaseServiceHandler createHandler(Configuration conf, UserProvider userProvider) throws IOException {
        return new ThriftHBaseServiceHandler(conf, userProvider);
    }

    protected TProcessor createProcessor() {
        return new Hbase.Processor<Hbase.Iface>(HbaseHandlerMetricsProxy.newInstance((Hbase.Iface)((Object)this.hbaseServiceHandler), this.metrics, this.conf));
    }

    @VisibleForTesting
    public TServer getTserver() {
        return this.tserver;
    }

    @VisibleForTesting
    public Server getHttpServer() {
        return this.httpServer;
    }

    protected void printUsageAndExit(Options options, int exitCode) throws Shell.ExitCodeException {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Thrift", null, options, "To start the Thrift server run 'hbase-daemon.sh start thrift' or 'hbase thrift'\nTo shutdown the thrift server run 'hbase-daemon.sh stop thrift' or send a kill signal to the thrift server pid", true);
        throw new Shell.ExitCodeException(exitCode, "");
    }

    protected TServlet createTServlet(TProtocolFactory protocolFactory) throws IOException {
        return new ThriftHttpServlet(this.processor, protocolFactory, this.serviceUGI, this.conf, this.hbaseServiceHandler, this.securityEnabled, this.doAsEnabled);
    }

    protected void setupHTTPServer() throws IOException {
        ServerConnector serverConnector;
        TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
        TServlet thriftHttpServlet = this.createTServlet((TProtocolFactory)protocolFactory);
        int minThreads = this.conf.getInt("hbase.thrift.http_threads.min", this.conf.getInt("hbase.thrift.minWorkerThreads", 2));
        int maxThreads = this.conf.getInt("hbase.thrift.http_threads.max", this.conf.getInt("hbase.thrift.maxWorkerThreads", 100));
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads);
        threadPool.setMinThreads(minThreads);
        this.httpServer = new Server((ThreadPool)threadPool);
        ServletContextHandler ctxHandler = new ServletContextHandler((HandlerContainer)this.httpServer, "/", 1);
        ctxHandler.addServlet(new ServletHolder((Servlet)thriftHttpServlet), "/*");
        HttpServerUtil.constrainHttpMethods((ServletContextHandler)ctxHandler, (boolean)this.conf.getBoolean("hbase.thrift.http.allow.options.method", false));
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(this.listenPort);
        httpConfig.setHeaderCacheSize(65536);
        httpConfig.setRequestHeaderSize(65536);
        httpConfig.setResponseHeaderSize(65536);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        if (this.conf.getBoolean("hbase.thrift.ssl.enabled", false)) {
            String[] includeProtocols;
            String[] excludeProtocols;
            String[] includeCiphers;
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory sslCtxFactory = new SslContextFactory();
            String keystore = this.conf.get("hbase.thrift.ssl.keystore.store");
            String password = HBaseConfiguration.getPassword((Configuration)this.conf, (String)"hbase.thrift.ssl.keystore.password", null);
            String keyPassword = HBaseConfiguration.getPassword((Configuration)this.conf, (String)"hbase.thrift.ssl.keystore.keypassword", (String)password);
            sslCtxFactory.setKeyStorePath(keystore);
            sslCtxFactory.setKeyStorePassword(password);
            sslCtxFactory.setKeyManagerPassword(keyPassword);
            String[] excludeCiphers = this.conf.getStrings("hbase.thrift.ssl.exclude.cipher.suites", ArrayUtils.EMPTY_STRING_ARRAY);
            if (excludeCiphers.length != 0) {
                sslCtxFactory.setExcludeCipherSuites(excludeCiphers);
            }
            if ((includeCiphers = this.conf.getStrings("hbase.thrift.ssl.include.cipher.suites", ArrayUtils.EMPTY_STRING_ARRAY)).length != 0) {
                sslCtxFactory.setIncludeCipherSuites(includeCiphers);
            }
            if ((excludeProtocols = this.conf.getStrings("hbase.thrift.ssl.exclude.protocols", new String[]{"SSLv3"})).length != 0) {
                sslCtxFactory.setExcludeProtocols(excludeProtocols);
            }
            if ((includeProtocols = this.conf.getStrings("hbase.thrift.ssl.include.protocols", ArrayUtils.EMPTY_STRING_ARRAY)).length != 0) {
                sslCtxFactory.setIncludeProtocols(includeProtocols);
            }
            serverConnector = new ServerConnector(this.httpServer, new ConnectionFactory[]{new SslConnectionFactory(sslCtxFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(httpsConfig)});
        } else {
            serverConnector = new ServerConnector(this.httpServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        }
        serverConnector.setPort(this.listenPort);
        serverConnector.setHost(this.getBindAddress(this.conf).getHostAddress());
        this.httpServer.addConnector((Connector)serverConnector);
        this.httpServer.setStopAtShutdown(true);
        if (this.doAsEnabled) {
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        }
        LOG.info("Starting Thrift HTTP Server on {}", (Object)Integer.toString(this.listenPort));
    }

    protected void setupServer() throws Exception {
        TTransportFactory transportFactory;
        TProtocolFactory protocolFactory = this.getProtocolFactory();
        ImplType implType = ImplType.getServerImpl(this.conf);
        TProcessor processorToUse = this.processor;
        if (this.conf.getBoolean("hbase.regionserver.thrift.framed", false) || implType.isAlwaysFramed) {
            if (this.qop != null) {
                throw new RuntimeException("Thrift server authentication doesn't work with framed transport yet");
            }
            transportFactory = new TFramedTransport.Factory(this.conf.getInt("hbase.regionserver.thrift.framed.max_frame_size_in_mb", 2) * 1024 * 1024);
            LOG.debug("Using framed transport");
        } else if (this.qop == null) {
            transportFactory = new TTransportFactory();
        } else {
            String thriftKerberosPrincipal = this.conf.get("hbase.thrift.kerberos.principal");
            if (thriftKerberosPrincipal == null) {
                throw new IllegalArgumentException("hbase.thrift.kerberos.principal cannot be null");
            }
            String name = SecurityUtil.getUserFromPrincipal((String)thriftKerberosPrincipal);
            Map saslProperties = SaslUtil.initSaslProperties((String)this.qop.name());
            TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
            saslFactory.addServerDefinition("GSSAPI", name, this.host, saslProperties, (CallbackHandler)new SaslRpcServer.SaslGssCallbackHandler(){

                public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                    AuthorizeCallback ac = null;
                    for (Callback callback : callbacks) {
                        if (!(callback instanceof AuthorizeCallback)) {
                            throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                        }
                        ac = (AuthorizeCallback)callback;
                    }
                    if (ac != null) {
                        String authzid;
                        String authid = ac.getAuthenticationID();
                        if (!authid.equals(authzid = ac.getAuthorizationID())) {
                            ac.setAuthorized(false);
                        } else {
                            ac.setAuthorized(true);
                            String userName = SecurityUtil.getUserFromPrincipal((String)authzid);
                            LOG.info("Effective user: {}", (Object)userName);
                            ac.setAuthorizedID(userName);
                        }
                    }
                }
            });
            transportFactory = saslFactory;
            processorToUse = (inProt, outProt) -> {
                TSaslServerTransport saslServerTransport = (TSaslServerTransport)inProt.getTransport();
                SaslServer saslServer = saslServerTransport.getSaslServer();
                String principal = saslServer.getAuthorizationID();
                this.hbaseServiceHandler.setEffectiveUser(principal);
                return this.processor.process(inProt, outProt);
            };
        }
        if (this.conf.get("hbase.regionserver.thrift.ipaddress") != null && !implType.canSpecifyBindIP) {
            LOG.error("Server types {} don't support IP address binding at the moment. See https://issues.apache.org/jira/browse/HBASE-2155 for details.", (Object)Joiner.on((String)", ").join(ImplType.serversThatCannotSpecifyBindIP()));
            throw new RuntimeException("-hbase.regionserver.thrift.ipaddress not supported with " + (Object)((Object)implType));
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getBindAddress(this.conf), this.listenPort);
        if (implType == ImplType.HS_HA || implType == ImplType.NONBLOCKING || implType == ImplType.THREADED_SELECTOR) {
            TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(inetSocketAddress);
            this.tserver = implType == ImplType.NONBLOCKING ? this.getTNonBlockingServer((TNonblockingServerTransport)serverTransport, protocolFactory, processorToUse, transportFactory, inetSocketAddress) : (implType == ImplType.HS_HA ? this.getTHsHaServer((TNonblockingServerTransport)serverTransport, protocolFactory, processorToUse, transportFactory, inetSocketAddress) : this.getTThreadedSelectorServer((TNonblockingServerTransport)serverTransport, protocolFactory, processorToUse, transportFactory, inetSocketAddress));
            LOG.info("starting HBase {} server on {}", (Object)implType.simpleClassName(), (Object)Integer.toString(this.listenPort));
        } else if (implType == ImplType.THREAD_POOL) {
            this.tserver = this.getTThreadPoolServer(protocolFactory, processorToUse, transportFactory, inetSocketAddress);
        } else {
            throw new AssertionError((Object)("Unsupported Thrift server implementation: " + implType.simpleClassName()));
        }
        if (this.tserver.getClass() != implType.serverClass) {
            throw new AssertionError((Object)("Expected to create Thrift server class " + implType.serverClass.getName() + " but got " + this.tserver.getClass().getName()));
        }
    }

    protected TServer getTNonBlockingServer(TNonblockingServerTransport serverTransport, TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) {
        LOG.info("starting HBase Nonblocking Thrift server on " + inetSocketAddress.toString());
        TNonblockingServer.Args serverArgs = new TNonblockingServer.Args(serverTransport);
        serverArgs.processor(processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new TNonblockingServer((AbstractNonblockingServer.AbstractNonblockingServerArgs)serverArgs);
    }

    protected TServer getTHsHaServer(TNonblockingServerTransport serverTransport, TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) {
        LOG.info("starting HBase HsHA Thrift server on " + inetSocketAddress.toString());
        THsHaServer.Args serverArgs = new THsHaServer.Args(serverTransport);
        int queueSize = this.conf.getInt("hbase.thrift.maxQueuedRequests", 1000);
        CallQueue callQueue = new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(queueSize), this.metrics);
        int workerThread = this.conf.getInt("hbase.thrift.maxWorkerThreads", serverArgs.getMaxWorkerThreads());
        ExecutorService executorService = this.createExecutor(callQueue, workerThread, workerThread);
        ((THsHaServer.Args)((THsHaServer.Args)serverArgs.executorService(executorService).processor(processor)).transportFactory(transportFactory)).protocolFactory(protocolFactory);
        return new THsHaServer(serverArgs);
    }

    protected TServer getTThreadedSelectorServer(TNonblockingServerTransport serverTransport, TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) {
        LOG.info("starting HBase ThreadedSelector Thrift server on " + inetSocketAddress.toString());
        HThreadedSelectorServerArgs serverArgs = new HThreadedSelectorServerArgs(serverTransport, this.conf);
        int queueSize = this.conf.getInt("hbase.thrift.maxQueuedRequests", 1000);
        CallQueue callQueue = new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(queueSize), this.metrics);
        int workerThreads = this.conf.getInt("hbase.thrift.maxWorkerThreads", serverArgs.getWorkerThreads());
        int selectorThreads = this.conf.getInt("hbase.thrift.selector.num", serverArgs.getSelectorThreads());
        serverArgs.selectorThreads(selectorThreads);
        ExecutorService executorService = this.createExecutor(callQueue, workerThreads, workerThreads);
        ((TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)serverArgs.executorService(executorService).processor(processor)).transportFactory(transportFactory)).protocolFactory(protocolFactory);
        return new TThreadedSelectorServer((TThreadedSelectorServer.Args)serverArgs);
    }

    protected TServer getTThreadPoolServer(TProtocolFactory protocolFactory, TProcessor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) throws Exception {
        LOG.info("starting HBase ThreadPool Thrift server on " + inetSocketAddress.toString());
        int backlog = this.conf.getInt("hbase.regionserver.thrift.backlog", 0);
        int readTimeout = this.conf.getInt("hbase.thrift.server.socket.read.timeout", 60000);
        TServerSocket serverTransport = new TServerSocket((TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)new TServerSocket.ServerSocketTransportArgs().bindAddr(inetSocketAddress)).backlog(backlog)).clientTimeout(readTimeout));
        TBoundedThreadPoolServer.Args serverArgs = new TBoundedThreadPoolServer.Args((TServerTransport)serverTransport, this.conf);
        ((TThreadPoolServer.Args)((TThreadPoolServer.Args)serverArgs.processor(processor)).transportFactory(transportFactory)).protocolFactory(protocolFactory);
        return new TBoundedThreadPoolServer(serverArgs, this.metrics);
    }

    protected TProtocolFactory getProtocolFactory() {
        TCompactProtocol.Factory protocolFactory;
        if (this.conf.getBoolean("hbase.regionserver.thrift.compact", false)) {
            LOG.debug("Using compact protocol");
            protocolFactory = new TCompactProtocol.Factory();
        } else {
            LOG.debug("Using binary protocol");
            protocolFactory = new TBinaryProtocol.Factory();
        }
        return protocolFactory;
    }

    protected ExecutorService createExecutor(BlockingQueue<Runnable> callQueue, int minWorkers, int maxWorkers) {
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(true);
        tfb.setNameFormat("thrift-worker-%d");
        THBaseThreadPoolExecutor threadPool = new THBaseThreadPoolExecutor(minWorkers, maxWorkers, Long.MAX_VALUE, TimeUnit.SECONDS, callQueue, tfb.build(), this.metrics);
        threadPool.allowCoreThreadTimeOut(true);
        return threadPool;
    }

    protected InetAddress getBindAddress(Configuration conf) throws UnknownHostException {
        String bindAddressStr = conf.get("hbase.regionserver.thrift.ipaddress", "0.0.0.0");
        return InetAddress.getByName(bindAddressStr);
    }

    public static void registerFilters(Configuration conf) {
        String[] filters = conf.getStrings("hbase.thrift.filters");
        Splitter splitter = Splitter.on((char)':');
        if (filters != null) {
            for (String filterClass : filters) {
                List filterPart = splitter.splitToList((CharSequence)filterClass);
                if (filterPart.size() != 2) {
                    LOG.warn("Invalid filter specification " + filterClass + " - skipping");
                    continue;
                }
                ParseFilter.registerFilter((String)((String)filterPart.get(0)), (String)((String)filterPart.get(1)));
            }
        }
    }

    protected void addOptions(Options options) {
        options.addOption("b", "bind", true, "Address to bind the Thrift server to. [default: 0.0.0.0]");
        options.addOption("p", "port", true, "Port to bind to [default: 9090]");
        options.addOption("f", "framed", false, "Use framed transport");
        options.addOption("c", "compact", false, "Use the compact protocol");
        options.addOption("h", "help", false, "Print help information");
        options.addOption("s", "selectors", true, "How many selector threads to use.");
        options.addOption(null, "infoport", true, "Port for web UI");
        options.addOption("m", "minWorkers", true, "The minimum number of worker threads for " + ImplType.THREAD_POOL.simpleClassName());
        options.addOption("w", "workers", true, "The maximum number of worker threads for " + ImplType.THREAD_POOL.simpleClassName());
        options.addOption("q", "queue", true, "The maximum number of queued requests in " + ImplType.THREAD_POOL.simpleClassName());
        options.addOption("k", "keepAliveSec", true, "The amount of time in secods to keep a thread alive when idle in " + ImplType.THREAD_POOL.simpleClassName());
        options.addOption("t", "readTimeout", true, "Amount of time in milliseconds before a server thread will timeout waiting for client to send data on a connected socket. Currently, only applies to TBoundedThreadPoolServer");
        options.addOptionGroup(ImplType.createOptionGroup());
    }

    protected void parseCommandLine(CommandLine cmd, Options options) throws Shell.ExitCodeException {
        try {
            if (cmd.hasOption("port")) {
                int listenPort = Integer.parseInt(cmd.getOptionValue("port"));
                this.conf.setInt("hbase.regionserver.thrift.port", listenPort);
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Could not parse the value provided for the port option", (Throwable)e);
            this.printUsageAndExit(options, -1);
        }
        try {
            if (cmd.hasOption("infoport")) {
                String val = cmd.getOptionValue("infoport");
                this.conf.setInt("hbase.thrift.info.port", Integer.parseInt(val));
                LOG.debug("Web UI port set to " + val);
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Could not parse the value provided for the infoport option", (Throwable)e);
            this.printUsageAndExit(options, -1);
        }
        ThriftServer.optionToConf(cmd, "minWorkers", this.conf, "hbase.thrift.minWorkerThreads");
        ThriftServer.optionToConf(cmd, "workers", this.conf, "hbase.thrift.maxWorkerThreads");
        ThriftServer.optionToConf(cmd, "queue", this.conf, "hbase.thrift.maxQueuedRequests");
        ThriftServer.optionToConf(cmd, "keepAliveSec", this.conf, "hbase.thrift.threadKeepAliveTimeSec");
        ThriftServer.optionToConf(cmd, "readTimeout", this.conf, "hbase.thrift.server.socket.read.timeout");
        ThriftServer.optionToConf(cmd, "selectors", this.conf, "hbase.thrift.selector.num");
        boolean compact2 = cmd.hasOption("compact") || this.conf.getBoolean("hbase.regionserver.thrift.compact", false);
        this.conf.setBoolean("hbase.regionserver.thrift.compact", compact2);
        boolean framed = cmd.hasOption("framed") || this.conf.getBoolean("hbase.regionserver.thrift.framed", false);
        this.conf.setBoolean("hbase.regionserver.thrift.framed", framed);
        ThriftServer.optionToConf(cmd, "bind", this.conf, "hbase.regionserver.thrift.ipaddress");
        ImplType.setServerImpl(cmd, this.conf);
    }

    protected void processOptions(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            return;
        }
        Options options = new Options();
        this.addOptions(options);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("help")) {
            this.printUsageAndExit(options, 1);
        }
        this.parseCommandLine(cmd, options);
    }

    public void stop() {
        if (this.infoServer != null) {
            LOG.info("Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception ex) {
                LOG.error("Failed to stop infoServer", (Throwable)ex);
            }
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        if (this.tserver != null) {
            this.tserver.stop();
            this.tserver = null;
        }
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
                this.httpServer = null;
            }
            catch (Exception e) {
                LOG.error("Problem encountered in shutting down HTTP server", (Throwable)e);
            }
            this.httpServer = null;
        }
    }

    protected static void optionToConf(CommandLine cmd, String option, Configuration conf, String destConfKey) {
        if (cmd.hasOption(option)) {
            String value = cmd.getOptionValue(option);
            LOG.info("Set configuration key:" + destConfKey + " value:" + value);
            conf.set(destConfKey, value);
        }
    }

    public int run() throws Exception {
        return this.run(null);
    }

    public int run(String[] strings) throws Exception {
        this.processOptions(strings);
        this.setupParamters();
        this.startInfoServer();
        if (this.httpEnabled) {
            this.setupHTTPServer();
            this.httpServer.start();
            this.httpServer.join();
        } else {
            this.setupServer();
            this.tserver.serve();
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        LOG.info("***** STARTING service '" + ThriftServer.class.getSimpleName() + "' *****");
        VersionInfo.logVersion();
        Configuration conf = HBaseConfiguration.create();
        int status = ToolRunner.run((Configuration)conf, (Tool)new ThriftServer(conf), (String[])args);
        LOG.info("***** STOPPING service '" + ThriftServer.class.getSimpleName() + "' *****");
        System.exit(status);
    }
}

