/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.LogQueryFilter;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.thrift.HBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.ThriftUtilities;
import org.apache.hadoop.hbase.thrift2.generated.TAccessControlEntity;
import org.apache.hadoop.hbase.thrift2.generated.TAppend;
import org.apache.hadoop.hbase.thrift2.generated.TColumnFamilyDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TCompareOperator;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.thrift2.generated.THRegionLocation;
import org.apache.hadoop.hbase.thrift2.generated.TIOError;
import org.apache.hadoop.hbase.thrift2.generated.TIllegalArgument;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TLogQueryFilter;
import org.apache.hadoop.hbase.thrift2.generated.TNamespaceDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TOnlineLogRecord;
import org.apache.hadoop.hbase.thrift2.generated.TPermissionScope;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TRowMutations;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.thrift2.generated.TServerName;
import org.apache.hadoop.hbase.thrift2.generated.TTableDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TTableName;
import org.apache.hadoop.hbase.thrift2.generated.TThriftServerType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ThriftHBaseServiceHandler
extends HBaseServiceHandler
implements THBaseService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftHBaseServiceHandler.class);
    private final AtomicInteger nextScannerId = new AtomicInteger(0);
    private final Map<Integer, ResultScanner> scannerMap = new ConcurrentHashMap<Integer, ResultScanner>();
    private static final IOException ioe = new DoNotRetryIOException("Thrift Server is in Read-only mode.");
    private boolean isReadOnly;

    public ThriftHBaseServiceHandler(Configuration conf, UserProvider userProvider) throws IOException {
        super(conf, userProvider);
        this.isReadOnly = conf.getBoolean("hbase.thrift.readonly", false);
    }

    @Override
    protected Table getTable(ByteBuffer tableName) {
        try {
            return this.connectionCache.getTable(Bytes.toString((byte[])TBaseHelper.byteBufferToByteArray((ByteBuffer)tableName)));
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    private RegionLocator getLocator(ByteBuffer tableName) {
        try {
            return this.connectionCache.getRegionLocator(TBaseHelper.byteBufferToByteArray((ByteBuffer)tableName));
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    private void closeTable(Table table) throws TIOError {
        try {
            table.close();
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    private TIOError getTIOError(IOException e) {
        TIOErrorWithCause err = new TIOErrorWithCause(e);
        err.setCanRetry(!(e instanceof DoNotRetryIOException));
        err.setMessage(e.getMessage());
        return err;
    }

    private int addScanner(ResultScanner scanner) {
        int id = this.nextScannerId.getAndIncrement();
        this.scannerMap.put(id, scanner);
        return id;
    }

    private ResultScanner getScanner(int id) {
        return this.scannerMap.get(id);
    }

    protected ResultScanner removeScanner(int id) {
        return this.scannerMap.remove(id);
    }

    @Override
    public boolean exists(ByteBuffer table, TGet get2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            boolean bl = htable.exists(ThriftUtilities.getFromThrift(get2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<Boolean> existsAll(ByteBuffer table, List<TGet> gets) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            boolean[] exists2 = htable.exists(ThriftUtilities.getsFromThrift(gets));
            ArrayList<Boolean> result = new ArrayList<Boolean>(exists2.length);
            for (boolean exist : exists2) {
                result.add(exist);
            }
            ArrayList<Boolean> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult get(ByteBuffer table, TGet get2) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.get(ThriftUtilities.getFromThrift(get2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<TResult> getMultiple(ByteBuffer table, List<TGet> gets) throws TIOError, TException {
        Table htable = this.getTable(table);
        try {
            List<TResult> list = ThriftUtilities.resultsFromHBase(htable.get(ThriftUtilities.getsFromThrift(gets)));
            return list;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void put(ByteBuffer table, TPut put2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.put(ThriftUtilities.putFromThrift(put2));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public boolean checkAndPut(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, ByteBuffer value, TPut put2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            Table.CheckAndMutateBuilder builder = htable.checkAndMutate(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family)).qualifier(TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier));
            if (value == null) {
                boolean bl = builder.ifNotExists().thenPut(ThriftUtilities.putFromThrift(put2));
                return bl;
            }
            boolean bl = builder.ifEquals(TBaseHelper.byteBufferToByteArray((ByteBuffer)value)).thenPut(ThriftUtilities.putFromThrift(put2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void putMultiple(ByteBuffer table, List<TPut> puts) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.put(ThriftUtilities.putsFromThrift(puts));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public void deleteSingle(ByteBuffer table, TDelete deleteSingle2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.delete(ThriftUtilities.deleteFromThrift(deleteSingle2));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<TDelete> deleteMultiple(ByteBuffer table, List<TDelete> deletes) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.delete(ThriftUtilities.deletesFromThrift(deletes));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkAndMutate(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, TCompareOperator compareOp, ByteBuffer value, TRowMutations rowMutations) throws TIOError, TException {
        this.checkReadOnlyMode();
        try (Table htable = this.getTable(table);){
            boolean bl = htable.checkAndMutate(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family)).qualifier(TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier)).ifMatches(ThriftUtilities.compareOpFromThrift(compareOp), TBaseHelper.byteBufferToByteArray((ByteBuffer)value)).thenMutate(ThriftUtilities.rowMutationsFromThrift(rowMutations));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public boolean checkAndDelete(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, ByteBuffer value, TDelete deleteSingle2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            Table.CheckAndMutateBuilder mutateBuilder = htable.checkAndMutate(TBaseHelper.byteBufferToByteArray((ByteBuffer)row), TBaseHelper.byteBufferToByteArray((ByteBuffer)family)).qualifier(TBaseHelper.byteBufferToByteArray((ByteBuffer)qualifier));
            if (value == null) {
                boolean bl = mutateBuilder.ifNotExists().thenDelete(ThriftUtilities.deleteFromThrift(deleteSingle2));
                return bl;
            }
            boolean bl = mutateBuilder.ifEquals(TBaseHelper.byteBufferToByteArray((ByteBuffer)value)).thenDelete(ThriftUtilities.deleteFromThrift(deleteSingle2));
            return bl;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult increment(ByteBuffer table, TIncrement increment2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.increment(ThriftUtilities.incrementFromThrift(increment2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public TResult append(ByteBuffer table, TAppend append2) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            TResult tResult = ThriftUtilities.resultFromHBase(htable.append(ThriftUtilities.appendFromThrift(append2)));
            return tResult;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public int openScanner(ByteBuffer table, TScan scan) throws TIOError, TException {
        Table htable = this.getTable(table);
        ResultScanner resultScanner = null;
        try {
            resultScanner = htable.getScanner(ThriftUtilities.scanFromThrift(scan));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
        return this.addScanner(resultScanner);
    }

    @Override
    public List<TResult> getScannerRows(int scannerId, int numRows) throws TIOError, TIllegalArgument, TException {
        ResultScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            TIllegalArgument ex = new TIllegalArgument();
            ex.setMessage("Invalid scanner Id");
            throw ex;
        }
        try {
            this.connectionCache.updateConnectionAccessTime();
            return ThriftUtilities.resultsFromHBase(scanner.next(numRows));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<TResult> getScannerResults(ByteBuffer table, TScan scan, int numRows) throws TIOError, TException {
        Table htable = this.getTable(table);
        List<TResult> results = null;
        ResultScanner scanner = null;
        try {
            scanner = htable.getScanner(ThriftUtilities.scanFromThrift(scan));
            results = ThriftUtilities.resultsFromHBase(scanner.next(numRows));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            this.closeTable(htable);
        }
        return results;
    }

    @Override
    public void closeScanner(int scannerId) throws TIOError, TIllegalArgument, TException {
        LOG.debug("scannerClose: id=" + scannerId);
        ResultScanner scanner = this.getScanner(scannerId);
        if (scanner == null) {
            String message = "scanner ID is invalid";
            LOG.warn(message);
            TIllegalArgument ex = new TIllegalArgument();
            ex.setMessage("Invalid scanner Id");
            throw ex;
        }
        scanner.close();
        this.removeScanner(scannerId);
    }

    @Override
    public void mutateRow(ByteBuffer table, TRowMutations rowMutations) throws TIOError, TException {
        this.checkReadOnlyMode();
        Table htable = this.getTable(table);
        try {
            htable.mutateRow(ThriftUtilities.rowMutationsFromThrift(rowMutations));
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            this.closeTable(htable);
        }
    }

    @Override
    public List<THRegionLocation> getAllRegionLocations(ByteBuffer table) throws TIOError, TException {
        RegionLocator locator = null;
        try {
            locator = this.getLocator(table);
            List<THRegionLocation> list = ThriftUtilities.regionLocationsFromHBase(locator.getAllRegionLocations());
            return list;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            if (locator != null) {
                try {
                    locator.close();
                }
                catch (IOException e) {
                    LOG.warn("Couldn't close the locator.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public THRegionLocation getRegionLocation(ByteBuffer table, ByteBuffer row, boolean reload) throws TIOError, TException {
        RegionLocator locator = null;
        try {
            locator = this.getLocator(table);
            byte[] rowBytes = TBaseHelper.byteBufferToByteArray((ByteBuffer)row);
            HRegionLocation hrl = locator.getRegionLocation(rowBytes, reload);
            THRegionLocation tHRegionLocation = ThriftUtilities.regionLocationFromHBase(hrl);
            return tHRegionLocation;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
        finally {
            if (locator != null) {
                try {
                    locator.close();
                }
                catch (IOException e) {
                    LOG.warn("Couldn't close the locator.", (Throwable)e);
                }
            }
        }
    }

    private void checkReadOnlyMode() throws TIOError {
        if (this.isReadOnly()) {
            throw this.getTIOError(ioe);
        }
    }

    private boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public TTableDescriptor getTableDescriptor(TTableName table) throws TIOError, TException {
        try {
            TableName tableName = ThriftUtilities.tableNameFromThrift(table);
            TableDescriptor tableDescriptor = this.connectionCache.getAdmin().getDescriptor(tableName);
            return ThriftUtilities.tableDescriptorFromHBase(tableDescriptor);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<TTableDescriptor> getTableDescriptors(List<TTableName> tables) throws TIOError, TException {
        try {
            List<TableName> tableNames = ThriftUtilities.tableNamesFromThrift(tables);
            List tableDescriptors = this.connectionCache.getAdmin().listTableDescriptors(tableNames);
            return ThriftUtilities.tableDescriptorsFromHBase(tableDescriptors);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public boolean tableExists(TTableName tTableName) throws TIOError, TException {
        try {
            TableName tableName = ThriftUtilities.tableNameFromThrift(tTableName);
            return this.connectionCache.getAdmin().tableExists(tableName);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<TTableDescriptor> getTableDescriptorsByPattern(String regex, boolean includeSysTables) throws TIOError, TException {
        try {
            Pattern pattern = regex == null ? null : Pattern.compile(regex);
            List tableDescriptors = this.connectionCache.getAdmin().listTableDescriptors(pattern, includeSysTables);
            return ThriftUtilities.tableDescriptorsFromHBase(tableDescriptors);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<TTableDescriptor> getTableDescriptorsByNamespace(String name) throws TIOError, TException {
        try {
            List descriptors = this.connectionCache.getAdmin().listTableDescriptorsByNamespace(Bytes.toBytes((String)name));
            return ThriftUtilities.tableDescriptorsFromHBase(descriptors);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<TTableName> getTableNamesByPattern(String regex, boolean includeSysTables) throws TIOError, TException {
        try {
            Pattern pattern = regex == null ? null : Pattern.compile(regex);
            TableName[] tableNames = this.connectionCache.getAdmin().listTableNames(pattern, includeSysTables);
            return ThriftUtilities.tableNamesFromHBase(tableNames);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<TTableName> getTableNamesByNamespace(String name) throws TIOError, TException {
        try {
            TableName[] tableNames = this.connectionCache.getAdmin().listTableNamesByNamespace(name);
            return ThriftUtilities.tableNamesFromHBase(tableNames);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void createTable(TTableDescriptor desc, List<ByteBuffer> splitKeys) throws TIOError, TException {
        try {
            TableDescriptor descriptor = ThriftUtilities.tableDescriptorFromThrift(desc);
            byte[][] split = ThriftUtilities.splitKeyFromThrift(splitKeys);
            if (split != null) {
                this.connectionCache.getAdmin().createTable(descriptor, split);
            } else {
                this.connectionCache.getAdmin().createTable(descriptor);
            }
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void deleteTable(TTableName tableName) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            this.connectionCache.getAdmin().deleteTable(table);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void truncateTable(TTableName tableName, boolean preserveSplits) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            this.connectionCache.getAdmin().truncateTable(table, preserveSplits);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void enableTable(TTableName tableName) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            this.connectionCache.getAdmin().enableTable(table);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void disableTable(TTableName tableName) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            this.connectionCache.getAdmin().disableTable(table);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public boolean isTableEnabled(TTableName tableName) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            return this.connectionCache.getAdmin().isTableEnabled(table);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public boolean isTableDisabled(TTableName tableName) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            return this.connectionCache.getAdmin().isTableDisabled(table);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public boolean isTableAvailable(TTableName tableName) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            return this.connectionCache.getAdmin().isTableAvailable(table);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public boolean isTableAvailableWithSplit(TTableName tableName, List<ByteBuffer> splitKeys) throws TIOError, TException {
        throw new NotImplementedException("isTableAvailableWithSplit not supported");
    }

    @Override
    public void addColumnFamily(TTableName tableName, TColumnFamilyDescriptor column) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            ColumnFamilyDescriptor columnFamilyDescriptor = ThriftUtilities.columnFamilyDescriptorFromThrift(column);
            this.connectionCache.getAdmin().addColumnFamily(table, columnFamilyDescriptor);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void deleteColumnFamily(TTableName tableName, ByteBuffer column) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            this.connectionCache.getAdmin().deleteColumnFamily(table, column.array());
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void modifyColumnFamily(TTableName tableName, TColumnFamilyDescriptor column) throws TIOError, TException {
        try {
            TableName table = ThriftUtilities.tableNameFromThrift(tableName);
            ColumnFamilyDescriptor columnFamilyDescriptor = ThriftUtilities.columnFamilyDescriptorFromThrift(column);
            this.connectionCache.getAdmin().modifyColumnFamily(table, columnFamilyDescriptor);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void modifyTable(TTableDescriptor desc) throws TIOError, TException {
        try {
            TableDescriptor descriptor = ThriftUtilities.tableDescriptorFromThrift(desc);
            this.connectionCache.getAdmin().modifyTable(descriptor);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void createNamespace(TNamespaceDescriptor namespaceDesc) throws TIOError, TException {
        try {
            NamespaceDescriptor descriptor = ThriftUtilities.namespaceDescriptorFromThrift(namespaceDesc);
            this.connectionCache.getAdmin().createNamespace(descriptor);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void modifyNamespace(TNamespaceDescriptor namespaceDesc) throws TIOError, TException {
        try {
            NamespaceDescriptor descriptor = ThriftUtilities.namespaceDescriptorFromThrift(namespaceDesc);
            this.connectionCache.getAdmin().modifyNamespace(descriptor);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public void deleteNamespace(String name) throws TIOError, TException {
        try {
            this.connectionCache.getAdmin().deleteNamespace(name);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public TNamespaceDescriptor getNamespaceDescriptor(String name) throws TIOError, TException {
        try {
            NamespaceDescriptor descriptor = this.connectionCache.getAdmin().getNamespaceDescriptor(name);
            return ThriftUtilities.namespaceDescriptorFromHBase(descriptor);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<String> listNamespaces() throws TIOError, TException {
        try {
            String[] namespaces = this.connectionCache.getAdmin().listNamespaces();
            ArrayList<String> result = new ArrayList<String>(namespaces.length);
            for (String ns : namespaces) {
                result.add(ns);
            }
            return result;
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public TThriftServerType getThriftServerType() {
        return TThriftServerType.TWO;
    }

    @Override
    public String getClusterId() throws TException {
        return this.connectionCache.getClusterId();
    }

    @Override
    public List<TOnlineLogRecord> getSlowLogResponses(Set<TServerName> tServerNames, TLogQueryFilter tLogQueryFilter) throws TIOError, TException {
        try {
            Set<ServerName> serverNames = ThriftUtilities.getServerNamesFromThrift(tServerNames);
            LogQueryFilter logQueryFilter = ThriftUtilities.getSlowLogQueryFromThrift(tLogQueryFilter);
            List onlineLogRecords = this.connectionCache.getAdmin().getSlowLogResponses(serverNames, logQueryFilter);
            return ThriftUtilities.getSlowLogRecordsFromHBase(onlineLogRecords);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public List<Boolean> clearSlowLogResponses(Set<TServerName> tServerNames) throws TIOError, TException {
        Set<ServerName> serverNames = ThriftUtilities.getServerNamesFromThrift(tServerNames);
        try {
            return this.connectionCache.getAdmin().clearSlowLogResponses(serverNames);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    @Override
    public boolean grant(TAccessControlEntity info) throws TIOError, TException {
        Permission.Action[] actions = ThriftUtilities.permissionActionsFromString(info.actions);
        try {
            if (info.scope == TPermissionScope.NAMESPACE) {
                AccessControlClient.grant((Connection)this.connectionCache.getAdmin().getConnection(), (String)info.getNsName(), (String)info.getUsername(), (Permission.Action[])actions);
            } else if (info.scope == TPermissionScope.TABLE) {
                TableName tableName = TableName.valueOf((String)info.getTableName());
                AccessControlClient.grant((Connection)this.connectionCache.getAdmin().getConnection(), (TableName)tableName, (String)info.getUsername(), null, null, (Permission.Action[])actions);
            }
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw this.getTIOError((IOException)t);
            }
            throw this.getTIOError((IOException)new DoNotRetryIOException(t.getMessage()));
        }
        return true;
    }

    @Override
    public boolean revoke(TAccessControlEntity info) throws TIOError, TException {
        Permission.Action[] actions = ThriftUtilities.permissionActionsFromString(info.actions);
        try {
            if (info.scope == TPermissionScope.NAMESPACE) {
                AccessControlClient.revoke((Connection)this.connectionCache.getAdmin().getConnection(), (String)info.getNsName(), (String)info.getUsername(), (Permission.Action[])actions);
            } else if (info.scope == TPermissionScope.TABLE) {
                TableName tableName = TableName.valueOf((String)info.getTableName());
                AccessControlClient.revoke((Connection)this.connectionCache.getAdmin().getConnection(), (TableName)tableName, (String)info.getUsername(), null, null, (Permission.Action[])actions);
            }
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw this.getTIOError((IOException)t);
            }
            throw this.getTIOError((IOException)new DoNotRetryIOException(t.getMessage()));
        }
        return true;
    }

    @Override
    public List<TNamespaceDescriptor> listNamespaceDescriptors() throws TIOError, TException {
        try {
            NamespaceDescriptor[] descriptors = this.connectionCache.getAdmin().listNamespaceDescriptors();
            return ThriftUtilities.namespaceDescriptorsFromHBase(descriptors);
        }
        catch (IOException e) {
            throw this.getTIOError(e);
        }
    }

    private static class TIOErrorWithCause
    extends TIOError {
        private Throwable cause;

        public TIOErrorWithCause(Throwable cause) {
            this.cause = cause;
        }

        public synchronized Throwable getCause() {
            return this.cause;
        }

        @Override
        public boolean equals(Object other) {
            if (super.equals(other) && other instanceof TIOErrorWithCause) {
                Throwable otherCause = ((TIOErrorWithCause)other).getCause();
                if (this.getCause() != null) {
                    return otherCause != null && this.getCause().equals(otherCause);
                }
                return otherCause == null;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
            return result;
        }
    }
}

