/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.thrift2.client.ThriftAdmin;
import org.apache.hadoop.hbase.thrift2.client.ThriftClientBuilder;
import org.apache.hadoop.hbase.thrift2.client.ThriftTable;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ThriftConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftConnection.class);
    private Configuration conf;
    private User user;
    private HttpClient httpClient;
    private boolean httpClientCreated = false;
    private boolean isClosed = false;
    private String host;
    private int port;
    private boolean isFramed = false;
    private boolean isCompact = false;
    ThriftClientBuilder clientBuilder;
    private int operationTimeout;
    private int connectTimeout;

    public ThriftConnection(Configuration conf, ExecutorService pool, User user, Map<String, byte[]> connectionAttributes) throws IOException {
        this.conf = conf;
        this.user = user;
        this.host = conf.get("hbase.thrift.server.name");
        this.port = conf.getInt("hbase.thrift.server.port", -1);
        Preconditions.checkArgument((this.port > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.host != null ? 1 : 0) != 0);
        this.isFramed = conf.getBoolean("hbase.regionserver.thrift.framed", false);
        this.isCompact = conf.getBoolean("hbase.regionserver.thrift.compact", false);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.connectTimeout = conf.getInt("hbase.ipc.client.socket.timeout.connect", 10000);
        String className = conf.get("hbase.thrift.client.builder.class", DefaultThriftClientBuilder.class.getName());
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(ThriftConnection.class);
            constructor.setAccessible(true);
            this.clientBuilder = (ThriftClientBuilder)constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public synchronized void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isFramed() {
        return this.isFramed;
    }

    public boolean isCompact() {
        return this.isCompact;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public Admin getAdmin() throws IOException {
        Pair<THBaseService.Client, TTransport> client = this.clientBuilder.getClient();
        return new ThriftAdmin((THBaseService.Client)client.getFirst(), (TTransport)client.getSecond(), this.conf);
    }

    public synchronized HttpClient getHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        int retry = this.conf.getInt("hbase.client.retries.number", 15);
        long pause = this.conf.getLong("hbase.client.pause", 5L);
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(this.getConnectTimeout());
        requestBuilder = requestBuilder.setSocketTimeout(this.getOperationTimeout());
        builder.setRetryHandler((HttpRequestRetryHandler)new DelayRetryHandler(retry, pause));
        builder.setDefaultRequestConfig(requestBuilder.build());
        this.httpClient = builder.build();
        this.httpClientCreated = true;
        return this.httpClient;
    }

    public synchronized void close() throws IOException {
        if (this.httpClient != null && this.httpClientCreated) {
            HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public TableBuilder getTableBuilder(final TableName tableName, ExecutorService pool) {
        return new TableBuilder(){

            public TableBuilder setOperationTimeout(int timeout) {
                return this;
            }

            public TableBuilder setRpcTimeout(int timeout) {
                return this;
            }

            public TableBuilder setReadRpcTimeout(int timeout) {
                return this;
            }

            public TableBuilder setWriteRpcTimeout(int timeout) {
                return this;
            }

            public TableBuilder setRequestAttribute(String key, byte[] value) {
                return this;
            }

            public Table build() {
                try {
                    Pair<THBaseService.Client, TTransport> client = ThriftConnection.this.clientBuilder.getClient();
                    return new ThriftTable(tableName, (THBaseService.Client)client.getFirst(), (TTransport)client.getSecond(), ThriftConnection.this.conf);
                }
                catch (IOException ioE) {
                    throw new RuntimeException(ioE);
                }
            }
        };
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        throw new NotImplementedException("batchCoprocessorService not supported in ThriftTable");
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        throw new NotImplementedException("batchCoprocessorService not supported in ThriftTable");
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        throw new NotImplementedException("batchCoprocessorService not supported in ThriftTable");
    }

    public void clearRegionLocationCache() {
        throw new NotImplementedException("clearRegionLocationCache not supported in ThriftTable");
    }

    public AsyncConnection toAsyncConnection() {
        throw new NotImplementedException("toAsyncConnection not supported in ThriftTable");
    }

    public String getClusterId() {
        try {
            Pair<THBaseService.Client, TTransport> client = this.clientBuilder.getClient();
            return ((THBaseService.Client)client.getFirst()).getClusterId();
        }
        catch (IOException | TException e) {
            LOG.error("Error fetching cluster ID: ", e);
            return null;
        }
    }

    public static class DelayRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private long pause;

        public DelayRetryHandler(int retryCount, long pause) {
            super(retryCount, true, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, SSLException.class));
            this.pause = pause;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount > 1 && this.pause > 0L) {
                try {
                    long sleepTime = ConnectionUtils.getPauseTime((long)this.pause, (int)(executionCount - 1));
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            return super.retryRequest(exception, executionCount, context);
        }

        protected boolean handleAsIdempotent(HttpRequest request) {
            return true;
        }
    }

    public static class HTTPThriftClientBuilder
    extends ThriftClientBuilder {
        Map<String, String> customHeader = new HashMap<String, String>();

        public HTTPThriftClientBuilder(ThriftConnection connection) {
            super(connection);
        }

        public void addCostumHeader(String key, String value) {
            this.customHeader.put(key, value);
        }

        @Override
        public Pair<THBaseService.Client, TTransport> getClient() throws IOException {
            Preconditions.checkArgument((boolean)this.connection.getHost().startsWith("http"), (Object)"http client host must start with http or https");
            String url = this.connection.getHost() + ":" + this.connection.getPort();
            try {
                THttpClient httpClient = new THttpClient(url, this.connection.getHttpClient());
                for (Map.Entry<String, String> header : this.customHeader.entrySet()) {
                    httpClient.setCustomHeader(header.getKey(), header.getValue());
                }
                httpClient.open();
                TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
                THBaseService.Client client = new THBaseService.Client((TProtocol)prot);
                return new Pair((Object)client, (Object)httpClient);
            }
            catch (TTransportException e) {
                throw new IOException(e);
            }
        }
    }

    public static class DefaultThriftClientBuilder
    extends ThriftClientBuilder {
        @Override
        public Pair<THBaseService.Client, TTransport> getClient() throws IOException {
            TSocket tTransport = null;
            try {
                TSocket sock = new TSocket(this.connection.getHost(), this.connection.getPort());
                sock.setSocketTimeout(this.connection.getOperationTimeout());
                sock.setConnectTimeout(this.connection.getConnectTimeout());
                tTransport = sock;
                if (this.connection.isFramed()) {
                    tTransport = new TFramedTransport((TTransport)tTransport);
                }
                sock.open();
            }
            catch (TTransportException e) {
                throw new IOException(e);
            }
            Object prot = this.connection.isCompact() ? new TCompactProtocol((TTransport)tTransport) : new TBinaryProtocol((TTransport)tTransport);
            THBaseService.Client client = new THBaseService.Client((TProtocol)prot);
            return new Pair((Object)client, (Object)tTransport);
        }

        public DefaultThriftClientBuilder(ThriftConnection connection) {
            super(connection);
        }
    }
}

