/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class MasterAddressTracker
extends ZKNodeTracker {
    public MasterAddressTracker(ZKWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getZNodePaths().masterAddressZNode, abortable);
    }

    public ServerName getMasterAddress() {
        return this.getMasterAddress(false);
    }

    public int getMasterInfoPort() {
        try {
            ZooKeeperProtos.Master master = MasterAddressTracker.parse(this.getData(false));
            if (master == null) {
                return 0;
            }
            return master.getInfoPort();
        }
        catch (DeserializationException e) {
            LOG.warn("Failed parse master zk node data", (Throwable)e);
            return 0;
        }
    }

    public int getBackupMasterInfoPort(ServerName sn) {
        String backupZNode = ZNodePaths.joinZNode((String)this.watcher.getZNodePaths().backupMasterAddressesZNode, (String)sn.toString());
        try {
            byte[] data = ZKUtil.getData(this.watcher, backupZNode);
            ZooKeeperProtos.Master backup = MasterAddressTracker.parse(data);
            if (backup == null) {
                return 0;
            }
            return backup.getInfoPort();
        }
        catch (Exception e) {
            LOG.warn("Failed to get backup master: " + sn + "'s info port.", (Throwable)e);
            return 0;
        }
    }

    public ServerName getMasterAddress(boolean refresh) {
        try {
            return ProtobufUtil.parseServerNameFrom((byte[])super.getData(refresh));
        }
        catch (DeserializationException e) {
            LOG.warn("Failed parse", (Throwable)e);
            return null;
        }
    }

    public static ServerName getMasterAddress(ZKWatcher zkw) throws KeeperException, IOException {
        byte[] data;
        try {
            data = ZKUtil.getData(zkw, zkw.getZNodePaths().masterAddressZNode);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (data == null) {
            throw new IOException("Can't get master address from ZooKeeper; znode data == null");
        }
        try {
            return ProtobufUtil.parseServerNameFrom((byte[])data);
        }
        catch (DeserializationException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
    }

    public static int getMasterInfoPort(ZKWatcher zkw) throws KeeperException, IOException {
        byte[] data;
        try {
            data = ZKUtil.getData(zkw, zkw.getZNodePaths().masterAddressZNode);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (data == null) {
            throw new IOException("Can't get master address from ZooKeeper; znode data == null");
        }
        try {
            return MasterAddressTracker.parse(data).getInfoPort();
        }
        catch (DeserializationException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
    }

    public static boolean setMasterAddress(ZKWatcher zkw, String znode, ServerName master, int infoPort) throws KeeperException {
        return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, MasterAddressTracker.toByteArray(master, infoPort));
    }

    public boolean hasMaster() {
        return super.getData(false) != null;
    }

    static byte[] toByteArray(ServerName sn, int infoPort) {
        ZooKeeperProtos.Master.Builder mbuilder = ZooKeeperProtos.Master.newBuilder();
        HBaseProtos.ServerName.Builder snbuilder = HBaseProtos.ServerName.newBuilder();
        snbuilder.setHostName(sn.getHostname());
        snbuilder.setPort(sn.getPort());
        snbuilder.setStartCode(sn.getStartcode());
        mbuilder.setMaster(snbuilder.build());
        mbuilder.setRpcVersion(0);
        mbuilder.setInfoPort(infoPort);
        return ProtobufUtil.prependPBMagic((byte[])mbuilder.build().toByteArray());
    }

    public static ZooKeeperProtos.Master parse(byte[] data) throws DeserializationException {
        if (data == null) {
            return null;
        }
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        try {
            return (ZooKeeperProtos.Master)ZooKeeperProtos.Master.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public static boolean deleteIfEquals(ZKWatcher zkw, String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        try {
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch(zkw, zkw.getZNodePaths().masterAddressZNode, stat);
            ServerName sn = ProtobufUtil.parseServerNameFrom((byte[])data);
            if (sn != null && content.equals(sn.toString())) {
                return ZKUtil.deleteNode(zkw, zkw.getZNodePaths().masterAddressZNode, stat.getVersion());
            }
        }
        catch (KeeperException e) {
            LOG.warn("Can't get or delete the master znode", (Throwable)e);
        }
        catch (DeserializationException e) {
            LOG.warn("Can't get or delete the master znode", (Throwable)e);
        }
        return false;
    }
}

