/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.helix.ConfigScope;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.util.StringTemplate;
import org.apache.log4j.Logger;

public class ConfigAccessor {
    private static Logger LOG = Logger.getLogger(ConfigAccessor.class);
    private static final StringTemplate template = new StringTemplate();
    private final ZkClient zkClient;

    public ConfigAccessor(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public String get(ConfigScope scope, String key) {
        if (scope == null || scope.getScope() == null) {
            LOG.error((Object)"Scope can't be null");
            return null;
        }
        String value = null;
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String scopeStr = scope.getScopeStr();
        String[] splits = scopeStr.split("\\|");
        ZNRecord record = (ZNRecord)this.zkClient.readData(splits[0], true);
        if (record != null) {
            if (splits.length == 1) {
                value = record.getSimpleField(key);
            } else if (splits.length == 2 && record.getMapField(splits[1]) != null) {
                value = record.getMapField(splits[1]).get(key);
            }
        }
        return value;
    }

    public void set(ConfigScope scope, String key, String value) {
        if (scope == null || scope.getScope() == null) {
            LOG.error((Object)"Scope can't be null");
            return;
        }
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String scopeStr = scope.getScopeStr();
        String[] splits = scopeStr.split("\\|");
        String id = splits[0].substring(splits[0].lastIndexOf(47) + 1);
        ZNRecord update = new ZNRecord(id);
        if (splits.length == 1) {
            update.setSimpleField(key, value);
        } else if (splits.length == 2) {
            if (update.getMapField(splits[1]) == null) {
                update.setMapField(splits[1], new TreeMap<String, String>());
            }
            update.getMapField(splits[1]).put(key, value);
        }
        ZKUtil.createOrUpdate(this.zkClient, splits[0], update, true, true);
    }

    public void remove(ConfigScope scope, String key) {
        if (scope == null || scope.getScope() == null) {
            LOG.error((Object)"Scope can't be null");
            return;
        }
        String clusterName = scope.getClusterName();
        if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String scopeStr = scope.getScopeStr();
        String[] splits = scopeStr.split("\\|");
        String id = splits[0].substring(splits[0].lastIndexOf(47) + 1);
        ZNRecord update = new ZNRecord(id);
        if (splits.length == 1) {
            update.setSimpleField(key, "");
        } else if (splits.length == 2) {
            if (update.getMapField(splits[1]) == null) {
                update.setMapField(splits[1], new TreeMap<String, String>());
            }
            update.getMapField(splits[1]).put(key, "");
        }
        ZKUtil.subtract(this.zkClient, splits[0], update);
    }

    public List<String> getKeys(ConfigScope.ConfigScopeProperty type, String clusterName, String ... keys) {
        if (type == null || clusterName == null) {
            LOG.error((Object)"clusterName|scope can't be null");
            return Collections.emptyList();
        }
        try {
            if (!ZKUtil.isClusterSetup(clusterName, this.zkClient)) {
                LOG.error((Object)("cluster " + clusterName + " is not setup yet"));
                return Collections.emptyList();
            }
            Object[] args = new String[1 + keys.length];
            args[0] = clusterName;
            System.arraycopy(keys, 0, args, 1, keys.length);
            String scopeStr = template.instantiate(type, (String[])args);
            String[] splits = scopeStr.split("\\|");
            ArrayList<String> retKeys = null;
            if (splits.length == 1) {
                retKeys = this.zkClient.getChildren(splits[0]);
            } else {
                ZNRecord record = (ZNRecord)this.zkClient.readData(splits[0]);
                if (splits[1].startsWith("SIMPLEKEYS")) {
                    retKeys = new ArrayList<String>(record.getSimpleFields().keySet());
                } else if (splits[1].startsWith("MAPKEYS")) {
                    retKeys = new ArrayList<String>(record.getMapFields().keySet());
                } else if (splits[1].startsWith("MAPMAPKEYS")) {
                    retKeys = new ArrayList<String>(record.getMapField(splits[2]).keySet());
                }
            }
            if (retKeys == null) {
                LOG.error((Object)("Invalid scope: " + (Object)((Object)type) + " or keys: " + Arrays.toString(args)));
                return Collections.emptyList();
            }
            Collections.sort(retKeys);
            return retKeys;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    static {
        template.addEntry(ConfigScope.ConfigScopeProperty.CLUSTER, 1, "/{clusterName}/CONFIGS/CLUSTER");
        template.addEntry(ConfigScope.ConfigScopeProperty.CLUSTER, 2, "/{clusterName}/CONFIGS/CLUSTER/{clusterName}|SIMPLEKEYS");
        template.addEntry(ConfigScope.ConfigScopeProperty.PARTICIPANT, 1, "/{clusterName}/CONFIGS/PARTICIPANT");
        template.addEntry(ConfigScope.ConfigScopeProperty.PARTICIPANT, 2, "/{clusterName}/CONFIGS/PARTICIPANT/{participantName}|SIMPLEKEYS");
        template.addEntry(ConfigScope.ConfigScopeProperty.RESOURCE, 1, "/{clusterName}/CONFIGS/RESOURCE");
        template.addEntry(ConfigScope.ConfigScopeProperty.RESOURCE, 2, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}|SIMPLEKEYS");
        template.addEntry(ConfigScope.ConfigScopeProperty.PARTITION, 2, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}|MAPKEYS");
        template.addEntry(ConfigScope.ConfigScopeProperty.PARTITION, 3, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}|MAPMAPKEYS|{partitionName}");
    }
}

