/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.ConfigScopeBuilder;
import org.apache.helix.util.StringTemplate;
import org.apache.log4j.Logger;

public class ConfigScope {
    private static Logger LOG = Logger.getLogger(ConfigScope.class);
    private static final List<ConfigScopeProperty> scopePriority = new ArrayList<ConfigScopeProperty>();
    private static final Map<ConfigScopeProperty, Map<ConfigScopeProperty, ConfigScopeProperty>> scopeTransition = new HashMap<ConfigScopeProperty, Map<ConfigScopeProperty, ConfigScopeProperty>>();
    private static final StringTemplate template = new StringTemplate();
    private final String _clusterName;
    private final ConfigScopeProperty _scope;
    private final String _scopeStr;

    ConfigScope(ConfigScopeBuilder configScopeBuilder) {
        Map<ConfigScopeProperty, String> scopeMap = configScopeBuilder.getScopeMap();
        ArrayList<String> keys = new ArrayList<String>();
        ConfigScopeProperty curScope = null;
        for (ConfigScopeProperty scope : scopePriority) {
            if (!scopeMap.containsKey((Object)scope)) continue;
            if (curScope == null && scope == ConfigScopeProperty.CLUSTER) {
                keys.add(scopeMap.get((Object)scope));
                curScope = ConfigScopeProperty.CLUSTER;
                continue;
            }
            if (curScope == null) {
                throw new IllegalArgumentException("Missing CLUSTER scope. Can't build scope using " + configScopeBuilder);
            }
            if (!scopeTransition.containsKey((Object)curScope) || !scopeTransition.get((Object)curScope).containsKey((Object)scope)) {
                throw new IllegalArgumentException("Can't build scope using " + configScopeBuilder);
            }
            keys.add(scopeMap.get((Object)scope));
            curScope = scopeTransition.get((Object)curScope).get((Object)scope);
        }
        if (curScope == ConfigScopeProperty.CLUSTER) {
            keys.add(scopeMap.get((Object)ConfigScopeProperty.CLUSTER));
        }
        String scopeStr = template.instantiate(curScope, keys.toArray(new String[0]));
        this._clusterName = (String)keys.get(0);
        this._scopeStr = scopeStr;
        this._scope = curScope;
    }

    public ConfigScopeProperty getScope() {
        return this._scope;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public String getScopeStr() {
        return this._scopeStr;
    }

    public String toString() {
        return super.toString() + ": " + this._scopeStr;
    }

    static {
        scopePriority.add(ConfigScopeProperty.CLUSTER);
        scopePriority.add(ConfigScopeProperty.PARTICIPANT);
        scopePriority.add(ConfigScopeProperty.RESOURCE);
        scopePriority.add(ConfigScopeProperty.PARTITION);
        scopeTransition.put(ConfigScopeProperty.CLUSTER, new HashMap());
        scopeTransition.get((Object)ConfigScopeProperty.CLUSTER).put(ConfigScopeProperty.PARTICIPANT, ConfigScopeProperty.PARTICIPANT);
        scopeTransition.get((Object)ConfigScopeProperty.CLUSTER).put(ConfigScopeProperty.RESOURCE, ConfigScopeProperty.RESOURCE);
        scopeTransition.put(ConfigScopeProperty.RESOURCE, new HashMap());
        scopeTransition.get((Object)ConfigScopeProperty.RESOURCE).put(ConfigScopeProperty.PARTITION, ConfigScopeProperty.PARTITION);
        template.addEntry(ConfigScopeProperty.CLUSTER, 2, "/{clusterName}/CONFIGS/CLUSTER/{clusterName}");
        template.addEntry(ConfigScopeProperty.PARTICIPANT, 2, "/{clusterName}/CONFIGS/PARTICIPANT/{participantName}");
        template.addEntry(ConfigScopeProperty.RESOURCE, 2, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}");
        template.addEntry(ConfigScopeProperty.PARTITION, 3, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}|{partitionName}");
    }

    public static enum ConfigScopeProperty {
        CLUSTER,
        PARTICIPANT,
        RESOURCE,
        PARTITION,
        CONSTRAINT;

    }
}

