/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.log4j.Logger;

public class ExternalViewGenerator {
    static Logger _logger = Logger.getLogger(ExternalViewGenerator.class);

    public Map<String, Map<String, Set<String>>> getRouterMapFromExternalView(List<ZNRecord> dbExternalViewList) {
        TreeMap<String, Map<String, Set<String>>> result = new TreeMap<String, Map<String, Set<String>>>();
        for (ZNRecord dbNodeView : dbExternalViewList) {
            Map<String, Map<String, String>> dbNodeStateMap = dbNodeView.getMapFields();
            for (String partitionId : dbNodeStateMap.keySet()) {
                if (!result.containsKey(partitionId)) {
                    result.put(partitionId, new TreeMap());
                }
                Map<String, String> nodeStateMap = dbNodeStateMap.get(partitionId);
                for (String nodeName : nodeStateMap.keySet()) {
                    String state = nodeStateMap.get(nodeName);
                    if (!((Map)result.get(partitionId)).containsKey(state)) {
                        ((Map)result.get(partitionId)).put(state, new TreeSet());
                    }
                    ((Set)((Map)result.get(partitionId)).get(state)).add(nodeName);
                }
            }
        }
        return result;
    }

    public List<ZNRecord> computeExternalView(Map<String, List<ZNRecord>> currentStates, List<ZNRecord> idealStates) {
        ArrayList<ZNRecord> resultList = new ArrayList<ZNRecord>();
        HashMap<String, ZNRecord> resultRoutingTable = new HashMap<String, ZNRecord>();
        if (idealStates != null) {
            for (ZNRecord idealState : idealStates) {
                ZNRecord defaultDBExternalView = new ZNRecord(idealState.getId());
                resultRoutingTable.put(idealState.getId(), defaultDBExternalView);
            }
        } else {
            assert (!currentStates.isEmpty());
            return resultList;
        }
        for (String nodeName : currentStates.keySet()) {
            List<ZNRecord> zndbStates = currentStates.get(nodeName);
            for (ZNRecord dbNodeStateRecord : zndbStates) {
                Map<String, Map<String, String>> dbStates = dbNodeStateRecord.getMapFields();
                for (String stateUnitKey : dbStates.keySet()) {
                    Map<String, String> dbPartitionStates = dbStates.get(stateUnitKey);
                    String dbName = dbPartitionStates.get(Message.Attributes.RESOURCE_NAME.toString());
                    ZNRecord partitionStatus = (ZNRecord)resultRoutingTable.get(dbName);
                    if (partitionStatus == null) {
                        partitionStatus = new ZNRecord(dbName);
                        resultRoutingTable.put(dbName, partitionStatus);
                    }
                    String currentStateKey = CurrentState.CurrentStateProperty.CURRENT_STATE.toString();
                    if (!partitionStatus.getMapFields().containsKey(stateUnitKey)) {
                        partitionStatus.setMapField(stateUnitKey, new TreeMap<String, String>());
                    }
                    partitionStatus.getMapField(stateUnitKey).put(nodeName, dbPartitionStates.get(currentStateKey));
                }
            }
        }
        for (ZNRecord record : resultRoutingTable.values()) {
            resultList.add(record);
        }
        return resultList;
    }
}

