/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.LiveInstance;
import org.apache.log4j.Logger;

public class CompatibilityCheckStage
extends AbstractBaseStage {
    private static final Logger LOG = Logger.getLogger((String)CompatibilityCheckStage.class.getName());
    private static final Map<String, Boolean> INCOMPATIBLE_MAP;

    private String getPrimaryVersion(String version) {
        String[] splits = version.split("\\.");
        if (splits == null || splits.length != 3) {
            return null;
        }
        return version.substring(0, version.lastIndexOf(46));
    }

    private boolean isCompatible(String controllerVersion, String participantVersion) {
        if (participantVersion == null) {
            LOG.warn((Object)"Missing version of participant. Skip version check.");
            return true;
        }
        String controllerPrimaryVersion = this.getPrimaryVersion(controllerVersion);
        String participantPrimaryVersion = this.getPrimaryVersion(participantVersion);
        if (controllerPrimaryVersion != null && participantPrimaryVersion != null) {
            if (controllerPrimaryVersion.compareTo(participantPrimaryVersion) < 0) {
                LOG.info((Object)"Controller primary version is less than participant primary version.");
                return false;
            }
            if (INCOMPATIBLE_MAP.containsKey(controllerPrimaryVersion + "," + participantPrimaryVersion)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void process(ClusterEvent event) throws Exception {
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (manager == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires HelixManager | DataCache");
        }
        String controllerVersion = manager.getVersion();
        if (controllerVersion == null) {
            String errorMsg = "Missing version of controller: " + manager.getInstanceName() + ". Pipeline will not continue.";
            LOG.error((Object)errorMsg);
            throw new StageException(errorMsg);
        }
        Map<String, LiveInstance> liveInstanceMap = cache.getLiveInstances();
        for (LiveInstance liveInstance : liveInstanceMap.values()) {
            String participantVersion = liveInstance.getHelixVersion();
            if (this.isCompatible(controllerVersion, participantVersion)) continue;
            String errorMsg = "cluster manager versions are incompatible; pipeline will not continue. controller:" + manager.getInstanceName() + ", controllerVersion:" + controllerVersion + "; participant:" + liveInstance.getInstanceName() + ", participantVersion:" + participantVersion;
            LOG.error((Object)errorMsg);
            throw new StageException(errorMsg);
        }
    }

    static {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("0.4,0.3", false);
        INCOMPATIBLE_MAP = Collections.unmodifiableMap(map);
    }
}

