/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.log4j.Logger;

public class ExternalViewComputeStage
extends AbstractBaseStage {
    private static Logger log = Logger.getLogger(ExternalViewComputeStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        log.info((Object)"START ExternalViewComputeStage.process()");
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.toString());
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (manager == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires ClusterManager|RESOURCES|DataCache");
        }
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.toString());
        ArrayList<ExternalView> newExtViews = new ArrayList<ExternalView>();
        ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
        for (String resourceName : resourceMap.keySet()) {
            Map curExtViews;
            ExternalView curExtView;
            ExternalView view = new ExternalView(resourceName);
            Resource resource = (Resource)resourceMap.get(resourceName);
            if (resource.getBucketSize() > 0) {
                view.setBucketSize(resource.getBucketSize());
            } else {
                view.setBucketSize(currentStateOutput.getBucketSize(resourceName));
            }
            for (Partition partition : resource.getPartitions()) {
                Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
                if (currentStateMap == null || currentStateMap.size() <= 0) continue;
                for (String instance : currentStateMap.keySet()) {
                    view.setState(partition.getPartitionName(), instance, currentStateMap.get(instance));
                }
            }
            ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute("clusterStatusMonitor");
            if (clusterStatusMonitor != null) {
                clusterStatusMonitor.onExternalViewChange(view, cache._idealStateMap.get(view.getResourceName()));
            }
            if ((curExtView = (ExternalView)(curExtViews = dataAccessor.getChildValuesMap(manager.getHelixDataAccessor().keyBuilder().externalViews())).get(resourceName)) != null && curExtView.getRecord().equals(view.getRecord())) continue;
            keys.add(manager.getHelixDataAccessor().keyBuilder().externalView(resourceName));
            newExtViews.add(view);
        }
        if (newExtViews.size() > 0) {
            dataAccessor.setChildren(keys, newExtViews);
        }
        long endTime = System.currentTimeMillis();
        log.info((Object)("END ExternalViewComputeStage.process(). took: " + (endTime - startTime) + " ms"));
    }
}

